/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import org.jetbrains.annotations.NotNull;

public class OCBoxedExpressionImpl
extends OCExpressionBase
implements OCBoxedExpression {
    public OCBoxedExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitBoxedExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context2) {
        OCExpression op = this.getOperand();
        if (op == null) {
            return OCUnknownType.INSTANCE;
        }
        OCType innerType = op.getResolvedType(context2);
        if (innerType.isNumberCompatible(context2)) {
            return OCPointerType.to(OCReferenceType.fromText("NSNumber"));
        }
        if (innerType.isPointerToChar()) {
            return OCPointerType.to(OCReferenceType.fromText("NSString"));
        }
        return OCUnknownType.INSTANCE;
    }
}

