/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAssignmentExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCAssignmentExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCAssignmentExpressionImpl");

    public OCAssignmentExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        OCExpression left = this.getReceiverExpression();
        OCExpression right = this.getSourceExpression();
        if (right != null) {
            return new OCOperatorReference((PsiElement)this, name, OCOperatorReference.OperatorPlacement.INFIX, this.getOperationSignNode().getPsi(), left, right);
        }
        return null;
    }

    @Override
    @NotNull
    public OCExpression getReceiverExpression() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) {
                LOG.error("Cannot find receiver expression in assignment");
                return null;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        LOG.error("Cannot find receiver expression in assignment");
        return null;
    }

    @Override
    public OCExpression getSourceExpression() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) continue;
            return child;
        }
        throw new AssertionError((Object)"Cannot find operation sign in assignment expression");
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        return (OCElementType)this.getOperationSignNode().getElementType();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitAssignmentExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context2) {
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context2)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return ((OCFunctionSymbol)operator).getEffectiveType(this);
            }
        }
        return this.getReceiverExpression().getResolvedType(context2);
    }
}

