/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class OCSimpleIfEvaluator {
    public static Boolean evaluate(@NotNull CharSequence exprChars, @NotNull OCInclusionContext context2) {
        Queue<Term> postfix = OCSimpleIfEvaluator.parseToPostfix(exprChars, context2);
        if (postfix == null) {
            return null;
        }
        return OCSimpleIfEvaluator.evaluate(postfix, context2);
    }

    public static Queue<Term> parseToPostfix(@NotNull CharSequence exprChars, OCInclusionContext context2) {
        OCLexerSettings settings = OCLexerSettings.forContext(context2).build();
        OCLexer lexer = new OCLexer(settings);
        lexer.start(exprChars);
        LinkedList<Term> result2 = new LinkedList<Term>();
        Stack termStack = new Stack();
        boolean prevWasExpr = false;
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            String text = lexer.getTokenText();
            lexer.advance();
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) continue;
            if (OCTokenTypes.ALL_NUMERIC.contains(tt)) {
                if (prevWasExpr) {
                    return null;
                }
                result2.add(new Term(tt, text));
                prevWasExpr = true;
                continue;
            }
            if (tt == OCTokenTypes.LPAR) {
                if (prevWasExpr) {
                    return null;
                }
                termStack.push((Object)new Term(tt, text));
                continue;
            }
            if (tt == OCTokenTypes.RPAR) {
                while (!termStack.isEmpty() && ((Term)termStack.peek()).type != OCTokenTypes.LPAR) {
                    result2.add((Term)termStack.pop());
                }
                if (termStack.isEmpty() || ((Term)termStack.peek()).type != OCTokenTypes.LPAR) {
                    return null;
                }
                termStack.pop();
                prevWasExpr = true;
                continue;
            }
            if (OCSimpleIfEvaluator.isOp(tt)) {
                if (!prevWasExpr && !OCTokenTypes.UNARY_OPERATIONS.contains(tt)) {
                    return null;
                }
                boolean isBinary = OCTokenTypes.BINARY_OPERATIONS.contains(tt) && prevWasExpr;
                Term term = new Term(tt, text, isBinary);
                if (OCSimpleIfEvaluator.isOpOnTop((Stack<Term>)termStack) && isBinary) {
                    while (OCSimpleIfEvaluator.isOpOnTop((Stack<Term>)termStack) && ((Term)termStack.peek()).getPrecedence() <= term.getPrecedence()) {
                        result2.add((Term)termStack.pop());
                    }
                }
                termStack.push((Object)term);
                prevWasExpr = false;
                continue;
            }
            return null;
        }
        while (!termStack.isEmpty()) {
            result2.add((Term)termStack.pop());
        }
        return result2;
    }

    public static Boolean evaluate(@NotNull Queue<Term> postfixExpr, @NotNull OCInclusionContext context2) {
        OCExpressionEvaluator.ValueEvaluator evaluator = new OCExpressionEvaluator.ValueEvaluator((PsiElement)context2.getRootFile());
        Stack valueStack = new Stack();
        while (!postfixExpr.isEmpty()) {
            Term term = postfixExpr.poll();
            OCElementType tt = term.type;
            if (OCSimpleIfEvaluator.isOp(tt)) {
                if (OCSimpleIfEvaluator.evalOp(term, (Stack<Object>)valueStack, evaluator)) continue;
                return null;
            }
            Object value = OCElementUtil.getConstValue(tt, term.text, null, context2, context2.getProject());
            valueStack.push(value);
        }
        if (valueStack.size() != 1) {
            return null;
        }
        Object eval = valueStack.pop();
        return OCExpressionEvaluator.singAsInC(eval) != 0;
    }

    public static boolean isOp(IElementType tt) {
        return OCTokenTypes.BINARY_OPERATIONS.contains(tt) || OCTokenTypes.UNARY_OPERATIONS.contains(tt);
    }

    private static boolean isOpOnTop(Stack<Term> termStack) {
        return !termStack.isEmpty() && ((Term)termStack.peek()).type != OCTokenTypes.LPAR;
    }

    private static boolean evalOp(Term op, Stack<Object> valueStack, OCExpressionEvaluator.ValueEvaluator evaluator) {
        Object result2;
        if (valueStack.empty()) {
            return false;
        }
        Object arg1 = valueStack.pop();
        OCElementType tt = op.type;
        if (op.binaryOp) {
            if (valueStack.empty()) {
                return false;
            }
            Object arg2 = valueStack.pop();
            result2 = evaluator.evalBinary(tt, arg2, arg1);
        } else {
            result2 = evaluator.evalUnary(tt, arg1);
        }
        valueStack.push(result2);
        return true;
    }

    public static class Term {
        public final OCElementType type;
        public final String text;
        final boolean binaryOp;

        Term(IElementType type, String text) {
            this(type, text, false);
        }

        Term(IElementType type, String text, boolean binaryOp) {
            this.type = (OCElementType)type;
            this.text = text;
            this.binaryOp = binaryOp;
        }

        public int getPrecedence() {
            return this.binaryOp ? OCParenthesesUtils.getBinaryPrecedence(this.type) : OCParenthesesUtils.getPrecedence(this.type);
        }
    }
}

