/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderGuardUtil {
    public static final String DEFAULT_HEADER_GUARD_STYLE_PATTERN = "${PROJECT_NAME}_${FILE_NAME}_${EXT}";
    private static final Key<CachedValue<Ref<OCHeaderGuardInfo>>> HEADER_GUARD_CACHE = Key.create((String)"HEADER_GUARD_CACHE");
    private static final Logger LOG = Logger.getInstance(OCHeaderGuardUtil.class);

    @Nullable
    public static OCHeaderGuardInfo findCachedHeaderGuard(@NotNull PsiFile file2, boolean maybeWithoutLastEndif) {
        Ref<OCHeaderGuardInfo> cache = OCHeaderGuardUtil.getHeaderGuardCache(file2);
        if (!cache.isNull()) {
            return (OCHeaderGuardInfo)cache.get();
        }
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findHeaderGuard(file2, maybeWithoutLastEndif);
        cache.set((Object)headerGuardInfo);
        return headerGuardInfo;
    }

    public static boolean headerGuardMatchesPattern(@NotNull String headerGuardToMatch, @NotNull String filePath, @NotNull Project project2) {
        Properties builtinProperties = OCHeaderGuardUtil.getBuiltinProperties(filePath, project2);
        String uuid = StringUtil.toUpperCase((String)builtinProperties.getProperty("UUID"));
        String builtHeaderGuardName = OCHeaderGuardUtil.doBuildHeaderGuardName(builtinProperties, project2);
        Pattern headerGuardPattern = OCHeaderGuardUtil.buildHeaderGuardRegexPattern(builtHeaderGuardName, ContainerUtil.newHashMap((Pair)Pair.create((Object)uuid, (Object)"[A-F0-9]{32}"), (Pair[])new Pair[0]));
        return headerGuardPattern.matcher(headerGuardToMatch).matches();
    }

    @NotNull
    public static String buildDefaultHeaderGuardName(@NotNull String filePath, @NotNull String projectName) {
        String rawHeaderGuardName = StringUtil.join((Collection)ContainerUtil.newArrayList((Object[])new String[]{projectName, OCHeaderGuardUtil.getFileName(filePath), OCHeaderGuardUtil.getExtension(filePath)}), (String)"_");
        String headerGuard = StringUtil.toUpperCase((String)rawHeaderGuardName);
        if (!OCHeaderGuardUtil.headerGuardIsCorrect(headerGuard)) {
            return "INC_" + StringUtil.toUpperCase((String)OCHeaderGuardUtil.getRandomUUID());
        }
        return Character.isJavaIdentifierStart(headerGuard.charAt(0)) ? headerGuard : "INC_" + headerGuard;
    }

    @NotNull
    public static String buildHeaderGuardName(@NotNull String filePath, @NotNull Project project2) {
        Properties builtinProperties = OCHeaderGuardUtil.getBuiltinProperties(filePath, project2);
        return OCHeaderGuardUtil.doBuildHeaderGuardName(builtinProperties, project2);
    }

    @NotNull
    private static String doBuildHeaderGuardName(@NotNull Properties builtinProperties, @NotNull Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        String headerGuardStylePattern = settings.HEADER_GUARD_STYLE_PATTERN;
        OCHeaderGuardUtil.convertPropertiesToMacroParts(builtinProperties);
        OCHeaderGuardUtil.setDefaultValuesForDummyProperties(headerGuardStylePattern, builtinProperties, project2);
        String rawHeaderGuardName = FileTemplateUtil.mergeTemplate((Properties)builtinProperties, (String)headerGuardStylePattern, (boolean)true, null);
        String headerGuardName = rawHeaderGuardName.trim();
        if (!OCHeaderGuardUtil.headerGuardIsCorrect(headerGuardName)) {
            return "INC_" + StringUtil.toUpperCase((String)OCHeaderGuardUtil.getRandomUUID());
        }
        return Character.isJavaIdentifierStart(headerGuardName.charAt(0)) ? headerGuardName : "INC_" + headerGuardName;
    }

    @NotNull
    private static Properties getBuiltinProperties(@NotNull String filePath, @NotNull Project project2) {
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)project2).getDefaultProperties());
        properties.setProperty("FILE_NAME", OCHeaderGuardUtil.getFileName(filePath));
        properties.setProperty("EXT", OCHeaderGuardUtil.getExtension(filePath));
        properties.setProperty("PROJECT_REL_PATH", OCHeaderGuardUtil.getProjectRelativePath(filePath, project2.getBasePath()));
        properties.setProperty("UUID", OCHeaderGuardUtil.getRandomUUID());
        return properties;
    }

    @NotNull
    private static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static void convertPropertiesToMacroParts(@NotNull Properties properties) {
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            properties.setProperty(propertyName, OCHeaderGuardUtil.toMacroPart(properties.getProperty(propertyName)));
        }
    }

    private static void setDefaultValuesForDummyProperties(@NotNull String templatePattern, @NotNull Properties properties, @NotNull Project project2) {
        try {
            String[] unsetAttributes;
            for (String unsetAttribute : unsetAttributes = FileTemplateUtil.calculateAttributes((String)templatePattern, (Properties)properties, (boolean)true, (Project)project2)) {
                properties.setProperty(unsetAttribute, "");
            }
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse header guard template pattern: " + (Object)((Object)e));
        }
    }

    private static boolean headerGuardIsCorrect(@NotNull String headerGuardName) {
        String trimmedHeaderGuard = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)headerGuardName, (char)'_'), (char)'_');
        return !trimmedHeaderGuard.isEmpty() && trimmedHeaderGuard.chars().allMatch(c -> c == 95 || c == 36 || Character.isLetterOrDigit(c));
    }

    @NotNull
    private static String toMacroPart(@NotNull String str) {
        return StringUtil.toUpperCase((String)StringUtil.join((Collection)StringUtil.getWordsIn((String)str), (String)"_"));
    }

    @NotNull
    public static String getProjectRelativePath(@Nullable String filePath, @Nullable String projectPath) {
        if (StringUtil.isEmpty((String)filePath) || StringUtil.isEmpty((String)projectPath)) {
            return "";
        }
        String relativePath = FileUtil.getRelativePath((String)PathUtil.toSystemDependentName((String)projectPath), (String)PathUtil.toSystemDependentName((String)filePath), (char)File.separatorChar);
        return StringUtil.isNotEmpty((String)relativePath) ? PathUtil.getParentPath((String)relativePath) : "";
    }

    @NotNull
    private static String getFileName(@NotNull String filePath) {
        return FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)filePath));
    }

    @NotNull
    private static String getExtension(@NotNull String filePath) {
        return StringUtil.notNullize((String)PathUtil.getFileExtension((String)filePath));
    }

    @NotNull
    private static Pattern buildHeaderGuardRegexPattern(@NotNull String headerGuard, @NotNull Map<String, String> replacements) {
        String escapedHeaderGuard = StringUtil.replace((String)headerGuard, (String)"$", (String)"\\$");
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            escapedHeaderGuard = StringUtil.replace((String)escapedHeaderGuard, (String)replacement.getKey(), (String)replacement.getValue());
        }
        return Pattern.compile(escapedHeaderGuard, 32);
    }

    private static Ref<OCHeaderGuardInfo> getHeaderGuardCache(@NotNull PsiFile file2) {
        CachedValuesManager manager2 = CachedValuesManager.getManager((Project)file2.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(file2.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)Ref.create(), new Object[]{modificationTracker});
        return (Ref)manager2.getCachedValue((UserDataHolder)file2, HEADER_GUARD_CACHE, provider2, false);
    }
}

