/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCHeaderGuardDetector
extends OCRecursiveVisitor {
    @NotNull
    private State myState = State.INITIAL;
    private boolean hasPragmaOnce = false;
    private String myGuardName = null;
    private OCDirective ifndefDirective = null;
    private OCDefineDirective defineDirective = null;
    private OCDirective endifDirective = null;
    private int nestingLevel = 0;

    public boolean hasHeaderGuard(boolean maybeWithoutLastEndif) {
        return this.hasPragmaOnce || this.myState == State.AFTER_GUARD_ENDIF || maybeWithoutLastEndif && this.myState == State.AFTER_GUARD_DEFINE;
    }

    @Override
    public void visitDirective(OCDirective directive) {
        IElementType dirTokenType = OCElementUtil.getElementType(directive.getHeaderToken());
        switch (this.myState) {
            case NO_IFNDEF_GUARD: {
                return;
            }
            case INITIAL: {
                if (OCTokenTypes.IF_DIRECTIVE == dirTokenType) {
                    OCExpression operand;
                    PsiElement nextToken = OCElementUtil.getNextNonWhitespaceSibling(directive.getHeaderToken());
                    if (nextToken instanceof OCUnaryExpression && OCTokenTypes.EXCL == ((OCUnaryExpression)nextToken).getOperationSign() && (operand = ((OCUnaryExpression)nextToken).getOperand()) != null && OCTokenTypes.IDENTIFIER == OCElementUtil.getElementType(operand.getFirstChild()) && "defined".contentEquals(operand.getFirstChild().getText())) {
                        this.myGuardName = OCHeaderGuardDetector.findReferencedNameAtRight(operand.getFirstChild().getNextSibling());
                        if (this.myGuardName != null) {
                            this.myState = State.AFTER_FIRST_IFNDEF;
                            this.ifndefDirective = directive;
                            ++this.nestingLevel;
                            return;
                        }
                    }
                } else if (OCTokenTypes.IFNDEF_DIRECTIVE == dirTokenType) {
                    this.myGuardName = OCHeaderGuardDetector.findReferencedNameAtRight(directive.getHeaderToken().getNextSibling());
                    if (this.myGuardName != null) {
                        this.myState = State.AFTER_FIRST_IFNDEF;
                        this.ifndefDirective = directive;
                        ++this.nestingLevel;
                        return;
                    }
                }
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
            case AFTER_FIRST_IFNDEF: {
                String name;
                if (OCTokenTypes.DEFINE_DIRECTIVE == dirTokenType && (name = ((OCDefineDirective)((Object)directive)).getName()) != null && this.myGuardName != null && this.myGuardName.contentEquals(name)) {
                    this.myState = State.AFTER_GUARD_DEFINE;
                    this.defineDirective = (OCDefineDirective)((Object)directive);
                    return;
                }
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
            case AFTER_GUARD_DEFINE: {
                if (OCTokenTypes.IF_DIRECTIVES.contains(dirTokenType)) {
                    ++this.nestingLevel;
                } else if (OCTokenTypes.ENDIF_DIRECTIVE == dirTokenType) {
                    --this.nestingLevel;
                } else if ((OCTokenTypes.ELSE_DIRECTIVE == dirTokenType || OCTokenTypes.ELIF_DIRECTIVE == dirTokenType) && this.nestingLevel == 1) {
                    this.myState = State.NO_IFNDEF_GUARD;
                    return;
                }
                if (this.nestingLevel != 0) break;
                this.myState = State.AFTER_GUARD_ENDIF;
                this.endifDirective = directive;
                return;
            }
            case AFTER_GUARD_ENDIF: {
                this.myState = State.NO_IFNDEF_GUARD;
            }
        }
    }

    @Override
    public void visitPragma(OCPragma pragma) {
        PsiElement pragmaKindToken;
        if (this.hasPragmaOnce) {
            return;
        }
        PsiElement pragmaToken = pragma.getHeaderToken().getNextSibling();
        if (pragmaToken != null && OCElementUtil.getElementType(pragmaKindToken = OCElementUtil.getNextNonWhitespaceSibling(pragmaToken)) instanceof OCPragmaOnceContentElementType) {
            this.hasPragmaOnce = true;
            return;
        }
        super.visitPragma(pragma);
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        switch (this.myState) {
            case INITIAL: {
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
            case AFTER_FIRST_IFNDEF: {
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
            case AFTER_GUARD_ENDIF: {
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
        }
        super.visitElement(element);
    }

    @Override
    public void visitOCFile(OCFile file2) {
        for (PsiElement element : file2.getChildren()) {
            element.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
    }

    public void visitComment(@NotNull PsiComment comment) {
    }

    @Nullable
    private static String findReferencedNameAtRight(@Nullable PsiElement where) {
        if (where == null) {
            return null;
        }
        String name = null;
        boolean firstSibling = true;
        PsiElement next = where;
        while ((next = OCElementUtil.getNextNonWhitespaceSibling(next)) != null) {
            if (next instanceof OCReferenceElement) {
                PsiElement nameCandidate = PsiTreeUtil.getDeepestFirst((PsiElement)next);
                name = nameCandidate.getText();
            }
            if (!firstSibling && OCHeaderGuardDetector.isEssentialNode(next)) {
                return null;
            }
            firstSibling = false;
        }
        return name;
    }

    private static boolean isEssentialNode(@NotNull PsiElement element) {
        return !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element)) && OCElementUtil.getElementType(element) != OCTokenTypes.LPAR && OCElementUtil.getElementType(element) != OCTokenTypes.RPAR && !element.getTextRange().isEmpty();
    }

    public static boolean hasHeaderGuard(@NotNull PsiFile file2, boolean maybeWithoutLastEndif) {
        OCHeaderGuardDetector detector = OCHeaderGuardDetector.detect(file2);
        return detector.hasHeaderGuard(maybeWithoutLastEndif);
    }

    @Nullable
    public static OCHeaderGuardInfo findHeaderGuard(@NotNull PsiFile file2, boolean maybeWithoutLastEndif) {
        OCHeaderGuardDetector detector = OCHeaderGuardDetector.detect(file2);
        if (detector.myState == State.AFTER_GUARD_ENDIF || maybeWithoutLastEndif && detector.myState == State.AFTER_GUARD_DEFINE) {
            return detector.ifndefDirective != null && detector.defineDirective != null && (maybeWithoutLastEndif || detector.endifDirective != null) ? new OCHeaderGuardInfo(detector.ifndefDirective, detector.defineDirective, detector.endifDirective) : null;
        }
        return null;
    }

    @NotNull
    private static OCHeaderGuardDetector detect(@NotNull PsiFile file2) {
        OCHeaderGuardDetector detector = new OCHeaderGuardDetector();
        file2 = OCLanguageUtils.tryGetOCFile(file2);
        file2.accept((PsiElementVisitor)detector);
        return detector;
    }

    private static enum State {
        INITIAL,
        AFTER_FIRST_IFNDEF,
        AFTER_GUARD_DEFINE,
        AFTER_GUARD_ENDIF,
        NO_IFNDEF_GUARD;

    }
}

