/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapWalker;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class OCDefaultModuleResolver
extends OCModuleResolver {
    @Override
    protected boolean processHeaders(@NotNull OCInclusionContext context2, @NotNull List<String> moduleNameParts, @NotNull Processor<? super VirtualFile> headerProcessor) {
        if (moduleNameParts.isEmpty()) {
            return true;
        }
        if (!context2.hasRootFile()) {
            return true;
        }
        Project project2 = context2.getProject();
        VirtualFile virtualFile = context2.getRootFile().getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        OCResolveRootAndConfiguration configuration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
        OCResolveConfiguration resolveConfiguration = configuration.getConfiguration();
        if (resolveConfiguration == null) {
            return true;
        }
        String moduleName = StringUtil.join(moduleNameParts, (String)".");
        return ModuleMapWalker.buildModuleProcessor(project2).setConfiguration(resolveConfiguration).setModule(moduleName).notVisitInferredModules().process((Function1<? super ModuleMapSymbol, Boolean>)((Function1)module2 -> {
            List<VirtualFile> headers = module2.getIncludeHeaders();
            return ContainerUtil.process(headers, (Processor)headerProcessor);
        }));
    }
}

