/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class OCContextChangeBuilderImpl
implements OCContextChange,
OCContextChangeBuilder {
    private final int myOffset;
    @NotNull
    private final Map<String, OCMacroSymbol> myDefinitions = new Object2ObjectOpenHashMap();
    @NotNull
    private final Set<String> myUndefs = new HashSet<String>();
    @NotNull
    private final List<OCSymbol> mySymbols = new ArrayList<OCSymbol>();
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new HashSet<VirtualFile>();

    public OCContextChangeBuilderImpl(int offset) {
        this.myOffset = offset;
    }

    @Override
    public void define(@NotNull String name, @NotNull OCMacroSymbol macro) {
        this.myUndefs.remove(name);
        this.myDefinitions.put(name, macro);
    }

    @Override
    public void undef(@NotNull String name) {
        this.myDefinitions.remove(name);
        this.myUndefs.add(name);
    }

    @Override
    public void addSymbol(@NotNull OCSymbol symbol) {
        this.mySymbols.add(symbol);
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file2) {
        this.myProcessedFiles.add(file2);
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public void apply(@NotNull OCInclusionContext context2) {
        for (OCMacroSymbol macro : this.myDefinitions.values()) {
            context2.define(macro);
        }
        for (String name : this.myUndefs) {
            context2.undef(name);
        }
        context2.preprocessFile(null, null, 1, -1, -1, this.mySymbols, null);
        for (VirtualFile file2 : this.myProcessedFiles) {
            context2.addProcessedFile(file2);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCContextChangeBuilderImpl builder2 = (OCContextChangeBuilderImpl)o;
        if (this.myOffset != builder2.myOffset) {
            return false;
        }
        if (!this.myDefinitions.equals(builder2.myDefinitions)) {
            return false;
        }
        if (!this.myProcessedFiles.equals(builder2.myProcessedFiles)) {
            return false;
        }
        if (!this.mySymbols.equals(builder2.mySymbols)) {
            return false;
        }
        return this.myUndefs.equals(builder2.myUndefs);
    }

    public int hashCode() {
        int result2 = this.myOffset;
        result2 = 31 * result2 + this.myDefinitions.hashCode();
        result2 = 31 * result2 + this.myUndefs.hashCode();
        result2 = 31 * result2 + this.mySymbols.hashCode();
        result2 = 31 * result2 + this.myProcessedFiles.hashCode();
        return result2;
    }
}

