/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCDeclaratorParsing {
    @NotNull
    final OCParsing myParsing;
    private static final TokenSet detectParameterListTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.CONST_KEYWORD, OCTokenTypes.VOLATILE_KEYWORD, OCTokenTypes.AUTO_KEYWORD, OCTokenTypes.CONSTEXPR_CPP_KEYWORD, OCTokenTypes.TEMPLATE_CPP_KEYWORD}), OCTokenTypes.COMPOSITE_TYPE_SPECIFIERS});

    OCDeclaratorParsing(@NotNull OCParsing parsing) {
        this.myParsing = parsing;
    }

    Result parseInitOrMemberDeclarator(OCParsing.DeclarationContext context2, boolean isTypedef, OCParsing.TypeParsingResult typeParsingResult, boolean requireInitializer, boolean startsWithTypeSpecifierOrQualifier) {
        PsiBuilder.Marker declaratorMarker = this.myParsing.mark();
        if (context2 == OCParsing.DeclarationContext.STRUCT && this.tt() == OCTokenTypes.COLON) {
            this.parseBitfield();
            this.myParsing.done(declaratorMarker, OCElementTypes.DECLARATOR);
            return Result.PARSED_EMPTY;
        }
        Result result2 = this.parseDeclarator(context2, false, isTypedef, false, true, startsWithTypeSpecifierOrQualifier, typeParsingResult);
        if (!result2.isOk()) {
            declaratorMarker.drop();
            return result2;
        }
        while (this.tt() == OCTokenTypes.__ASM_KEYWORD || this.tt() == OCTokenTypes.__ATTRIBUTE_KEYWORD) {
            this.myParsing.parseGccAttributes();
        }
        this.myParsing.parseCpp11Attributes();
        if (result2 == Result.PARSED_FUNCTION && this.myParsing.myIsCppSupport) {
            if (context2 == OCParsing.DeclarationContext.STRUCT) {
                this.parseVirtSpecifierSeq();
                this.parsePureSpecifier();
            }
            if (this.tt() == OCTokenTypes.REQUIRES_CPP_KEYWORD) {
                PsiBuilder.Marker reqClause = this.myParsing.mark();
                this.myParsing.parseRequiresClause();
                this.myParsing.done(reqClause, OCElementTypes.CPP_REQUIRES_CLAUSE);
            }
            if (this.tt() == OCTokenTypes.EQ) {
                this.parseDefaultedOrDeletedFunctionBody();
            } else {
                if (this.tt() == OCTokenTypes.TRY_KEYWORD) {
                    this.advance();
                }
                if (this.tt() == OCTokenTypes.COLON && typeParsingResult.isEmpty() && (context2 == OCParsing.DeclarationContext.STRUCT || context2 == OCParsing.DeclarationContext.FILE)) {
                    this.advance();
                    this.myParsing.parseConstructorInitializationList();
                }
            }
        } else if (context2 == OCParsing.DeclarationContext.STRUCT && this.tt() == OCTokenTypes.COLON) {
            this.parseBitfield();
        } else if (result2 != Result.PARSED_FUNCTION) {
            List<String> lastDeclaratorName = this.myParsing.myLastDeclaratorName;
            boolean initializerParsed = this.parseInitializer();
            this.myParsing.myLastDeclaratorName = lastDeclaratorName;
            if (requireInitializer && !initializerParsed) {
                this.myParsing.error("Initializer expected");
            }
        }
        this.myParsing.done(declaratorMarker, OCElementTypes.DECLARATOR);
        return result2;
    }

    private void parseBitfield() {
        OCParsing.LOG.assertTrue(this.tt() == OCTokenTypes.COLON);
        this.advance();
        this.myParsing.parseConstantExpression();
        PsiBuilder.Marker init = this.myParsing.mark();
        if (this.parseBraceOrEqualsInitializer()) {
            init.drop();
        } else {
            init.rollbackTo();
        }
    }

    boolean parseInitializer() {
        if (this.myParsing.myIsCppSupport && this.tt() == OCTokenTypes.LPAR) {
            this.myParsing.parseExpressionList();
            return true;
        }
        if (this.tt() == OCTokenTypes.LBRACE || this.tt() == OCTokenTypes.EQ) {
            return this.parseBraceOrEqualsInitializer();
        }
        return false;
    }

    private boolean parseBraceOrEqualsInitializer() {
        if (this.myParsing.myIsCppSupport) {
            if (this.tt() == OCTokenTypes.EQ) {
                this.advance();
            }
        } else {
            this.myParsing.expectToken(OCTokenTypes.EQ, "'=' expected");
        }
        if (this.tt() == OCTokenTypes.LBRACE) {
            this.myParsing.parseCompoundInitializer();
            return true;
        }
        return this.myParsing.parseAssignmentExpression(false);
    }

    private void parseDefaultedOrDeletedFunctionBody() {
        OCParsing.LOG.assertTrue(this.tt() == OCTokenTypes.EQ);
        this.advance();
        if (this.tt() == OCTokenTypes.DEFAULT_KEYWORD || this.tt() == OCTokenTypes.DELETE_CPP_KEYWORD) {
            this.advance();
        } else {
            if (this.tt() == OCTokenTypes.INTEGER_LITERAL) {
                this.myParsing.error("Pure specifier is not allowed here");
            } else {
                this.myParsing.error("Unexpected initializer on function");
            }
            this.myParsing.parseAssignmentExpression(true);
        }
    }

    private void parseVirtSpecifierSeq() {
        while (true) {
            if (OCTokenTypes.CPP_VIRTUAL_SPECIFIERS.contains(this.tt())) {
                this.advance();
                continue;
            }
            if (this.tt() != OCTokenTypes.IDENTIFIER) break;
            String text = this.myParsing.getCurrentTokenText();
            if (OCTokenTypes.OVERRIDE_CPP_KEYWORD.getName().equals(text)) {
                this.myParsing.remapCurrentToken(OCTokenTypes.OVERRIDE_CPP_KEYWORD);
                this.advance();
                continue;
            }
            if (!OCTokenTypes.FINAL_CPP_KEYWORD.getName().equals(text)) break;
            this.myParsing.remapCurrentToken(OCTokenTypes.FINAL_CPP_KEYWORD);
            this.advance();
        }
    }

    private void parsePureSpecifier() {
        if (this.tt() == OCTokenTypes.EQ) {
            PsiBuilder.Marker init = this.myParsing.mark();
            this.advance();
            if (this.tt() == OCTokenTypes.INTEGER_LITERAL) {
                init.drop();
                init = this.myParsing.mark();
                this.advance();
                init.done((IElementType)OCElementTypes.LITERAL_EXPRESSION);
            } else {
                init.rollbackTo();
            }
        }
    }

    Result parseAbstractDeclarator(OCParsing.DeclarationContext context2, boolean startsWithTypeSpecifierOrQualifier, OCParsing.TypeParsingResult typeParsingResult) {
        return this.parseDeclarator(context2, true, false, false, false, startsWithTypeSpecifierOrQualifier, typeParsingResult);
    }

    Result parseDeclarator(OCParsing.DeclarationContext context2, boolean requireAbstractDeclarator, boolean isTypedef, boolean inTemplate, boolean isInitializerInParensAllowed, boolean startsWithTypeSpecifierOrQualifier, OCParsing.TypeParsingResult typeParsingResult) {
        boolean allowAbstractDeclarator = requireAbstractDeclarator || context2 == OCParsing.DeclarationContext.PARAMETER_LIST || this.myParsing.mySupportsMsvcExtensions && !this.myParsing.myIsCppSupport && context2 == OCParsing.DeclarationContext.STRUCT;
        boolean isEmpty = true;
        boolean hasTopLevelParamList = false;
        boolean hasNestedParamList = false;
        boolean hasPtrOperator = false;
        boolean hasPtrInParens = false;
        boolean couldBeFunctionCall = false;
        boolean couldBeOutOfLineDefinition = false;
        boolean hasDeclarationAttributes = this.parseDeclarationAttributes();
        if (this.myParsing.parsePtrOperator()) {
            isEmpty = false;
            hasPtrOperator = true;
        }
        if (this.tt() == OCTokenTypes.LPAR) {
            if (isEmpty && typeParsingResult == OCParsing.TypeParsingResult.UNKNOWN && !hasDeclarationAttributes) {
                couldBeFunctionCall = true;
            }
            if (this.shouldParseDeclaratorInParens(context2, requireAbstractDeclarator, allowAbstractDeclarator, typeParsingResult)) {
                this.advance();
                Result result2 = this.parseDeclarator(context2, requireAbstractDeclarator, isTypedef, inTemplate, false, startsWithTypeSpecifierOrQualifier, typeParsingResult);
                if (result2 == Result.FAIL_EMPTY) {
                    this.myParsing.error("Declarator expected");
                }
                if (result2 == Result.PARSED_EMPTY && this.tt() != OCTokenTypes.RPAR) {
                    return Result.fail(isEmpty);
                }
                this.myParsing.expectToken(OCTokenTypes.RPAR, ") expected");
                if (!result2.isEmpty()) {
                    isEmpty = false;
                }
                if (!result2.isOk()) {
                    return Result.fail(isEmpty);
                }
                if (result2 == Result.PARSED_FUNCTION || result2 == Result.PARSED_FUNCTION_PTR) {
                    hasNestedParamList = true;
                }
                if (result2 == Result.PARSED_PTR || result2 == Result.PARSED_FUNCTION_PTR) {
                    hasPtrInParens = true;
                }
            } else if (!allowAbstractDeclarator) {
                return Result.fail(isEmpty);
            }
        } else {
            while (this.tt() == OCTokenTypes.ELLIPSIS) {
                this.advance();
            }
            if (!requireAbstractDeclarator) {
                DeclaratorIdResult declaratorIdResult = this.parseDeclaratorIdExpression(context2, isTypedef, inTemplate);
                if (declaratorIdResult == DeclaratorIdResult.FAIL && !allowAbstractDeclarator) {
                    return Result.fail(isEmpty);
                }
                isEmpty = false;
                couldBeOutOfLineDefinition = declaratorIdResult == DeclaratorIdResult.QUALIFIED_ID;
            }
            this.myParsing.parseCpp11Attributes();
        }
        if (!isEmpty) {
            couldBeFunctionCall = false;
        }
        boolean shouldParseParamList = true;
        while (true) {
            if (this.tt() == OCTokenTypes.LPAR && shouldParseParamList) {
                if (!this.parseParametersAndQualifiers(context2, isInitializerInParensAllowed, couldBeFunctionCall, couldBeOutOfLineDefinition)) {
                    shouldParseParamList = false;
                } else {
                    hasTopLevelParamList = true;
                    isEmpty = false;
                }
            } else {
                if (this.tt() != OCTokenTypes.LBRACKET) break;
                this.myParsing.parseArrayDecl();
                isEmpty = false;
            }
            this.myParsing.parseCpp11Attributes();
        }
        if (this.myParsing.myIsCppSupport && this.tt() == OCTokenTypes.DEREF && startsWithTypeSpecifierOrQualifier && hasTopLevelParamList) {
            this.parseTrailingReturnType();
        }
        return Result.parsed(isEmpty, hasTopLevelParamList || hasNestedParamList, hasPtrOperator, hasPtrInParens);
    }

    private boolean parseDeclarationAttributes() {
        boolean hasDeclarationAttributes = false;
        while (true) {
            if (OCTokenTypes.__ATTRIBUTE_KEYWORD == this.tt()) {
                this.myParsing.parseGccAttributes();
                continue;
            }
            if (OCTokenTypes.__DECLSPEC_KEYWORD == this.tt()) {
                hasDeclarationAttributes |= this.myParsing.parseDeclspec();
                continue;
            }
            if (OCTokenTypes.CALL_CONVENTIONS.contains(this.tt())) {
                hasDeclarationAttributes |= this.myParsing.parseCallConvention();
                continue;
            }
            if (!this.myParsing.parseCpp11Attributes()) break;
        }
        return hasDeclarationAttributes;
    }

    private boolean parseParametersAndQualifiers(OCParsing.DeclarationContext context2, boolean isInitializerInParensAllowed, boolean couldBeFunctionCall, boolean couldBeOutOfLineDefinition) {
        if (!this.parseParameterDeclarationClause(context2, isInitializerInParensAllowed, couldBeFunctionCall, couldBeOutOfLineDefinition)) {
            return false;
        }
        if (this.myParsing.myIsCppSupport) {
            while (OCTokenTypes.TYPE_QUALIFIERS.contains(this.tt())) {
                this.advance();
            }
            if (this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.ANDAND) {
                this.advance();
            }
            if (this.tt() == OCTokenTypes.THROW_KEYWORD) {
                this.myParsing.parseExceptionSpecification();
            } else if (this.tt() == OCTokenTypes.NOEXCEPT_KEYWORD) {
                this.myParsing.parseNoexceptSpecifier();
            }
        }
        return true;
    }

    private boolean parseParameterDeclarationClause(OCParsing.DeclarationContext context2, boolean isInitializerInParensAllowed, boolean couldBeFunctionCall, boolean couldBeOutOfLineDefinition) {
        if (!this.detectParameterList(context2, isInitializerInParensAllowed, couldBeFunctionCall, couldBeOutOfLineDefinition)) {
            return false;
        }
        List<String> name = this.myParsing.myLastDeclaratorName;
        this.myParsing.enterNamespaceOfDeclarator(name);
        OCParsing.TypeParsingExpectation typeParsingExpectation = OCParsing.TypeParsingExpectation.NON_EXACT_VALUES;
        if (context2 == OCParsing.DeclarationContext.FILE || context2 == OCParsing.DeclarationContext.STRUCT || context2 == OCParsing.DeclarationContext.CODE_BLOCK) {
            typeParsingExpectation = OCParsing.TypeParsingExpectation.ANY;
        }
        this.myParsing.parseParameterList(typeParsingExpectation, false);
        this.myParsing.leaveNamespaceOfDeclarator(name);
        this.myParsing.myLastDeclaratorName = name;
        return true;
    }

    private DeclaratorIdResult parseDeclaratorIdExpression(OCParsing.DeclarationContext context2, boolean isTypedef, boolean inTemplate) {
        if (context2 == OCParsing.DeclarationContext.PARAMETER_LIST) {
            if (this.myParsing.ttOrTypeName() != OCTokenTypes.IDENTIFIER) {
                return DeclaratorIdResult.FAIL;
            }
            if (!this.myParsing.myIsInsideTypeNameParsing) {
                if (inTemplate) {
                    this.myParsing.myLocalNameScope.addTemplateValueParameter(this.myParsing.getCurrentTokenText());
                } else {
                    this.myParsing.myLocalNameScope.defineValue(this.myParsing.getCurrentTokenText(), false);
                }
            }
            this.advance();
            return DeclaratorIdResult.UNQUALIFIED_ID;
        }
        if (this.tt() != OCTokenTypes.IDENTIFIER && this.tt() != OCTokenTypes.OPERATOR_CPP_KEYWORD && this.myParsing.ttOrCppEquivalent() != OCTokenTypes.TILDE && this.tt() != OCTokenTypes.COLON2X) {
            return DeclaratorIdResult.FAIL;
        }
        if (isTypedef) {
            this.myParsing.expectIdentifier_lexerHack("Expecting type name", false, false, false, false);
        } else {
            this.myParsing.myLastDeclaratorName = Collections.singletonList(this.myParsing.getCurrentTokenText());
            List<String> ident = this.myParsing.parseQualifiedIdentifier(null, true, false, null);
            if (ident != null && ident.size() > 1) {
                this.myParsing.myLastDeclaratorName = ident;
                return DeclaratorIdResult.QUALIFIED_ID;
            }
        }
        return DeclaratorIdResult.UNQUALIFIED_ID;
    }

    private void parseTrailingReturnType() {
        OCParsing.LOG.assertTrue(this.tt() == OCTokenTypes.DEREF);
        this.advance();
        this.myParsing.myForceEagerMode = false;
        if (!this.myParsing.parseTypeExpression(OCParsing.DeclarationContext.TRAILING_RETURN_TYPE, OCParsing.TypeParsingExpectation.ANY)) {
            this.myParsing.error("Expected type");
        }
        if (this.tt() == OCTokenTypes.REQUIRES_CPP_KEYWORD) {
            PsiBuilder.Marker reqClause = this.myParsing.mark();
            this.myParsing.parseRequiresClause();
            this.myParsing.done(reqClause, OCElementTypes.CPP_REQUIRES_CLAUSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectParameterList(OCParsing.DeclarationContext context2, boolean isInitializerInParensAllowed, boolean couldBeFunctionCall, boolean couldBeOutOfLineDefinition) {
        OCParsing.LOG.assertTrue(this.tt() == OCTokenTypes.LPAR);
        if (!couldBeFunctionCall && (!this.myParsing.myIsCppSupport || context2 != OCParsing.DeclarationContext.CODE_BLOCK && context2 != OCParsing.DeclarationContext.FILE)) {
            return true;
        }
        PsiBuilder.Marker start = this.myParsing.markForDetection();
        this.advance();
        try {
            ListType result2 = this.detectListType(isInitializerInParensAllowed, couldBeOutOfLineDefinition);
            if (result2 == ListType.AMBIGUOUS) {
                boolean bl = !couldBeFunctionCall;
                return bl;
            }
            boolean bl = result2 == ListType.PARAMETER_LIST;
            return bl;
        }
        finally {
            this.myParsing.rollbackAfterDetection(start);
        }
    }

    private ListType detectListType(boolean isInitializerInParensAllowed, boolean couldBeOutOfLineDefinition) {
        while (true) {
            boolean startsWithTypeSpecifierOrQualifier;
            if (this.parseDeclarationAttributes() || this.detectParameterListToken()) {
                return ListType.PARAMETER_LIST;
            }
            boolean bl = startsWithTypeSpecifierOrQualifier = this.tt() != OCTokenTypes.IDENTIFIER && OCParsing.CPP_SPECIFIERS_FIRST.contains(this.tt());
            if (this.tt() == OCTokenTypes.RPAR) {
                this.advance();
                return ListType.AMBIGUOUS;
            }
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                return ListType.PARAMETER_LIST;
            }
            if (this.tt() == OCTokenTypes.LPAR) {
                return ListType.ARGUMENT_LIST;
            }
            if (this.tt() != OCTokenTypes.IDENTIFIER && this.tt() != OCTokenTypes.COLON2X && this.tt() != OCTokenTypes.DECLTYPE_CPP_KEYWORD && this.tt() != OCTokenTypes.TYPENAME_CPP_KEYWORD && !OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(this.tt())) break;
            boolean wasDecltypeOrTypenameKeyword = this.tt() == OCTokenTypes.DECLTYPE_CPP_KEYWORD || this.tt() == OCTokenTypes.TYPENAME_CPP_KEYWORD;
            OCParsing.TypeParsingResult typeResult = this.myParsing.parseSpecifierQualifierList(OCParsing.DeclarationContext.PARAMETER_LIST, null, false, false, false, true, OCParsing.TypeParsingExpectation.NON_EXACT_VALUES);
            if (typeResult == OCParsing.TypeParsingResult.NONE || typeResult == OCParsing.TypeParsingResult.EMPTY_TYPE_PARSED) {
                return ListType.ARGUMENT_LIST;
            }
            if (this.tt() == OCTokenTypes.LBRACE) {
                return ListType.ARGUMENT_LIST;
            }
            if (this.tt() == OCTokenTypes.IDENTIFIER || this.tt() == OCTokenTypes.ELLIPSIS) {
                return ListType.PARAMETER_LIST;
            }
            if (typeResult == OCParsing.TypeParsingResult.TYPE_PARSED) {
                if (couldBeOutOfLineDefinition) {
                    return ListType.AMBIGUOUS;
                }
                return wasDecltypeOrTypenameKeyword ? ListType.PARAMETER_LIST : ListType.ARGUMENT_LIST;
            }
            if (typeResult == OCParsing.TypeParsingResult.TYPE_PARSED_FOR_SURE && this.tt() != OCTokenTypes.LPAR) {
                return ListType.PARAMETER_LIST;
            }
            if (this.tt() == OCTokenTypes.COMMA) {
                this.advance();
                continue;
            }
            if (this.tt() == OCTokenTypes.RPAR) break;
            boolean old = this.myParsing.myIsInsideTypeNameParsing;
            this.myParsing.myIsInsideTypeNameParsing = true;
            Result declaratorResult = this.parseDeclarator(OCParsing.DeclarationContext.PARAMETER_LIST, false, false, false, false, startsWithTypeSpecifierOrQualifier, typeResult);
            this.myParsing.myIsInsideTypeNameParsing = old;
            if (!declaratorResult.isOk() || typeResult == OCParsing.TypeParsingResult.UNKNOWN && declaratorResult.isEmpty()) {
                return ListType.ARGUMENT_LIST;
            }
            if (this.tt() == OCTokenTypes.LPAR) {
                return ListType.ARGUMENT_LIST;
            }
            if (typeResult == OCParsing.TypeParsingResult.TYPE_PARSED_FOR_SURE && this.tt() == OCTokenTypes.RPAR) {
                return ListType.PARAMETER_LIST;
            }
            if (declaratorResult == Result.PARSED_FUNCTION && this.tt() == OCTokenTypes.RPAR) {
                return ListType.PARAMETER_LIST;
            }
            if (declaratorResult == Result.PARSED_PTR || declaratorResult == Result.PARSED_FUNCTION_PTR) {
                return ListType.PARAMETER_LIST;
            }
            if (this.tt() == OCTokenTypes.EQ) {
                return ListType.PARAMETER_LIST;
            }
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                if (!this.myParsing.myIsCppSupport) {
                    return ListType.PARAMETER_LIST;
                }
                this.advance();
                return this.tt() == OCTokenTypes.RPAR ? ListType.PARAMETER_LIST : ListType.ARGUMENT_LIST;
            }
            if (this.tt() != OCTokenTypes.COMMA) break;
            this.advance();
        }
        if (this.tt() == OCTokenTypes.RPAR) {
            this.advance();
            if (isInitializerInParensAllowed && (this.tt() == OCTokenTypes.SEMICOLON || this.tt() == OCTokenTypes.EQ || this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.RPAR)) {
                return ListType.ARGUMENT_LIST;
            }
            return ListType.AMBIGUOUS;
        }
        return OCParsing.CPP_SPECIFIERS_FIRST.contains(this.tt()) ? ListType.PARAMETER_LIST : ListType.ARGUMENT_LIST;
    }

    private boolean detectParameterListToken() {
        PsiBuilder.Marker start = this.myParsing.markForDetection();
        try {
            while (true) {
                if (detectParameterListTokens.contains(this.tt())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.tt() == OCTokenTypes.IDENTIFIER || this.tt() == OCTokenTypes.COLON2X || this.tt() == OCTokenTypes.DECLTYPE_CPP_KEYWORD || this.tt() == OCTokenTypes.TYPENAME_CPP_KEYWORD) {
                    this.myParsing.parseQualifiedIdentifier();
                    continue;
                }
                if (!OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(this.tt()) && this.tt() != OCTokenTypes.MUL && this.tt() != OCTokenTypes.XOR && (!this.myParsing.myIsCppSupport || this.tt() != OCTokenTypes.AND && this.tt() != OCTokenTypes.ANDAND)) break;
                this.advance();
            }
            if (this.parseDeclarationAttributes()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myParsing.rollbackAfterDetection(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldParseDeclaratorInParens(OCParsing.DeclarationContext context2, boolean requireAbstractDeclarator, boolean allowAbstractDeclarator, OCParsing.TypeParsingResult typeParsingResult) {
        if (typeParsingResult != OCParsing.TypeParsingResult.TYPE_PARSED_FOR_SURE && context2 == OCParsing.DeclarationContext.CODE_BLOCK) {
            return false;
        }
        if (typeParsingResult == OCParsing.TypeParsingResult.TYPE_PARSED_FOR_SURE && !allowAbstractDeclarator) {
            return true;
        }
        boolean preferParamList = requireAbstractDeclarator || context2 == OCParsing.DeclarationContext.PARAMETER_LIST;
        PsiBuilder.Marker start = this.myParsing.markForDetection();
        try {
            boolean bl = this.detectDeclaratorInParens(preferParamList);
            return bl;
        }
        finally {
            this.myParsing.rollbackAfterDetection(start);
        }
    }

    private boolean detectDeclaratorInParens(boolean preferParamList) {
        OCParsing.LOG.assertTrue(this.tt() == OCTokenTypes.LPAR);
        this.advance();
        this.myParsing.parseAttributes();
        if (this.tt() == OCTokenTypes.RPAR) {
            return false;
        }
        if (this.tt() == OCTokenTypes.LPAR) {
            return true;
        }
        if (this.tt() == OCTokenTypes.MUL || this.tt() == OCTokenTypes.XOR || this.myParsing.myIsCppSupport && (this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.ANDAND || this.tt() == OCTokenTypes.COLON2X)) {
            return true;
        }
        if (this.tt() == OCTokenTypes.COLON2X) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.TILDE || this.tt() == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
            return true;
        }
        if (this.tt() == OCTokenTypes.ELLIPSIS) {
            if (!this.myParsing.myIsCppSupport) {
                return false;
            }
            this.advance();
            return this.tt() != OCTokenTypes.RPAR;
        }
        if (this.tt() == OCTokenTypes.IDENTIFIER || this.tt() == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
            boolean isParam;
            return !preferParamList || !(isParam = this.myParsing.parseParameterDeclaration(false, OCParsing.TypeParsingExpectation.ONLY_TYPES)) || this.tt() != OCTokenTypes.RPAR && this.tt() != OCTokenTypes.COMMA && this.tt() != OCTokenTypes.ELLIPSIS;
        }
        return false;
    }

    boolean tryParseStructuredBinding(boolean isTemplate) {
        PsiBuilder.Marker start = this.myParsing.mark();
        if (this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.ANDAND) {
            this.advance();
        }
        if (isTemplate) {
            this.myParsing.error("Structured binding cannot be template");
        }
        if (this.tt() == OCTokenTypes.LBRACKET && this.parseIdentifierListInBrackets()) {
            start.drop();
            if (this.tt() != OCTokenTypes.COLON && !this.parseInitializer()) {
                this.myParsing.error("Initializer expected");
            }
            return true;
        }
        start.rollbackTo();
        return false;
    }

    private boolean parseIdentifierListInBrackets() {
        OCParsing.LOG.assertTrue(this.tt() == OCTokenTypes.LBRACKET);
        this.advance();
        while (true) {
            if (this.tt() == OCTokenTypes.IDENTIFIER) {
                PsiBuilder.Marker declarator = this.myParsing.mark();
                this.myParsing.myLocalNameScope.defineValue(this.myParsing.getCurrentTokenText(), false);
                this.advance();
                this.myParsing.done(declarator, OCElementTypes.DECLARATOR);
            } else {
                this.myParsing.error("Expected identifier");
            }
            if (this.tt() == OCTokenTypes.RBRACKET) {
                this.advance();
                return true;
            }
            if (this.tt() != OCTokenTypes.COMMA) break;
            this.advance();
        }
        return false;
    }

    private IElementType tt() {
        return this.myParsing.tt();
    }

    private void advance() {
        this.myParsing.advance();
    }

    private static enum ListType {
        PARAMETER_LIST,
        ARGUMENT_LIST,
        AMBIGUOUS;

    }

    private static enum DeclaratorIdResult {
        FAIL,
        UNQUALIFIED_ID,
        QUALIFIED_ID;

    }

    static enum Result {
        PARSED_NOPTR,
        PARSED_PTR,
        PARSED_FUNCTION,
        PARSED_FUNCTION_PTR,
        PARSED_EMPTY,
        FAIL,
        FAIL_EMPTY;


        public boolean isOk() {
            return this != FAIL && this != FAIL_EMPTY;
        }

        public boolean isEmpty() {
            return this == PARSED_EMPTY || this == FAIL_EMPTY;
        }

        public static Result parsed(boolean isEmpty, boolean hasParamList, boolean hasPtrOperator, boolean hasPtrInParens) {
            if (isEmpty) {
                return PARSED_EMPTY;
            }
            if (hasParamList) {
                if (hasPtrInParens) {
                    return PARSED_FUNCTION_PTR;
                }
                return PARSED_FUNCTION;
            }
            if (hasPtrOperator || hasPtrInParens) {
                return PARSED_PTR;
            }
            return PARSED_NOPTR;
        }

        public static Result fail(boolean empty) {
            return empty ? FAIL_EMPTY : FAIL;
        }
    }
}

