/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSShortcutFixerKt;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSwitchToHeaderOrSourceRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context2) {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context2) {
        List<GotoRelatedItem> fakeItem2 = OCSwitchHSShortcutFixerKt.tryFixingShortcut(context2);
        if (fakeItem2 != null) {
            return fakeItem2;
        }
        Project project2 = (Project)context2.getData(CommonDataKeys.PROJECT);
        PsiElement element = OCSwitchToHeaderOrSourceRelatedProvider.getContextElement(context2);
        if (element == null) {
            return Collections.emptyList();
        }
        ThrowableComputable process2 = () -> (List)ReadAction.compute(() -> OCSwitchToHeaderOrSourceRelatedProvider.doGetItems(element));
        return ContainerUtil.notNullize((List)((List)ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, OCBundle.message("header.source.looking.for.the.best.file", new Object[0]), true, project2)));
    }

    @Nullable
    private static PsiElement getContextElement(@NotNull DataContext context2) {
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context2);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context2);
        if (file2 != null && editor != null) {
            PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
            if (element != null) {
                return element;
            }
            return file2;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context2);
        return element == null ? file2 : element;
    }

    @NotNull
    private static List<GotoRelatedItem> doGetItems(@NotNull PsiElement context2) {
        PsiFile file2 = context2.getContainingFile();
        OCFile target = file2 instanceof OCFile ? ((OCFile)file2).getAssociatedFile() : null;
        final NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.findCounterPartInFile(context2, target);
        if (counter != null) {
            return Collections.singletonList(new GotoRelatedItem((PsiElement)counter, target != null && target.isHeader() ? "Headers" : "Sources"){

                public void navigate() {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)counter);
                }
            });
        }
        if (target != null) {
            return Collections.singletonList(new GotoRelatedItem((PsiElement)target, target.isHeader() ? "Headers" : "Sources"));
        }
        return Collections.emptyList();
    }

    @Nullable
    private static NavigatablePsiElement getCounterPartInFile(PsiElement psi, OCFile file2) {
        OCSymbol target;
        if (!(psi instanceof OCSymbolDeclarator) || psi instanceof OCMethodSelectorPart) {
            return null;
        }
        Project project2 = psi.getProject();
        Object symbol = ((OCSymbolDeclarator)psi).getSymbol();
        OCSymbol oCSymbol = target = symbol != null ? symbol.getAssociatedSymbol(project2) : null;
        if (target != null && (file2 == null || file2.equals(target.getContainingOCFile(project2)))) {
            return (NavigatablePsiElement)target.locateDefinition(project2);
        }
        return null;
    }

    @Nullable
    private static NavigatablePsiElement findCounterPartInFile(PsiElement psi, OCFile file2) {
        while (psi != null && !(psi instanceof PsiFile)) {
            NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.getCounterPartInFile(psi, file2);
            if (counter != null) {
                return counter;
            }
            psi = psi.getParent();
        }
        return null;
    }
}

