/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoActionSync<Psi extends PsiElement>
extends OCGotoAction<Psi> {
    private final CachedValue<? extends Collection<? extends OCSymbol>> myTargets;

    public OCGotoActionSync(@NotNull Psi source, @NotNull String name, @NotNull Icon icon) {
        super(source, name, icon);
        Project project2 = source.getProject();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
        this.myTargets = cachedValuesManager.createCachedValue(() -> {
            Object currentSource = this.getSource();
            if (currentSource == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
            ModificationTracker tracker = FileSymbolTablesCache.getInstance(currentSource.getProject()).getOutOfBlockModificationTracker();
            Collection<OCSymbol> result2 = this.evaluateTargets(currentSource);
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{tracker});
        }, false);
    }

    @Override
    @Nullable
    public Collection<? extends OCSymbol> getTargets() {
        return (Collection)this.myTargets.getValue();
    }

    @NotNull
    protected abstract Collection<? extends OCSymbol> evaluateTargets(@NotNull Psi var1);

    @Override
    public void navigate(@Nullable MouseEvent mouseEvent, @Nullable Editor editor) {
        Object source = this.getSource();
        if (source == null) {
            return;
        }
        Collection targets = (Collection)OCGotoActionSync.computeUnderProgress(source.getProject(), this::getTargets);
        if (targets == null) {
            return;
        }
        if (targets.size() == 1) {
            OCSymbol target = (OCSymbol)targets.iterator().next();
            if (target != null) {
                PsiNavigateUtil.navigate((PsiElement)target.locateDefinition(source.getProject()));
            }
            return;
        }
        List<PsiElement> targetElements = OCResolveUtil.locateDefinitions(targets, source.getProject());
        if (targetElements.isEmpty()) {
            return;
        }
        PsiElement[] targetElementsArray = PsiUtilCore.toPsiElementArray(targetElements);
        PsiElementListCellRenderer<PsiElement> renderer = this.createRenderer(source, targetElementsArray);
        JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targetElementsArray, renderer, (String)this.getName());
        if (mouseEvent != null) {
            popup.show(new RelativePoint(mouseEvent));
        } else if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            OCLog.LOG.error("mouseEvent and editor are null!");
        }
    }
}

