/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMapRoot
extends HeadersRoot
implements ModuleMapAwareHeadersSearchRoot {
    @NotNull
    protected final File moduleMapFile;

    public ModuleMapRoot(@NotNull Project project2, @NotNull File moduleMapFile) {
        super(project2);
        this.moduleMapFile = moduleMapFile;
    }

    @NotNull
    public String getName() {
        return this.moduleMapFile.getName();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.findModuleMapVirtualFile();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile findModuleMapVirtualFile() {
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)this.moduleMapFile, (boolean)true);
        if (!ModuleMapUtil.checkModuleMapFile(file2)) {
            return null;
        }
        return file2;
    }

    @Override
    @NotNull
    public ModuleMapPathResolver createModuleMapPathResolver() {
        VirtualFile root = VfsUtil.findFileByIoFile((File)this.moduleMapFile.getParentFile(), (boolean)true);
        if (root == null) {
            root = new LightVirtualFile();
        }
        return new ModuleMapDefaultPathResolver(root, VfsUtilCore.getRootFile((VirtualFile)root));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return FileUtil.filesEqual((File)this.moduleMapFile, (File)((ModuleMapRoot)o).moduleMapFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.moduleMapFile);
    }
}

