/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapModules;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.IncludedHeadersRootModuleMapCollector;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapLocationProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0007\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\nH\u0002\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u0007\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\nH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u0012\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e*\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u001f"}, d2={"mainFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;", "getMainFile", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;)Lcom/intellij/openapi/vfs/VirtualFile;", "possibleModuleMapLocations", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "getPossibleModuleMapLocations", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/util/Collection;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;)Ljava/util/Collection;", "checkModuleMapFile", "", "file", "forceLoadModuleMapFile", "Lcom/jetbrains/cidr/lang/modulemap/psi/ModuleMapFile;", "moduleMapFile", "project", "Lcom/intellij/openapi/project/Project;", "createModuleMapPathResolver", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapPathResolver;", "findModuleMapVirtualFile", "getDeclaredModules", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapModules;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getMainFrameworkModule", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "getPublicHeadersToInclude", "", "intellij.c"})
@JvmName(name="ModuleMapUtil")
public final class ModuleMapUtil {
    @Contract(value="null -> false")
    public static final boolean checkModuleMapFile(@Nullable VirtualFile file2) {
        return file2 != null && file2.isValid() && !file2.isDirectory();
    }

    @Nullable
    public static final ModuleMapFile forceLoadModuleMapFile(@NotNull VirtualFile moduleMapFile, @NotNull Project project2) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiFile psi = psiManager.findFile(moduleMapFile);
        if (psi instanceof ModuleMapFile) {
            return (ModuleMapFile)psi;
        }
        try {
            String text = VfsUtilCore.loadText((VirtualFile)moduleMapFile);
            return ModuleMapFileImpl.createFromText(text, psiManager);
        }
        catch (IOException e) {
            OCLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static final ModuleMapModules getDeclaredModules(@NotNull HeadersSearchRoot $this$getDeclaredModules, @Nullable OCResolveConfiguration configuration) {
        return ModuleMapManager.Companion.getInstance($this$getDeclaredModules.getProject()).cacheFor(configuration).getModules($this$getDeclaredModules);
    }

    @Nullable
    public static final VirtualFile getMainFile(@NotNull AppleFramework $this$mainFile) {
        ModuleMapSymbol moduleMapSymbol = ModuleMapUtil.getMainFrameworkModule($this$mainFile, null);
        return moduleMapSymbol != null ? moduleMapSymbol.getUmbrellaHeaderVirtualFile() : null;
    }

    @Nullable
    public static final ModuleMapSymbol getMainFrameworkModule(@NotNull AppleFramework $this$getMainFrameworkModule, @Nullable OCResolveConfiguration configuration) {
        ModuleMap moduleMap = ModuleMapManager.Companion.getInstance($this$getMainFrameworkModule.getProject()).cacheFor(configuration).getModuleMap($this$getMainFrameworkModule);
        return moduleMap != null ? moduleMap.findModule($this$getMainFrameworkModule.getName()) : null;
    }

    @NotNull
    public static final List<VirtualFile> getPublicHeadersToInclude(@NotNull AppleFramework $this$getPublicHeadersToInclude) {
        Object object = ModuleMapUtil.getMainFrameworkModule($this$getPublicHeadersToInclude, null);
        if (object == null || (object = object.getIncludeHeaders()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final VirtualFile findModuleMapVirtualFile(IncludedHeadersRoot $this$findModuleMapVirtualFile) {
        VirtualFile virtualFile = $this$findModuleMapVirtualFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile includeDir = virtualFile;
        if (!includeDir.isValid()) {
            ModuleMapLog.LOG.error("Invalid included headers root: " + (Object)((Object)$this$findModuleMapVirtualFile));
            return null;
        }
        VirtualFile defaultFile = includeDir.findChild("module.modulemap");
        if (ModuleMapUtil.checkModuleMapFile(defaultFile)) {
            return defaultFile;
        }
        VirtualFile legacyFile = includeDir.findChild("module.map");
        if (ModuleMapUtil.checkModuleMapFile(legacyFile)) {
            return legacyFile;
        }
        return null;
    }

    private static final ModuleMapPathResolver createModuleMapPathResolver(IncludedHeadersRoot $this$createModuleMapPathResolver) {
        ModuleMapPathResolver moduleMapPathResolver;
        VirtualFile virtualFile = $this$createModuleMapPathResolver.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            moduleMapPathResolver = new ModuleMapDefaultPathResolver(it, null, 2, null);
        } else {
            moduleMapPathResolver = ModuleMapPathResolver.NULL;
        }
        return moduleMapPathResolver;
    }

    private static final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(IncludedHeadersRoot $this$possibleModuleMapLocations) {
        IncludedHeadersRootModuleMapCollector collector = new IncludedHeadersRootModuleMapCollector($this$possibleModuleMapLocations);
        HeadersSearchRoot.processUnder((PsiElementProcessor<PsiFileSystemItem>)((PsiElementProcessor)collector), $this$possibleModuleMapLocations.getVirtualFile(), false, $this$possibleModuleMapLocations.getProject());
        return collector.getRoots();
    }

    @Nullable
    public static final VirtualFile findModuleMapVirtualFile(@NotNull HeadersSearchRoot $this$findModuleMapVirtualFile) {
        HeadersSearchRoot headersSearchRoot = $this$findModuleMapVirtualFile;
        return headersSearchRoot instanceof ModuleMapAwareHeadersSearchRoot ? ((ModuleMapAwareHeadersSearchRoot)((Object)$this$findModuleMapVirtualFile)).findModuleMapVirtualFile() : (headersSearchRoot instanceof IncludedHeadersRoot ? ModuleMapUtil.findModuleMapVirtualFile((IncludedHeadersRoot)$this$findModuleMapVirtualFile) : null);
    }

    @NotNull
    public static final ModuleMapPathResolver createModuleMapPathResolver(@NotNull HeadersSearchRoot $this$createModuleMapPathResolver) {
        ModuleMapPathResolver moduleMapPathResolver;
        HeadersSearchRoot headersSearchRoot = $this$createModuleMapPathResolver;
        if (headersSearchRoot instanceof ModuleMapAwareHeadersSearchRoot) {
            moduleMapPathResolver = ((ModuleMapAwareHeadersSearchRoot)((Object)$this$createModuleMapPathResolver)).createModuleMapPathResolver();
        } else if (headersSearchRoot instanceof IncludedHeadersRoot) {
            moduleMapPathResolver = ModuleMapUtil.createModuleMapPathResolver((IncludedHeadersRoot)$this$createModuleMapPathResolver);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("An attempt to create ModuleMapPathResolver for " + (Object)((Object)$this$createModuleMapPathResolver))));
        }
        return moduleMapPathResolver;
    }

    @NotNull
    public static final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull HeadersSearchRoot $this$possibleModuleMapLocations) {
        HeadersSearchRoot headersSearchRoot = $this$possibleModuleMapLocations;
        return headersSearchRoot instanceof ModuleMapLocationProvider ? ((ModuleMapLocationProvider)((Object)$this$possibleModuleMapLocations)).getPossibleModuleMapLocations() : (headersSearchRoot instanceof IncludedHeadersRoot ? ModuleMapUtil.getPossibleModuleMapLocations((IncludedHeadersRoot)$this$possibleModuleMapLocations) : (Collection<HeadersSearchRoot>)CollectionsKt.listOf((Object)((Object)$this$possibleModuleMapLocations)));
    }
}

