/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.light.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.light.OCLightFileType;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.impl.OCPsiFileBaseImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLightFile
extends OCPsiFileBaseImpl
implements OCPsiFile {
    public OCLightFile(@NotNull FileViewProvider provider2) {
        super(provider2, OCLanguageUtils.getLightLanguage());
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return OCLightFileType.INSTANCE;
    }

    @Override
    @NotNull
    public OCFile getOCFile() {
        return (OCFile)this.getViewProvider().getPsi(OCLanguageUtils.getSlowLanguage());
    }

    @Override
    @NotNull
    public PsiElement asElementFromOCFile(@NotNull PsiElement psiElementFromThisFile) {
        assert (psiElementFromThisFile.getContainingFile() == this);
        OCFile ocFile = this.getOCFile();
        if (psiElementFromThisFile == this) {
            return ocFile;
        }
        PsiElement at = ocFile.findElementAt(psiElementFromThisFile.getTextOffset());
        assert (at != null);
        return at;
    }

    @Override
    @Nullable
    public OCParsedLanguageAndConfiguration getParsedLanguageAndConfiguration() {
        return this.getOCFile().getParsedLanguageAndConfiguration();
    }
}

