/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCCompoundInitializerChecker;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_AlwaysError;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_AlwaysOk;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCArrayType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCAutoType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCBlockPointerType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCEllipsisType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCFunctionType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCIdType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCIntType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCObjectType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCPointerType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCRealType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCReferenceType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCStructType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCStructuredBindingType;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor_OCVoidType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeCompatibilityVisitor<T extends OCType>
implements OCTypeVisitor<OCTypeCheckResult> {
    @NotNull
    protected final T mySourceType;
    @Nullable
    protected final OCTypeOwner mySource;
    @Nullable
    protected final PsiElement myContext;
    protected final boolean myAllowImplicitConversions;
    protected final boolean myAssumeNullSubstitutionsEquals;
    @NotNull
    protected final OCResolveContext myResolveContext;
    protected boolean myIsSecondStepOfCopyInit = false;
    protected boolean myIsCopyInitWithSameClass = false;

    public void setIsSecondStepOfCopyInit() {
        this.myIsSecondStepOfCopyInit = true;
    }

    public static OCTypeCheckResult checkConvertible(OCType destType, OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean allowImplicitConstructors, @NotNull OCResolveContext resolveContext) {
        OCTypeCheckResult result2 = OCTypeCompatibilityVisitor.checkConvertibleImpl(destType, sourceType, source, context2, allowImplicitConversions, allowImplicitConstructors, resolveContext);
        result2.setSourceType(sourceType);
        result2.setDestType(destType);
        result2.setSource(source);
        if (result2.getAnnotationElement() == null) {
            result2.setAnnotationElement(context2);
        }
        return result2;
    }

    private static OCTypeCheckResult checkConvertibleImpl(OCType destType, OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean allowImplicitConstructors, @NotNull OCResolveContext resolveContext) {
        OCTypeCheckResult result2;
        OCTypeCheckResult check;
        boolean usingZeroAsNil = false;
        if (sourceType instanceof OCIntType) {
            if (source instanceof OCLiteralExpression || source instanceof OCLiteralExpressionSymbol) {
                sourceType = source.getResolvedType(resolveContext);
            }
            OCPointerType destTypePtr = null;
            if (destType instanceof OCPointerType) {
                destTypePtr = (OCPointerType)destType;
            } else if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType() instanceof OCPointerType) {
                destTypePtr = (OCPointerType)((OCCppReferenceType)destType).getRefType();
            }
            if (destTypePtr != null) {
                OCType pointerType = OCExpressionEvaluator.getPointerType(source, resolveContext);
                if (pointerType instanceof OCUnknownType) {
                    if (destTypePtr.isPointerToPointerToObjectCompatible()) {
                        usingZeroAsNil = true;
                    } else if (!(destTypePtr instanceof OCArrayType) || !((OCArrayType)destTypePtr).hasLength()) {
                        return OCTypeCheckResultBuilder.createOK();
                    }
                } else if (pointerType != null) {
                    sourceType = pointerType;
                }
            }
        } else if (sourceType.isPointerToVoid() && OCExpressionEvaluator.isLikeNil(source, resolveContext)) {
            sourceType = destType;
        }
        if (source instanceof OCCompoundInitializer) {
            return OCCompoundInitializerChecker.checkCompoundInitializer((OCCompoundInitializer)source, destType, allowImplicitConversions && allowImplicitConstructors, resolveContext);
        }
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context2, allowImplicitConversions && allowImplicitConstructors, resolveContext);
        if (destType.isCppStructType(resolveContext) && TypeProperties.hasSameUnqualifiedType(sourceType, destType, resolveContext)) {
            super.setIsCopyInitWithSameClass();
        }
        if ((check = destType.accept(visitor)).getState() == OCTypeCheckState.OK) {
            return check;
        }
        if (usingZeroAsNil && source instanceof OCExpression) {
            if (OCCodeInsightUtil.isLikeNull(((OCExpression)source).getTextWithMacros())) {
                return OCTypeCheckResultBuilder.createOK();
            }
            OCTypeCheckResult result3 = new OCTypeCheckResult(OCTypeCheckState.WARNING, "Using zero as nil", OCInspections.UsingZeroAsNil.class, "CIDR", new IntentionAction[0]);
            TextRange range = OCElementUtil.getRangeWithMacros((PsiElement)source);
            OCChangeTextIntentionAction fix = new OCChangeTextIntentionAction(((PsiElement)source).getContainingFile(), range.getStartOffset(), range.getLength(), "nil", "Change to 'nil'");
            result3.addQuickFix(fix);
            return result3;
        }
        if (allowImplicitConversions && visitor.mySourceType instanceof OCStructType && (result2 = OCTypeCompatibilityVisitor.checkConversionOperators(destType, (OCStructType)visitor.mySourceType, visitor.mySource, visitor.myContext, check, context2 instanceof OCCastExpression, resolveContext)) != null) {
            return result2;
        }
        return check;
    }

    @NotNull
    protected OCTypeCheckResult validateConstPointers(OCPointerType type, @NotNull OCResolveContext context2) {
        com.jetbrains.cidr.lang.types.OCTypeCheckResult result2 = type.validateConstPointers((OCType)this.mySourceType, this.myResolveContext);
        String message = "Assigning '" + ((OCType)this.mySourceType).getName(context2) + "' to '" + type.getName(context2) + "' discards cv qualifier";
        return new OCTypeCheckResult(result2, result2.getState() == OCTypeCheckState.ERROR_IF_CPP ? message : "");
    }

    private void setIsCopyInitWithSameClass() {
        this.myIsCopyInitWithSameClass = true;
    }

    public static OCTypeCheckResult checkConversionOperators(OCType destType, OCStructType sourceType, @Nullable OCTypeOwner source, PsiElement context2, @Nullable OCTypeCheckResult bestResult, boolean isExplicitCast, @NotNull OCResolveContext resolveContext) {
        Ref result2 = Ref.create((Object)bestResult);
        if (sourceType.isSubclassOfMagic(resolveContext)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        sourceType.processMembers(null, (Processor<? super OCSymbol>)((Processor)symbol -> {
            if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isCppConversionOperator() || !isExplicitCast && ((OCFunctionSymbol)symbol).isExplicit()) {
                return true;
            }
            OCType returnType = symbol.getEffectiveResolvedType(resolveContext);
            if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType().isScalar() && !(returnType instanceof OCCppReferenceType)) {
                return true;
            }
            OCTypeCompatibilityVisitor<OCType> visitor1 = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(returnType, source, context2, false, resolveContext);
            visitor1.setIsSecondStepOfCopyInit();
            final OCTypeCheckResult curResult = destType.accept(visitor1);
            if (result2.isNull() || curResult.getState().compareTo(((OCTypeCheckResult)result2.get()).getState()) < 0 || curResult.getState() == ((OCTypeCheckResult)result2.get()).getState() && OCTypeCompatibilityVisitor.getTypesDifference(returnType, destType, resolveContext) < OCTypeCompatibilityVisitor.getTypesDifference(((OCTypeCheckResult)result2.get()).getTypeAfterConversion(), destType, resolveContext)) {
                if (curResult.getState() == OCTypeCheckState.OK) {
                    OCTypeCheckResult newResult = new OCTypeCheckResult(OCTypeCheckState.OK, curResult.getInspectionClass(), curResult.getClangID(), null, returnType, new IntentionAction[0]){

                        @Override
                        public String getMessage() {
                            return curResult.getMessage();
                        }
                    };
                    newResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                    result2.set((Object)newResult);
                } else {
                    curResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                    curResult.setConversion(null, returnType);
                    result2.set((Object)curResult);
                }
            }
            return true;
        }), resolveContext);
        return (OCTypeCheckResult)result2.get();
    }

    public static OCTypeCheckResult checkConstructors(OCStructType destType, OCType sourceType, OCTypeOwner source, @NotNull OCResolveContext context2) {
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context2.getElement(), false, context2);
        for (OCStructSymbol struct : destType.getStructs()) {
            OCTypeCheckResult result2 = OCTypeCompatibilityVisitor.processConstructors(struct, visitor.mySourceType, visitor.mySource, visitor.myContext, visitor.myResolveContext, visitor.myIsCopyInitWithSameClass);
            if (result2 == null) continue;
            return result2;
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR);
    }

    @Nullable
    public static Pair<OCType, OCFunctionSymbol> convertByOperator(@NotNull OCStructType source, boolean acceptExplicitOperators, boolean removeReferences, @NotNull OCResolveContext resolveContext, @NotNull Predicate<OCType> typesAcceptor) {
        Ref conversionOp;
        Ref convertedTy = Ref.create();
        Processor convertingProcessor = arg_0 -> OCTypeCompatibilityVisitor.lambda$convertByOperator$1(acceptExplicitOperators, resolveContext, removeReferences, typesAcceptor, convertedTy, conversionOp = Ref.create(), arg_0);
        boolean hasUniqueTargetType = source.processMembers(null, (Processor<? super OCSymbol>)convertingProcessor, resolveContext);
        if (!hasUniqueTargetType) {
            return null;
        }
        if (convertedTy.isNull() || conversionOp.isNull()) {
            return null;
        }
        return Pair.create((Object)convertedTy.get(), (Object)conversionOp.get());
    }

    protected OCTypeCompatibilityVisitor(@NotNull T sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        this.mySourceType = sourceType;
        this.myResolveContext = resolveContext;
        this.mySource = source;
        this.myContext = context2;
        this.myAllowImplicitConversions = allowImplicitConversions;
        this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
    }

    public static OCTypeCompatibilityVisitor<? extends OCType> createOCTypeCompatibilityVisitor(@Nullable OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            sourceType = OCUnknownType.INSTANCE;
        }
        return sourceType.accept(new OCTypeCompatibilityVisitorCreator(source, context2, allowImplicitConversions, true, resolveContext));
    }

    @Override
    public OCTypeCheckResult visitCppReferenceType(final OCCppReferenceType type) {
        if (!(this.mySource == null || type.isReferenceToConst() || type.isRvalueRef() || type.isUnknown() || OCExprValueCategory.classify(this.mySource, this.myResolveContext).isLValue())) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR, "Expression must be lvalue", OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", new IntentionAction[0]);
        }
        OCType refType = type.getRefType();
        if (!(!refType.isScalar() && !((OCType)this.mySourceType).isScalar() || refType.isConst() || type.isRvalueRef() || refType instanceof OCEllipsisType || this.myContext instanceof OCCastExpression || new OCTypeEqualityVisitor((OCType)this.mySourceType, true, true, this.myResolveContext).equal(refType))) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                }
            };
        }
        boolean equalOrDerivedToBase = OCTypeUtils.isSameOrDerivedFrom(this.mySourceType, type.getRefType(), this.myResolveContext);
        if (type.isRvalueRef() && equalOrDerivedToBase && !this.myIsSecondStepOfCopyInit && !(type.getTerminalType() instanceof OCMagicType) && !(type.getTerminalType() instanceof OCAutoType) && OCExprValueCategory.classify(this.mySource, this.myResolveContext).isLValue()) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR, "Expression must be rvalue", OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", new IntentionAction[0]);
        }
        if (!(!((OCType)this.mySourceType).isConst() || refType.isConst() || refType.isUnknown() || type.isRvalueRef() && !equalOrDerivedToBase)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Binding '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' to non-const reference";
                }
            };
        }
        return equalOrDerivedToBase ? OCTypeCheckResultBuilder.createOK() : this.checkRefType(type);
    }

    protected OCTypeCheckResult checkRefType(OCCppReferenceType type) {
        return type.getRefType().accept(this);
    }

    public static int getTypesDifference(@Nullable OCType type1, @Nullable OCType type2, @NotNull OCResolveContext context2) {
        if (type1 == null || type2 == null) {
            return -1;
        }
        if (type1 instanceof OCArrayType && type2 instanceof OCPointerType || type2 instanceof OCArrayType && type1 instanceof OCPointerType) {
            return 100 + OCTypeCompatibilityVisitor.getTypesDifference(((OCPointerType)type1).getRefType(), ((OCPointerType)type2).getRefType(), context2);
        }
        if (!(type2.getClass().equals(type1.getClass()) || type1.equals(OCIntType.INT, context2) && type2 instanceof OCStructType && ((OCStructType)type2).isEnum() || type2.equals(OCIntType.INT, context2) && type1 instanceof OCStructType && ((OCStructType)type1).isEnum())) {
            return 1000;
        }
        if (type1 instanceof OCIntType && type2 instanceof OCIntType) {
            OCIntType intType1 = (OCIntType)type1;
            OCIntType intType2 = (OCIntType)type2;
            int rank1 = intType1.getCTypeId().ordinal() * 2 + (intType1.isSigned() ? 0 : 1);
            int rank2 = intType2.getCTypeId().ordinal() * 2 + (intType2.isSigned() ? 0 : 1);
            return Math.abs(rank1 - rank2);
        }
        if (!type2.equals(type1, context2)) {
            if (type1 instanceof OCCppReferenceType) {
                type1 = ((OCCppReferenceType)type1).getRefType();
            }
            if (type2 instanceof OCCppReferenceType) {
                type2 = ((OCCppReferenceType)type2).getRefType();
            }
            if (type2.equals(type1, false, context2)) {
                return 50;
            }
            return type1.isUnknown() || type1.isMagicInside(context2) ? 100 : 200;
        }
        return 0;
    }

    protected boolean bothTypesEquals(OCType type, OCType firstType, OCType secondType) {
        return type.equals(firstType, false, this.myResolveContext) && type.equals(secondType, false, this.myResolveContext);
    }

    protected OCTypeCheckResult visitType(final OCType type) {
        boolean unknown;
        if (this.mySourceType instanceof OCMagicType || type instanceof OCAutoType || this.mySourceType instanceof OCAutoType) {
            return OCTypeCheckResultBuilder.createOK();
        }
        boolean bl = unknown = type.isUnknown() || ((OCType)this.mySourceType).isUnknown();
        if (unknown && type.getCanonicalName(this.myResolveContext).equals(((OCType)this.mySourceType).getCanonicalName(this.myResolveContext))) {
            return OCTypeCheckResultBuilder.createOK();
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "CIDR", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' are not compatible";
            }
        };
    }

    protected String getSourceTypeName() {
        return this.mySource instanceof OCExpression ? ((OCExpression)this.mySource).findBestTypeName((OCType)this.mySourceType) : ((OCType)this.mySourceType).getName(this.myResolveContext);
    }

    @NotNull
    protected OCTypeCheckResult visitNumericType(final OCNumericType type) {
        if (this.mySourceType instanceof OCMagicType) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.mySourceType instanceof OCNumericType) {
            OCNumericType numericType = (OCNumericType)this.mySourceType;
            if (OCIntType.isBool(type, this.myResolveContext) && OCIntType.isBool(this.mySourceType, this.myResolveContext)) {
                return OCTypeCheckResultBuilder.createOK();
            }
            if (type.getRank(this.myResolveContext) < numericType.getRank(this.myResolveContext)) {
                OCTypeOwner source;
                if (this.mySource != null && this.mySourceType instanceof OCIntType && type instanceof OCIntType) {
                    Number value = OCExpressionEvaluator.evaluate(this.mySource, this.myResolveContext);
                    if (value != null && ((OCIntType)type).canRepresent(OCNumber.valueOf(value), this.myContext)) {
                        return OCTypeCheckResultBuilder.createOK();
                    }
                    if (value == null && type.getCTypeId().equals((Object)((OCIntType)this.mySourceType).getCTypeId())) {
                        return OCTypeCheckResultBuilder.createOK();
                    }
                    if (((OCIntType)this.mySourceType).getCTypeId() == CTypeId.SIZE_T) {
                        return OCTypeCheckResultBuilder.createOK();
                    }
                }
                if (this.mySource != null && this.mySourceType instanceof OCRealType && type instanceof OCRealType && (source = OCParenthesesUtils.diveIntoParentheses(this.mySource)) instanceof OCLiteralExpression && OCRealType.narrowestLiteralType(((OCLiteralExpression)source).getUnescapedLiteralText()).getRank(this.myResolveContext) == type.getRank(this.myResolveContext)) {
                    return OCTypeCheckResultBuilder.createOK();
                }
                return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.ValueMayNotFitIntoReceiver.class, "warn_impcast_integer_precision", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' may not fit into the receiver type '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "'";
                    }
                };
            }
            if (!type.isComplex() && numericType.isComplex()) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.ValueMayNotFitIntoReceiver.class, "warn_impcast_complex_scalar", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Using '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' for complex values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                    }
                };
            }
            if (!(type.isSigned() || !numericType.isSigned() || this.mySource != null && this.mySourceType instanceof OCIntType && OCExpressionEvaluator.isPositive(this.mySource, this.myResolveContext))) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.SignednessMismatch.class, "warn_impcast_integer_sign", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Using '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' for signed values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                    }
                };
            }
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.mySourceType instanceof OCStructType && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).isEnumClass()) {
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking integer from enum class '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
            }
            return OCTypeCheckResultBuilder.createOK();
        }
        if (((OCType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            if (OCIntType.isBool(type, this.myResolveContext)) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_pointer_int", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking boolean from pointer '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
            }
            if (type instanceof OCIntType) {
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_pointer_int", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking integer from pointer '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
            }
            return this.visitType(type);
        }
        return this.visitType(type);
    }

    @NotNull
    protected OCTypeCheckResult checkStructCompatibleCtor(OCStructType type) {
        for (OCStructSymbol struct : type.getStructs()) {
            OCTypeCheckResult result2 = this.processTransparentUnion(struct, type);
            if (result2 != null) {
                return result2;
            }
            if (this.myAllowImplicitConversions) {
                result2 = OCTypeCompatibilityVisitor.processConstructors(struct, this.mySourceType, this.mySource, this.myContext, this.myResolveContext, this.myIsCopyInitWithSameClass);
            }
            if (result2 == null) continue;
            return result2;
        }
        OCTypeCheckResult result3 = this.visitType(type);
        if (!result3.getState().isOK() && this.isCppClassType(type)) {
            result3.addQuickFix(this.getNewConstructorFix(type.getSymbol()));
        }
        return result3;
    }

    @NotNull
    protected OCTypeCheckResult checkAssignToEnum(OCStructType type, Computable<String> message) {
        OCTypeCheckState state = OCTypeCheckState.ERROR_IF_CPP;
        Number value = OCExpressionEvaluator.evaluate(this.mySource, this.myResolveContext);
        if (value != null && this.mySource instanceof OCExpression) {
            OCSymbol enumConst = OCExpressionEvaluator.findMatchingEnumConst(type, value.intValue(), this.myResolveContext);
            if (enumConst != null) {
                OCExpression element = OCElementFactory.expressionFromText(enumConst.getName(), (PsiElement)this.mySource, false);
                if (element != null) {
                    OCChangeElementIntentionAction quickFix = new OCChangeElementIntentionAction((PsiElement)this.mySource, (PsiElement)element, "Use constant '" + enumConst.getName() + "'", "Use enum constant");
                    final Computable finalMessage = message;
                    return new OCTypeCheckResult(state, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[]{quickFix}){

                        @Override
                        public String getMessage() {
                            return (String)finalMessage.compute();
                        }
                    };
                }
            } else {
                String typeName = type.getBestNameInContext(this.myResolveContext);
                if (value.intValue() == 0 && typeName.endsWith("Options")) {
                    return OCTypeCheckResultBuilder.createOK();
                }
                message = () -> "Enum '" + typeName + "' has no constant to represent the integer value '" + value + "'";
            }
        }
        final Computable finalMessage = message;
        return new OCTypeCheckResult(state, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return (String)finalMessage.compute();
            }
        };
    }

    @Override
    public OCTypeCheckResult visitEllipsisReferenceType(OCEllipsisType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    protected boolean isSuperTypeForFunctionChecks(OCType left, OCType right) {
        if (left.isPointerToObject() && right.isPointerToObject()) {
            return left.isCompatible(right, this.myResolveContext);
        }
        if (left instanceof OCIntType && right instanceof OCStructType && ((OCStructType)right).getKind() == OCSymbolKind.ENUM && !((OCStructType)right).isEnumClass()) {
            return true;
        }
        if (right instanceof OCIntType && left instanceof OCStructType && ((OCStructType)left).getKind() == OCSymbolKind.ENUM && !((OCStructType)left).isEnumClass()) {
            return true;
        }
        return new OCTypeEqualityAfterResolvingVisitor(right, false, true, false, true, this.myResolveContext).equal(left);
    }

    @Override
    public OCTypeCheckResult visitArrayType(OCArrayType type) {
        boolean allowArraysAssignment;
        boolean bl = allowArraysAssignment = !this.myAssumeNullSubstitutionsEquals;
        if (allowArraysAssignment && this.mySourceType instanceof OCArrayType && ((OCArrayType)this.mySourceType).getLength(this.myResolveContext) == type.getLength(this.myResolveContext)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (!type.hasLength()) {
            return (OCTypeCheckResult)this.visitPointerType(type);
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.NotAssignable.class, "err_typecheck_array_not_modifiable_lvalue", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Array is not assignable";
            }

            @Override
            public boolean canBeCasted(OCType lType, OCType rType, @NotNull OCResolveContext context2) {
                return false;
            }
        };
    }

    protected boolean isCppClassType(OCType type) {
        return ((OCFile)this.myContext.getContainingFile()).isCpp() && type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    protected OCTypeCheckResult checkArcBridgeCast(final OCPointerType type, boolean tollFreeBridge) {
        boolean isCast;
        boolean bl = isCast = this.mySource instanceof OCExpression && ((OCExpression)this.mySource).getParent() instanceof OCCastExpression;
        if (this.mySource instanceof OCLiteralExpression && ((OCType)this.mySourceType).isPointerToString()) {
            return null;
        }
        if (this.mySource instanceof OCSendMessageExpression && ((OCType)this.mySourceType).isPointerToVoid()) {
            return null;
        }
        if (type.getRefType().isVoid() && !((OCType)this.mySourceType).isPointerToObjectCompatible() && ((OCType)this.mySourceType).isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && ((OCType)this.mySourceType).isPointerToVoid() && !type.isPointerToObjectCompatible() && type.isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && (type.isPointerToObjectCompatible() || ((OCType)this.mySourceType).isPointerToObjectCompatible())) {
            if (type.isPointerToObject()) {
                OCSymbol symbol;
                if (this.mySource instanceof OCCallExpression) {
                    symbol = OCGetSymbolVisitor.getSymbol(((OCCallExpression)this.mySource).getFunctionReferenceExpression());
                } else if (this.mySource instanceof OCSendMessageExpression) {
                    symbol = ((OCSendMessageExpression)this.mySource).getProbableResponders().getKnownResponder();
                    if (symbol != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                } else {
                    symbol = OCGetSymbolVisitor.getSymbol((OCExpression)this.mySource);
                }
                if (symbol instanceof OCFunctionSymbol && symbol.hasAttribute("ImplicitBridging")) {
                    return null;
                }
                if (symbol instanceof OCPropertySymbol) {
                    return null;
                }
                if (symbol instanceof OCDeclaratorSymbol && !OCSearchScope.isInProjectSources(symbol, this.myResolveContext.getProject()) && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION) {
                    return null;
                }
            }
            OCTypeElement parent = ((OCCastExpression)((OCExpression)this.mySource).getParent()).getTypeElement();
            IElementType[] types = OCTokenTypes.BRIDGE_CAST_KEYWORDS.getTypes();
            IntentionAction[] quickFixes2 = new IntentionAction[types.length];
            for (int i2 = 0; i2 < quickFixes2.length; ++i2) {
                String tokenName = ((OCElementType)types[i2]).getName();
                quickFixes2[i2] = new OCChangeTextIntentionAction(((OCExpression)this.mySource).getContainingFile(), parent.getTextOffset(), 0, tokenName + " ", "Add \"" + tokenName + "\"", "Add the bridge cast");
            }
            return new OCTypeCheckResult(OCTypeCheckState.ERROR, "ARC bridge cast is required", OCInspections.BridgeCastIssues.class, "CIDR", quickFixes2);
        }
        if (tollFreeBridge) {
            String message = "ARC bridge cast is required for toll free bridge";
            return new OCTypeCheckResult(OCTypeCheckState.ERROR, message, OCInspections.BridgeCastIssues.class, "CIDR", new IntentionAction[0]);
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCTypeCheckResult visitBlockPointerType(OCBlockPointerType type) {
        return (OCTypeCheckResult)this.visitPointerType(type);
    }

    @Override
    public OCTypeCheckResult visitIdType(OCIdType type) {
        return (OCTypeCheckResult)this.visitObjectType(type);
    }

    @Override
    public OCTypeCheckResult visitIntType(OCIntType type) {
        return this.visitNumericType(type);
    }

    @Override
    public OCTypeCheckResult visitRealType(OCRealType type) {
        return this.visitNumericType(type);
    }

    @Override
    public OCTypeCheckResult visitReferenceType(OCReferenceType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitAutoType(OCAutoType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitStructuredBindingType(OCStructuredBindingType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitDeferredType(OCDeferredType type) {
        return type.getActualType(this.myResolveContext).accept(this);
    }

    protected OCCreateNewDefinitionIntentionAction getNewConstructorFix(OCStructSymbol struct) {
        OCExpression psiSourceExpr = this.mySource instanceof OCExpression ? (OCExpression)this.mySource : null;
        return new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, this.myContext, struct, struct.getName(), new OCFunctionType(OCVoidType.instance(), Collections.singletonList(OCExpectedTypeUtil.getExpressionType(psiSourceExpr, this.mySourceType, true))));
    }

    @Nullable
    protected static OCTypeCheckResult processConstructors(OCStructSymbol struct, OCType sourceType, OCTypeOwner source, PsiElement context2, OCResolveContext resolveContext, boolean allowImplicitConversions) {
        OCArgumentsList<OCTypeOwner> arguments = new OCArgumentsList<OCTypeOwner>(Collections.singletonList(sourceType), source != null ? Collections.singletonList(source) : null);
        OCFunctionSymbol constructor = struct.findConstructor(arguments, resolveContext, context2, allowImplicitConversions, () -> {
            if (context2 instanceof OCCallExpression) {
                OCSymbol symbol = OCGetSymbolVisitor.getSymbol(((OCCallExpression)context2).getFunctionReferenceExpression());
                return symbol instanceof OCStructSymbol || symbol != null && symbol.getKind() == OCSymbolKind.TYPEDEF;
            }
            return false;
        }, false, struct.getType()).getSymbol();
        if (constructor instanceof OCFunctionGroupSymbol && ((OCFunctionGroupSymbol)constructor).getCause() != OCFunctionGroupSymbol.Cause.Magic) {
            return null;
        }
        if (constructor != null) {
            List<OCType> types = constructor.getType().getParameterTypes();
            OCType argumentType = types.get(0).resolve(resolveContext);
            return new OCTypeCheckResult(OCTypeCheckState.OK, null, null, argumentType, struct.getType(), new IntentionAction[0]).setImplicitConstructor(constructor);
        }
        if (struct.isPredeclaration()) {
            return OCTypeCheckResultBuilder.createOK();
        }
        return null;
    }

    @Nullable
    protected OCTypeCheckResult processTransparentUnion(OCStructSymbol struct, OCStructType type) {
        if (type.getKind() != OCSymbolKind.UNION || !struct.isTransparentUnion()) {
            return null;
        }
        final Ref result2 = Ref.create(null);
        CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol> finder = new CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol>(){

            protected boolean accept(OCDeclaratorSymbol field) {
                OCTypeCheckResult curResult = OCTypeCompatibilityVisitor.checkConvertible(field.getType().resolve(OCTypeCompatibilityVisitor.this.myResolveContext), OCTypeCompatibilityVisitor.this.mySourceType, OCTypeCompatibilityVisitor.this.mySource, OCTypeCompatibilityVisitor.this.myContext, true, true, OCTypeCompatibilityVisitor.this.myResolveContext);
                if (curResult.getState() == OCTypeCheckState.OK) {
                    result2.set((Object)curResult);
                    return true;
                }
                if (!curResult.getState().isError(OCTypeCompatibilityVisitor.this.myContext) && result2.isNull()) {
                    result2.set((Object)curResult);
                }
                return false;
            }
        };
        struct.processFields((Processor<? super OCDeclaratorSymbol>)finder);
        return (OCTypeCheckResult)result2.get();
    }

    @Override
    public OCTypeCheckResult visitVariadicType(OCVariadicType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitExpansionPackType(OCExpansionPackType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitUnknownType(OCUnknownType type) {
        return this.visitMagicType(type);
    }

    @Override
    public OCTypeCheckResult visitMagicType(OCMagicType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitBracedInitListType(OCBracedInitListType type) {
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitVoidType(final OCVoidType type) {
        if (((OCType)this.mySourceType).isVoid() || this.mySourceType instanceof OCMagicType || this.myContext instanceof OCCastExpression) {
            return OCTypeCheckResultBuilder.createOK();
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' are not compatible";
            }
        };
    }

    @Override
    public OCTypeCheckResult visitTypeParameterType(OCTypeParameterType type) {
        return this.visitMagicType(type);
    }

    @NotNull
    protected OCTypeCheckResult getProtocolCompatibilityCheckResult(@NotNull OCObjectType sourceType, @NotNull OCObjectType type) {
        for (final OCProtocolSymbol protocol : type.getAllProtocols()) {
            boolean canAddPrivately;
            if (sourceType.implementsProtocol(protocol)) continue;
            OCImplementation implementation = (OCImplementation)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCImplementation.class);
            OCClassSymbol classSymbol = sourceType.getClassSymbol();
            ArrayList<OCAddSuperProtocolIntentionAction> quickfixes = new ArrayList<OCAddSuperProtocolIntentionAction>();
            if (sourceType.getInterface() != null) {
                quickfixes.add(new OCAddSuperProtocolIntentionAction(sourceType.getInterface(), protocol.getName(), false, this.myResolveContext.getProject()));
            }
            boolean bl = canAddPrivately = implementation != null && classSymbol != null && classSymbol.getName().equals(implementation.getName());
            if (canAddPrivately && sourceType.getImplementation() != null) {
                quickfixes.add(new OCAddSuperProtocolIntentionAction(sourceType.getImplementation(), protocol.getName(), true, this.myResolveContext.getProject()));
            }
            return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.NotImplementsProtocol.class, "CIDR", quickfixes.toArray(IntentionAction.EMPTY_ARRAY)){

                @Override
                public String getMessage() {
                    return "Interface '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' doesn't implement " + protocol.getNameWithKindLowercase(OCTypeCompatibilityVisitor.this.myResolveContext);
                }
            };
        }
        return OCTypeCheckResultBuilder.createOK();
    }

    private static /* synthetic */ boolean lambda$convertByOperator$1(boolean acceptExplicitOperators, OCResolveContext resolveContext, boolean removeReferences, Predicate typesAcceptor, Ref convertedTy, Ref conversionOp, OCSymbol symbol) {
        if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isCppConversionOperator() || !acceptExplicitOperators && ((OCFunctionSymbol)symbol).isExplicit()) {
            return true;
        }
        OCType retType = symbol.getEffectiveResolvedType(resolveContext);
        if (removeReferences) {
            retType = OCTypeUtils.getCppReferencedType(retType);
        }
        if (typesAcceptor.apply((Object)retType)) {
            if (convertedTy.isNull()) {
                assert (conversionOp.isNull());
                convertedTy.set((Object)retType);
                conversionOp.set((Object)((OCFunctionSymbol)symbol));
                return true;
            }
            return ((OCType)convertedTy.get()).equalsAfterResolving(retType, resolveContext);
        }
        return true;
    }

    private static class OCTypeCompatibilityVisitorCreator
    implements OCTypeVisitor<OCTypeCompatibilityVisitor<? extends OCType>> {
        private final OCTypeOwner mySource;
        @Nullable
        private final PsiElement myContext;
        private final boolean myAllowImplicitConversions;
        private final boolean myAssumeNullSubstitutionsEquals;
        @NotNull
        private final OCResolveContext myResolveContext;

        OCTypeCompatibilityVisitorCreator(@Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
            this.mySource = source;
            this.myContext = context2;
            this.myAllowImplicitConversions = allowImplicitConversions;
            this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
            this.myResolveContext = resolveContext;
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitEllipsisReferenceType(OCEllipsisType sourceType) {
            return new OCTypeCompatibilityVisitor_OCEllipsisType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitFunctionType(OCFunctionType sourceType) {
            return new OCTypeCompatibilityVisitor_OCFunctionType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitMagicType(OCMagicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCMagicType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitObjectType(OCObjectType sourceType) {
            return new OCTypeCompatibilityVisitor_OCObjectType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitArrayType(OCArrayType sourceType) {
            return new OCTypeCompatibilityVisitor_OCArrayType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitPointerType(OCPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCPointerType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitBlockPointerType(OCBlockPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCBlockPointerType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitCppReferenceType(OCCppReferenceType sourceType) {
            return sourceType.getRefType(this.myContext).accept(this);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIdType(OCIdType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIdType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIntType(OCIntType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIntType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitRealType(OCRealType sourceType) {
            return new OCTypeCompatibilityVisitor_OCRealType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitReferenceType(OCReferenceType sourceType) {
            return new OCTypeCompatibilityVisitor_OCReferenceType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitStructType(OCStructType sourceType) {
            return new OCTypeCompatibilityVisitor_OCStructType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitUnknownType(OCUnknownType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCUnknownType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVoidType(OCVoidType sourceType) {
            return new OCTypeCompatibilityVisitor_OCVoidType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitTypeParameterType(OCTypeParameterType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCTypeParameterType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitAutoType(OCAutoType sourceType) {
            return new OCTypeCompatibilityVisitor_OCAutoType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVariadicType(OCVariadicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCVariadicType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitExpansionPackType(OCExpansionPackType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCExpansionPackType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitBracedInitListType(OCBracedInitListType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysError<OCBracedInitListType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitStructuredBindingType(OCStructuredBindingType sourceType) {
            return new OCTypeCompatibilityVisitor_OCStructuredBindingType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitDeferredType(OCDeferredType sourceType) {
            return sourceType.getActualType(this.myResolveContext).accept(this);
        }
    }
}

