/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCheckResultBuilder {
    @NotNull
    public static OCTypeCheckResult createWarning(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType, IntentionAction ... fixes) {
        return OCTypeCheckResultBuilder.createAnnotation(OCTypeCheckState.WARNING, element, inspectionClass, clangID, message, highlightType, fixes);
    }

    @NotNull
    public static OCTypeCheckResult createError(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, IntentionAction ... fixes) {
        return OCTypeCheckResultBuilder.createAnnotation(OCTypeCheckState.ERROR, element, inspectionClass, clangID, message, null, fixes);
    }

    public static OCTypeCheckResult createOK() {
        return new OCTypeCheckResult(OCTypeCheckState.OK);
    }

    private static OCTypeCheckResult createAnnotation(@NotNull OCTypeCheckState state, @Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType, IntentionAction ... fixes) {
        OCTypeCheckResult result2 = new OCTypeCheckResult(state, message, inspectionClass, clangID, new IntentionAction[0]);
        result2.setAnnotationElement(element);
        for (IntentionAction fix : fixes) {
            result2.addQuickFix(fix);
        }
        result2.setHighlightType(highlightType);
        return result2;
    }
}

