/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWrapStringIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCLiteralExpression literal = OCWrapStringIntentionAction.getStringLiteral(editor, element.getContainingFile());
        return OCCodeInsightUtil.isValid(literal) && OCElementUtil.getStringLiteral(literal) != null;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return OCBundle.message("intentions.wrap.with.stringFormat", new Object[0]);
    }

    @Nullable
    private static OCLiteralExpression getStringLiteral(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCLiteralExpression.class);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile file2 = element.getContainingFile();
        OCLiteralExpression literal = OCWrapStringIntentionAction.getStringLiteral(editor, file2);
        if (literal == null) {
            return;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)OCElementFactory.expressionFromText("[NSString stringWithFormat: 0]", (PsiElement)file2);
        call.getArguments().get(0).getArgumentExpression().replace(literal);
        call = (OCSendMessageExpression)literal.replace(call);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(call.getTextRange().getEndOffset());
        }
    }
}

