/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAttributesList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCReplaceTypeWithAutoIntentionAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile file2 = element.getContainingFile();
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration == null) {
            return;
        }
        OCReplaceTypeWithAutoIntentionAction.modifyTypeElement(declaration);
        for (OCDeclarator declarator : declaration.getDeclarators()) {
            OCReplaceTypeWithAutoIntentionAction.modifyDeclarator(declarator);
        }
        OCReplaceTypeWithAutoIntentionAction.removeExtraWhitespaces(declaration.getNode());
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, declaration.getTextRange());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (DumbService.isDumb((Project)project2) || !FileSymbolTablesCache.areSymbolsLoaded(project2) || !OCCompilerFeaturesHelper.supportsCxxAutoType(file2) || !OCReplaceTypeWithAutoIntentionAction.isAvailableForElement(element)) {
            return false;
        }
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration == null || declaration instanceof OCParameterDeclaration || declaration.getDeclarators().isEmpty() || !OCReplaceTypeWithAutoIntentionAction.canTransformCodeFragment(declaration)) {
            return false;
        }
        OCType type = declaration.getDeclarators().get(0).getType();
        if (type instanceof OCAutoType) {
            return false;
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(declaration);
        OCType resolvedType = type.resolve(resolveContext);
        if (resolvedType instanceof OCCppReferenceType) {
            OCCppReferenceType referenceType = (OCCppReferenceType)resolvedType;
            if (referenceType.isRvalueRef()) {
                return false;
            }
            resolvedType = referenceType.getRefType();
        }
        if (resolvedType.isUnknown()) {
            return false;
        }
        if (OCReplaceTypeWithAutoIntentionAction.insideForeach(declaration) && OCReplaceTypeWithAutoIntentionAction.canUseAutoInForeach(declaration, resolvedType, resolveContext) || OCReplaceTypeWithAutoIntentionAction.canUseAuto(declaration, resolvedType, resolveContext)) {
            this.setText(OCBundle.message("intentions.replace.type.with.auto", new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean canUseAuto(@NotNull OCDeclaration declaration, @NotNull OCType commonType, @NotNull OCResolveContext resolveContext) {
        List<OCDeclarator> declarators = declaration.getDeclarators();
        for (OCDeclarator declarator : declarators) {
            OCType declaratorType = OCTypeUtils.getResolvedCppReferencedType(declarator.getType(), resolveContext);
            if (!commonType.equals(declaratorType, false, resolveContext)) {
                return false;
            }
            OCExpression initializer = declarator.getInitializer();
            if (initializer == null) {
                return false;
            }
            OCType initializerType = OCTypeUtils.getResolvedCppReferencedType(initializer.getResolvedType(), resolveContext);
            if (OCReplaceTypeWithAutoIntentionAction.areSameTypes(declaratorType, initializerType, resolveContext)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameTypes(@NotNull OCType declaratorType, @NotNull OCType initializerType, @NotNull OCResolveContext resolveContext) {
        if (declaratorType instanceof OCPointerType) {
            if (declaratorType.isCString() && initializerType.isCString()) {
                return true;
            }
            OCType refType = ((OCPointerType)declaratorType).getRefType();
            if (refType instanceof OCFunctionType && refType.equals(initializerType, false, resolveContext)) {
                return true;
            }
        }
        return declaratorType.equals(initializerType, false, resolveContext);
    }

    private static boolean insideForeach(@NotNull OCDeclaration declaration) {
        OCForeachStatement foreachStatement = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)declaration, OCForeachStatement.class);
        return foreachStatement != null && PsiTreeUtil.isAncestor((PsiElement)foreachStatement.getVariableDeclaration(), (PsiElement)declaration, (boolean)false);
    }

    private static boolean canUseAutoInForeach(@NotNull OCDeclaration declaration, @NotNull OCType declarationType, @NotNull OCResolveContext resolveContext) {
        OCForeachStatement foreachStatement = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)declaration, OCForeachStatement.class);
        if (foreachStatement == null) {
            return false;
        }
        OCExpression collectionExpression = foreachStatement.getCollectionExpression();
        if (collectionExpression == null) {
            return false;
        }
        OCType collectionType = collectionExpression.getResolvedType(resolveContext);
        OCType elementType = OCCodeInsightUtil.getCollectionElementType(collectionExpression, collectionType);
        if (elementType == null) {
            return false;
        }
        elementType = OCTypeUtils.getCppReferencedType(elementType);
        return OCReplaceTypeWithAutoIntentionAction.areSameTypes(declarationType, elementType, resolveContext);
    }

    private static void modifyTypeElement(@NotNull OCDeclaration declaration) {
        OCTypeElement typeElement = declaration.getTypeElement();
        assert (typeElement != null);
        OCResolveContext resolveContext = OCResolveContext.forPsi(declaration);
        OCType declarationType = OCTypeUtils.getCppReferencedType(declaration.getDeclarators().get(0).getType().resolve(resolveContext));
        boolean autoWasInsert = false;
        ASTNode node2 = typeElement.getNode();
        for (ASTNode childNode : node2.getChildren(null)) {
            IElementType elementType;
            if (OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode) || (elementType = childNode.getElementType()) == OCTokenTypes.CONST_KEYWORD && declarationType.isConst() || elementType == OCTokenTypes.VOLATILE_KEYWORD && declarationType.isVolatile()) continue;
            if (!autoWasInsert) {
                autoWasInsert = true;
                node2.addLeaf((IElementType)OCTokenTypes.AUTO_KEYWORD, (CharSequence)"auto", childNode);
            }
            node2.removeChild(childNode);
        }
        assert (autoWasInsert);
    }

    private static void modifyDeclarator(@NotNull OCDeclarator declarator) {
        ASTNode childNode;
        IElementType elementType;
        ASTNode[] children;
        ASTNode node2 = declarator.getNode();
        ASTNode[] aSTNodeArray = children = node2.getChildren(null);
        int n = aSTNodeArray.length;
        for (int j = 0; j < n && (elementType = (childNode = aSTNodeArray[j]).getElementType()) != OCTokenTypes.EQ; ++j) {
            if (elementType == OCTokenTypes.IDENTIFIER || elementType == OCTokenTypes.AND || OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode)) continue;
            node2.removeChild(childNode);
        }
    }

    private static void removeExtraWhitespaces(@NotNull ASTNode node2) {
        ASTNode child;
        IElementType elementType;
        ASTNode[] children;
        ASTNode[] aSTNodeArray = children = node2.getChildren(null);
        int n = aSTNodeArray.length;
        for (int j = 0; j < n && (elementType = (child = aSTNodeArray[j]).getElementType()) != OCTokenTypes.EQ; ++j) {
            if (OCTokenTypes.WHITESPACES.contains(elementType)) {
                PsiElement prevSibling = OCElementUtil.getPrevSiblingOrParentSibling(child.getPsi());
                if (prevSibling == null) continue;
                ASTNode prevSiblingNode = prevSibling.getNode();
                if (!(prevSiblingNode instanceof LeafElement)) {
                    prevSiblingNode = prevSiblingNode.getLastChildNode();
                }
                if (!OCTokenTypes.WHITESPACES.contains(prevSiblingNode.getElementType())) continue;
                node2.removeChild(child);
                continue;
            }
            if (child instanceof LeafElement) continue;
            OCReplaceTypeWithAutoIntentionAction.removeExtraWhitespaces(child);
        }
    }

    private static boolean shouldPreserveNode(@NotNull ASTNode node2) {
        if (node2.getPsi() instanceof OCAttributesList || node2.getPsi() instanceof OCMacroCall) {
            return true;
        }
        IElementType elementType = node2.getElementType();
        if (OCTokenTypes.WHITESPACES.contains(elementType)) {
            return true;
        }
        if (CommentUtilCore.isComment((ASTNode)node2)) {
            return true;
        }
        if (OCTokenTypes.TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        return OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(elementType);
    }

    private static boolean isAvailableForElement(@NotNull PsiElement element) {
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration == null) {
            return false;
        }
        for (OCDeclarator declarator : declaration.getDeclarators()) {
            OCExpression initializer = declarator.getInitializer();
            if (initializer == null || !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)element, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private static boolean canTransformCodeFragment(@NotNull PsiElement element) {
        ASTNode childNode;
        IElementType elementType;
        ASTNode[] children;
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return false;
        }
        ASTNode node2 = element.getNode();
        ASTNode[] aSTNodeArray = children = node2.getChildren(null);
        int n = aSTNodeArray.length;
        for (int j = 0; j < n && (elementType = (childNode = aSTNodeArray[j]).getElementType()) != OCTokenTypes.EQ; ++j) {
            PsiElement childElement;
            if (OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode) || OCReplaceTypeWithAutoIntentionAction.canTransformCodeFragment(childElement = childNode.getPsi())) continue;
            return false;
        }
        return true;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.replace.type.with.auto", new Object[0]);
    }
}

