/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionActionHandler;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateDefinitionsIntentionActionBase
implements IntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        assert (editor != null);
        OCFunctionSymbol function = OCGenerateDefinitionsIntentionActionBase.findSuitableFunction(editor, file2);
        if (function == null) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Boolean result2 = (Boolean)OCLongActionUtil.runReadActionInBackgroundAndWait(() -> OCGenerateDefinitionsIntentionActionBase.shouldGenerateDefinitionFor(function, project2), 1000L);
            return result2 != null ? result2 : true;
        }
        return OCGenerateDefinitionsIntentionActionBase.shouldGenerateDefinitionFor(function, project2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCFunctionSymbol symbol = OCGenerateDefinitionsIntentionActionBase.findSuitableFunction(editor, file2);
        if (symbol == null) {
            return;
        }
        new OCGenerateDefinitionActionHandler(project2, file2, symbol, OCCppDefinitionsUtil.InlinePolicy.get(this.isInline()), true).invoke();
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean isInline();

    @Nullable
    private static OCFunctionSymbol findSuitableFunction(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCFunctionDeclaration function = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, OCFunctionDeclaration.class);
        OCSymbolWithQualifiedName symbol = function != null ? (OCSymbolWithQualifiedName)function.getSymbol() : null;
        OCFunctionSymbol functionSymbol = (OCFunctionSymbol)ObjectUtils.tryCast((Object)symbol, OCFunctionSymbol.class);
        if (functionSymbol == null || functionSymbol.getParent() instanceof OCStructSymbol) {
            return null;
        }
        if (functionSymbol.getQualifier() != null) {
            return null;
        }
        return functionSymbol;
    }

    private static boolean shouldGenerateDefinitionFor(OCFunctionSymbol function, @NotNull Project project2) {
        return function != null && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(function, true, project2) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.POSSIBLE;
    }
}

