/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMethodInInterfaceIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCBundle.message("intentions.declare.method.in.interface", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    protected OCMethodSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)at, OCMethod.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
        return method != null ? (OCMethodSymbol)method.getSymbol() : null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        OCMethodSymbol method = this.locateCandidate(project2, editor, file2);
        return method != null && OCSearchScope.isInProjectSources(method, project2) && method.isDefinition() && method.getAssociatedSymbol(project2) == null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        OCDeclareActionContext context2 = super.evaluateActionContext(parent, element);
        context2.setTarget(OCDeclareActionContext.Target.INTERFACE);
        return context2;
    }
}

