/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public class OCUnusedTemplateParameterInspection
extends OCUnusedCppInspection {
    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this){

            @Override
            public void visitTypeParameterDeclaration(OCTypeParameterDeclaration declaration) {
                if (!OCUnusedTemplateParameterInspection.isTraitTemplateParameter((OCTemplateParameterList)declaration.getParent())) {
                    OCSymbol symbol = this.getSymbol(declaration);
                    this.checkSymbolUsed(declaration, symbol);
                }
            }
        };
    }

    public static boolean isTraitTemplateParameter(OCTemplateParameterList templateParameterList) {
        PsiElement parent = templateParameterList.getParent();
        OCSymbolWithQualifiedName parentSymbol = null;
        if (parent instanceof OCFunctionDeclaration) {
            parentSymbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)parent).getSymbol();
        } else if (parent instanceof OCDeclaration) {
            OCTypeElement typeElement = ((OCDeclaration)parent).getTypeElement();
            OCType type = typeElement != null ? typeElement.getType().resolve(templateParameterList) : null;
            parentSymbol = type instanceof OCStructType ? ((OCStructType)type).getSymbol() : null;
        }
        final OCSymbolWithQualifiedName finalParentSymbol = parentSymbol;
        return parentSymbol != null && !parentSymbol.processSameSymbols((Processor<OCSymbol>)new CommonProcessors.FindProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol != finalParentSymbol;
            }
        }, templateParameterList.getProject());
    }

    public boolean runForWholeFile() {
        return true;
    }
}

