/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import org.jetbrains.annotations.NotNull;

public class OCUnusedClassInspection
extends OCUnusedObjCInspection {
    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                OCSymbol symbol = this.getSymbol(dcl);
                if (!this.myOnTheFly && symbol != null && symbol.isPredeclaration()) {
                    return;
                }
                if (symbol instanceof OCProtocolSymbol) {
                    this.checkSymbolUsed(dcl, symbol);
                } else if (symbol instanceof OCClassSymbol) {
                    Project project2 = dcl.getProject();
                    OCInterfaceSymbol interfaceSymbol = ((OCClassSymbol)symbol).getMainInterface(project2);
                    if (interfaceSymbol == null) {
                        this.checkSymbolUsed(dcl, symbol);
                    } else if (this.myOnTheFly || interfaceSymbol == symbol) {
                        this.checkSymbolUsed(interfaceSymbol.locateDefinition(project2), dcl, interfaceSymbol);
                    }
                }
            }
        };
    }

    public boolean runForWholeFile() {
        return true;
    }
}

