/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ResourceUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInspectionUtil {
    private static final Logger LOG = Logger.getInstance(OCInspectionUtil.class);

    private OCInspectionUtil() {
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends OCInspection> inspectionClass, @Nullable PsiElement element, @NotNull HighlightSeverity defaultHighlightSeverity) {
        if (inspectionClass == OCInspections.OtherObjC.class || inspectionClass == OCInspections.OtherCpp.class || element == null) {
            return defaultHighlightSeverity;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        String inspectionShortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionShortName == null) {
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)inspectionShortName);
        if (!inspectionProfile.isToolEnabled(highlightDisplayKey, element) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (highlightDisplayKey == null) {
            return defaultHighlightSeverity;
        }
        HighlightDisplayLevel highlightDisplayLevel = inspectionProfile.getErrorLevel(highlightDisplayKey, element);
        return highlightDisplayLevel.getSeverity();
    }

    @Nullable
    public static String getInspectionShortName(@NotNull Class<? extends OCInspection> inspectionClass) {
        try {
            return inspectionClass.newInstance().getShortName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Cannot get inspection short name: " + e);
            return null;
        }
    }

    @Nullable
    public static String getStaticDescription(@NotNull OCInspection inspection) {
        String shortName = OCInspectionUtil.getInspectionShortName(inspection.getInspectionClass());
        if (shortName != null) {
            try {
                InputStream descriptionStream = ResourceUtil.getResourceAsStream((ClassLoader)((Object)((Object)inspection)).getClass().getClassLoader(), (String)"inspectionDescriptions", (String)(shortName + ".html"));
                return descriptionStream != null ? ResourceUtil.loadText((InputStream)descriptionStream) : null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    public static void restartCodeAnalyzer() {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).restart();
        }
    }

    @NotNull
    public static HyperlinkLabel createLinkToConfigurable(@NotNull String hyperlinkText, final @NotNull Class<? extends Configurable> targetConfigurable, final @Nullable Predicate<? super Configurable> predicate, final @Nullable Consumer<? super Configurable> additionalConsumer) {
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(hyperlinkText);
        hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlinkLabel);
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, c -> ConfigurableWrapper.cast((Class)targetConfigurable, (UnnamedConfigurable)c) != null && (predicate == null || predicate.test(c)), additionalConsumer);
                }
            }
        });
        return hyperlinkLabel;
    }

    public static boolean isInspectionEnabled(@NotNull PsiFile file2, @NotNull Class<? extends OCInspection> inspectionClass) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        HighlightDisplayKey key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)file2.getProject()).getCurrentProfile();
        return inspectionProfile.isToolEnabled(key, (PsiElement)file2);
    }

    public static boolean isClangdDFAEnabled(@NotNull PsiElement element) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        return Arrays.stream(OCInspectionToolProvider.getInstance().getInspectionClasses()).filter(c -> OCInspections.DataFlowAnalysis.class.isAssignableFrom((Class<?>)c) && c != OCDFAInspection.class && OCInspectionUtil.isClangdInspection(c)).anyMatch(arg_0 -> OCInspectionUtil.lambda$isClangdDFAEnabled$1((InspectionProfile)inspectionProfile, element, arg_0));
    }

    private static boolean isClangdInspection(Class klass) {
        try {
            return ((OCInspection)((Object)klass.newInstance())).worksWithClangd();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return false;
        }
    }

    @NotNull
    public static Class<? extends OCInspection> getUnusedInspectionClass(@NotNull OCPsiFile file2) {
        OCLanguageKind kind = FileSymbolTablesCache.areSymbolsLoaded(file2.getProject()) ? file2.getKind() : OCLanguageKindCalculator.calculateLanguageKindFast(file2);
        return kind.isObjC() ? OCInspections.UnusedImportStatement.class : OCUnusedIncludeDirectiveInspection.class;
    }

    private static /* synthetic */ boolean lambda$isClangdDFAEnabled$1(InspectionProfile inspectionProfile, PsiElement element, Class c) {
        String shortName = OCInspectionUtil.getInspectionShortName(c);
        HighlightDisplayKey highlightDisplayKey = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        return highlightDisplayKey != null && inspectionProfile.isToolEnabled(highlightDisplayKey, element);
    }
}

