/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionToolWrapperWithHint;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdConfigurable;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCInspection
extends LocalInspectionTool
implements InspectionToolWrapperWithHint {
    public static final Key<ProblemDescriptionsProcessor> TEST_PROBLEMS_PROCESSOR_KEY = Key.create((String)"TEST_PROBLEMS_PROCESSOR_KEY");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return OCCodeInsightUtil.getPrettyNameFromClassName(((Object)((Object)this)).getClass().getSuperclass());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return OCCodeInsightUtil.getPrettyNameFromClassName(((Object)((Object)this)).getClass());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return this instanceof OCInspections.Hidden ? HighlightDisplayLevel.NON_SWITCHABLE_WARNING : super.getDefaultLevel();
    }

    protected Class<? extends OCInspection> getInspectionClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected void registerProblems(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, List<? extends PsiElement> elements, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes2) {
        for (PsiElement psiElement : elements) {
            if (psiElement.getTextLength() <= 0) continue;
            this.registerProblem(holder, processor2, globalContext, isOnTheFly, psiElement, message, clangID, highlightType, quickFixes2);
        }
    }

    protected void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable PsiElement element, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes2) {
        OCInspection.registerProblem(holder, processor2, globalContext, isOnTheFly, element, message, clangID, highlightType, this.getInspectionClass(), quickFixes2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable PsiElement element, String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes2) {
        OCMacroRange range;
        if (element == null) {
            return;
        }
        if (element.getTextLength() == 0) {
            range = OCElementUtil.getRangeInMacroCall(element);
            if (range == null) return;
            OCMacroCall macroCall = range.getMacroCall();
            if (macroCall != element.getPrevSibling()) return;
            element = macroCall;
        }
        range = OCElementUtil.getRangeWithMacros(element);
        OCInspection.registerProblem(holder, processor2, globalContext, isOnTheFly, element, null, message, clangID, highlightType, (TextRange)range, inspection, quickFixes2);
    }

    public static void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable OCElementsRange elementsRange, String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes2) {
        if (elementsRange == null) {
            return;
        }
        TextRange textRange = elementsRange.getTextRange();
        if (textRange.isEmpty()) {
            return;
        }
        OCInspection.registerProblem(holder, processor2, globalContext, isOnTheFly, elementsRange.getFirstElement(), elementsRange.getLastElement(), message, clangID, highlightType, textRange, inspection, quickFixes2);
    }

    public static void registerProblem(ProblemsHolder holder, ProblemDescriptionsProcessor processor2, GlobalInspectionContext globalContext, boolean isOnTheFly, PsiElement startElement, @Nullable PsiElement endElement, String message, String clangID, ProblemHighlightType highlightType, TextRange range, Class<? extends OCInspection> inspection, IntentionAction[] quickFixes2) {
        while (startElement instanceof OCMacroForeignLeafElement) {
            startElement = startElement.getParent();
        }
        while (endElement instanceof OCMacroForeignLeafElement) {
            endElement = endElement.getParent();
        }
        if (endElement != null && startElement.getTextOffset() >= endElement.getTextRange().getEndOffset()) {
            return;
        }
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(inspection, startElement, HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file2 = (OCFile)startElement.getContainingFile();
        List wrappers = ContainerUtil.mapNotNull((Object[])quickFixes2, action -> action instanceof SuppressIntentionAction ? null : new IntentionWrapper(action, (PsiFile)file2));
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file2, range, clangID, inspection);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file2, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        InspectionManager manager2 = InspectionManager.getInstance((Project)startElement.getProject());
        ProblemDescriptor problem = endElement == null ? manager2.createProblemDescriptor(startElement, message, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]), highlightType, isOnTheFly, false) : manager2.createProblemDescriptor(startElement, endElement, message, highlightType, isOnTheFly, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]));
        if (problemGroup != null) {
            problem.setProblemGroup((ProblemGroup)problemGroup);
            for (IntentionAction fix : quickFixes2) {
                if (!(fix instanceof SuppressIntentionAction)) continue;
                problemGroup.addSuppressAction((SuppressIntentionAction)fix);
            }
        }
        if (processor2 == null) {
            ProblemDescriptionsProcessor problemDescriptionsProcessor = processor2 = file2 != null ? (ProblemDescriptionsProcessor)file2.getProject().getUserData(TEST_PROBLEMS_PROCESSOR_KEY) : null;
        }
        if (processor2 != null) {
            processor2.addProblemElement((RefEntity)(globalContext != null ? GlobalInspectionContextUtil.retrieveRefElement((PsiElement)startElement, (GlobalInspectionContext)globalContext) : null), new CommonProblemDescriptor[]{problem});
        }
        if (holder != null) {
            holder.registerProblem(problem);
        }
    }

    public String getMainToolId() {
        if (OCInspections.class.equals(((Object)((Object)this)).getClass().getDeclaringClass())) {
            return new DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection().getShortName();
        }
        return null;
    }

    public boolean worksWithClangd() {
        return false;
    }

    private boolean showAdjustableHint() {
        return !this.worksWithClangd() && PlatformUtils.isCLion() && !ObjC.class.isAssignableFrom(((Object)((Object)this)).getClass());
    }

    public String getHint() {
        return this.showAdjustableHint() ? "(Adjustable only when clangd is off)" : null;
    }

    public JComponent createOptionsPanel() {
        if (!this.showAdjustableHint()) {
            return super.createOptionsPanel();
        }
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)new JBLabel(OCInspectionsBundle.message("inspection.works.only.when.clangd.disabled.hint", new Object[0])), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0)));
        panel2.add((Component)new JBLabel("or in Objective C code"), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        panel2.add((Component)OCInspection.createOpenClangdSettingsHyperlink(), bag.nextLine().weighty(1.0).insets((Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0)));
        return panel2;
    }

    @NotNull
    public static HyperlinkLabel createOpenClangdSettingsHyperlink() {
        final HyperlinkLabel hyperlink = new HyperlinkLabel(OCInspectionsBundle.message("open.clangd.settings.link", new Object[0]));
        hyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlink);
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, ClangdConfigurable.class);
                }
            }
        });
        return hyperlink;
    }

    public static abstract class Cpp
    extends OCInspection {
        public String @NotNull [] getGroupPath() {
            return new String[]{"C/C++", this.getGroupDisplayName()};
        }
    }

    public static abstract class ObjC
    extends OCInspection {
        public String @NotNull [] getGroupPath() {
            return new String[]{"Objective-C", this.getGroupDisplayName()};
        }
    }
}

