/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.RMLLogPanel;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.dfa.OCDFAInspectionRunner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.ui.console.RelationsConsole;
import com.jetbrains.sourceglider.ui.console.StringConsole;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCDFAInspection
extends OCInspections.DataFlowAnalysis {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message("inspection.context.sensitive.analysis", new Object[0]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.NON_SWITCHABLE_WARNING;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return OCDFAInspection.getRunner(holder.getFile()).buildVisitor(holder);
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        PsiFile file2 = session.getFile();
        if (file2 instanceof OCFile && OCInspectionUtil.isClangdDFAEnabled((PsiElement)file2)) {
            Runner runner = OCDFAInspection.getRunner(file2);
            runner.run((OCFile)file2, problemsHolder, this);
        }
    }

    @NotNull
    private static Runner getRunner(@NotNull PsiFile file2) {
        boolean legacy = !ClangUtils.isClangdOn(file2.getProject()) || !ClangUtils.isClangdShowErrors(file2.getProject()) || file2 instanceof OCFile && ((OCFile)file2).getKind().isObjC() && !ApplicationManager.getApplication().isUnitTestMode();
        return legacy ? new OCDFAInspectionRunner() : new com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAInspectionRunner();
    }

    public static void printRelationsToLog(ManagerInstancesProvider provider2) {
        OCDFAInspection.printRelations(provider2, (s1, s2) -> RMLLogPanel.Companion.log((String)s1, (String)s2), true);
    }

    public static void printRelations(ManagerInstancesProvider provider2, BiConsumer<String, String> log, boolean printBddNodes) {
        RelationsRepository repository = provider2.getRelationsRepository();
        for (String relationName : ContainerUtil.sorted(Arrays.asList(repository.getAvailableRelations()))) {
            StringConsole stringConsole = new StringConsole();
            RelationsConsole console = new RelationsConsole(stringConsole);
            IRelation relation = repository.getRelation(relationName);
            int domainsCnt = relation.getDomainTypes().length;
            int[] permutation = new int[domainsCnt];
            for (int i2 = 0; i2 < domainsCnt; ++i2) {
                permutation[i2] = i2;
            }
            console.print(relation, relationName, -1, permutation, provider2.getSymbolTable(), printBddNodes);
            log.accept(relationName, stringConsole.getContent());
            log.accept(" (" + relation.getNumOfTuples() + " " + StringUtil.pluralize((String)"tuple") + ")\n", null);
        }
    }

    public static interface Runner {
        @NotNull
        public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder var1);

        public void run(@NotNull OCFile var1, @NotNull ProblemsHolder var2, @NotNull OCDFAInspection var3);
    }
}

