/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCInheritorsAndCategoriesNodeProvider
implements FileStructureNodeProvider<OCStructureViewElement> {
    @NonNls
    private static final String ID = "INHERITORS_AND_CATEGORIES";

    @NotNull
    public String getCheckBoxText() {
        return "Other Categories and Inherited Members";
    }

    public Shortcut @NotNull [] getShortcut() {
        return KeymapUtil.getActiveKeymapShortcuts((String)"FileStructurePopup").getShortcuts();
    }

    @NotNull
    public Collection<OCStructureViewElement> provideNodes(@NotNull TreeElement node2) {
        OCClassSymbol ownSymbol;
        PsiElement context2;
        if (node2 instanceof OCStructureViewElement && ((OCStructureViewElement)node2).isAllowInheritorsAndCategories() && (context2 = ((OCStructureViewElement)node2).getValue()) instanceof OCClassDeclaration && (ownSymbol = ((OCClassDeclaration)context2).getSymbol()) != null) {
            HashSet processed = new HashSet();
            OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
            ownSymbol.processMembers(OCMemberSymbol.class, symbol -> {
                processed.add(symbol.getNameWithParent(resolveContext));
                return true;
            });
            OCObjectType type = ((OCClassDeclaration)context2).getType(true);
            if (type != null) {
                ArrayList<OCStructureViewElement> answer = new ArrayList<OCStructureViewElement>();
                HashSet parents = new HashSet();
                type.processMembers(OCMemberSymbol.class, symbol -> {
                    if (symbol instanceof OCInstanceVariableSymbol) {
                        return true;
                    }
                    OCClassSymbol parent = symbol.getParent();
                    if (parent == null || parents.contains(parent)) {
                        return true;
                    }
                    if (!processed.add(symbol.getNameWithParent(resolveContext))) {
                        return true;
                    }
                    if (parents.add(parent)) {
                        String categoryName;
                        if ("NSObject".equals(parent.getName()) && !StringUtil.isEmpty((String)(categoryName = parent.getCategoryName())) && !categoryName.startsWith("NSKeyValue")) {
                            return true;
                        }
                        PsiElement declaration = parent.locateDefinition(context2.getProject());
                        if (declaration != null) {
                            answer.add(new OCStructureViewElement(declaration, context2));
                        }
                    }
                    return true;
                });
                return answer;
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData("Show Inherited", "Show inherited members and members in other categories", AllIcons.Hierarchy.Supertypes);
    }

    @NotNull
    public String getName() {
        return ID;
    }
}

