/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.ChangeHierarchyViewActionBase;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.include.OCImportSubHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.include.OCImportSuperHierarchyTreeStructure;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeHierarchyBrowser
extends HierarchyBrowserBaseEx {
    private static final Logger LOG = Logger.getInstance(OCIncludeHierarchyBrowser.class);
    public static final String INCLUDING_HIERARCHY_TYPE = OCBundle.message("navigation.import.hierarchy.including.title", new Object[0]);
    public static final String INCLUDED_BY_HIERARCHY_TYPE = OCBundle.message("navigation.import.hierarchy.included.title", new Object[0]);
    public static final DataKey<OCIncludeHierarchyBrowser> DATA_KEY = DataKey.create((String)"com.jetbrains.cidr.lang.hierarchy.include.OCIncludeHierarchyBrowser");
    private boolean myIsImplementation;

    public OCIncludeHierarchyBrowser(@NotNull Project project2, @NotNull OCFile file2) {
        super(project2, (PsiElement)file2);
    }

    public boolean isImplementation() {
        return this.myIsImplementation;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        super.setHierarchyBase(element);
        this.myIsImplementation = element instanceof OCFile && !OCInclusionContextUtil.isNeedToFindRoot((OCFile)element);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (!(descriptor instanceof OCClassHierarchyNodeDescriptor)) {
            return null;
        }
        return ((OCClassHierarchyNodeDescriptor)descriptor).getType();
    }

    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        return OCBundle.message("navigation.import.hierarchy.previous.occurence", new Object[0]);
    }

    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        return OCBundle.message("navigation.import.hierarchy.next.occurence", new Object[0]);
    }

    @NotNull
    protected String getBrowserDataKey() {
        return DATA_KEY.getName();
    }

    @NotNull
    protected String getActionPlace() {
        return "TypeHierarchyViewToolbar";
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        return element instanceof OCFile;
    }

    @Nullable
    protected Comparator<NodeDescriptor<?>> getComparator() {
        return AlphaComparator.INSTANCE;
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement element) {
        if (element instanceof OCFile) {
            if (OCIncludeHierarchyBrowser.getIncludedByHierarchyType().equals(typeName)) {
                return new OCImportSubHierarchyTreeStructure(this.myProject, (OCFile)element);
            }
            return new OCImportSuperHierarchyTreeStructure(this.myProject, (OCFile)element);
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)actionManager);
        trees.put(OCIncludeHierarchyBrowser.getIncludingHierarchyType(), tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)actionManager);
        trees.put(OCIncludeHierarchyBrowser.getIncludedByHierarchyType(), tree2);
    }

    protected Map<String, Supplier<String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(INCLUDING_HIERARCHY_TYPE, OCIncludeHierarchyBrowser::getIncludingHierarchyType);
        map2.put(INCLUDED_BY_HIERARCHY_TYPE, OCIncludeHierarchyBrowser::getIncludedByHierarchyType);
        return map2;
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        actionGroup.add((AnAction)new ViewIncludedHierarchyAction());
        actionGroup.add((AnAction)new ViewIncludingHierarchyAction());
        super.prependActions(actionGroup);
    }

    public static String getIncludingHierarchyType() {
        return OCBundle.message("navigation.import.hierarchy.including.title", new Object[0]);
    }

    public static String getIncludedByHierarchyType() {
        return OCBundle.message("navigation.import.hierarchy.included.title", new Object[0]);
    }

    private static abstract class ChangeViewAction
    extends ChangeHierarchyViewActionBase {
        ChangeViewAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon) {
            super(dynamicText, dynamicDescription, icon);
        }

        protected OCIncludeHierarchyBrowser getHierarchyBrowser(DataContext context2) {
            return (OCIncludeHierarchyBrowser)((Object)DATA_KEY.getData(context2));
        }
    }

    static class ViewIncludingHierarchyAction
    extends ChangeViewAction {
        ViewIncludingHierarchyAction() {
            super(OCBundle.messagePointer("navigation.import.hierarchy.including.action", new Object[0]), OCBundle.messagePointer("navigation.import.hierarchy.including.action.description", new Object[0]), AllIcons.Hierarchy.Supertypes);
        }

        protected String getTypeName() {
            return OCIncludeHierarchyBrowser.getIncludingHierarchyType();
        }
    }

    static class ViewIncludedHierarchyAction
    extends ChangeViewAction {
        ViewIncludedHierarchyAction() {
            super(OCBundle.messagePointer("navigation.import.hierarchy.included.action", new Object[0]), OCBundle.messagePointer("navigation.import.hierarchy.included.action.description", new Object[0]), AllIcons.Hierarchy.Subtypes);
        }

        protected String getTypeName() {
            return OCIncludeHierarchyBrowser.getIncludedByHierarchyType();
        }
    }
}

