/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OCCallHierarchyNodeAggregator {
    private final Map<String, OCCallHierarchyNodeDescriptor> myMap;
    private final HierarchyNodeDescriptor myParentDescriptor;

    public OCCallHierarchyNodeAggregator(OCCallHierarchyNodeDescriptor parentDescriptor) {
        this.myParentDescriptor = parentDescriptor;
        this.myMap = new HashMap<String, OCCallHierarchyNodeDescriptor>();
    }

    @Nullable
    public OCCallHierarchyNodeDescriptor addNodeDescriptor(OCSymbol known, @Nullable String selectorName, OCElement context2) {
        OCCallHierarchyNodeDescriptor desc;
        String name;
        Project project2 = this.myParentDescriptor.getProject();
        if (project2 == null) {
            return null;
        }
        if (known instanceof OCFunctionSymbol) {
            OCQualifiedName qualifiedName = ((OCFunctionSymbol)known).getResolvedQualifiedName(OCResolveContext.forPsi(context2));
            name = qualifiedName != null ? qualifiedName.toString() + ((OCFunctionSymbol)known).getParametersSignature(project2) : known.getSignature(project2);
        } else if (known instanceof OCMethodSymbol) {
            OCMethodSymbol methodSymbol = (OCMethodSymbol)known;
            if (methodSymbol.getDefinitionSymbol(project2) == null && methodSymbol.getGeneratedFromProperty() != null) {
                return null;
            }
            name = methodSymbol.getParent().getName() + "." + known.getSignature(project2);
        } else {
            name = selectorName;
        }
        if (this.myMap.containsKey(name)) {
            desc = this.myMap.get(name);
            desc.incrementUsageCount();
        } else {
            PsiElement element;
            desc = known != null ? new OCCallHierarchyNodeDescriptor(project2, this.myParentDescriptor, (PsiElement)((element = known.locateDefinition(project2)) != null ? element : context2), false, true) : new OCCallHierarchyNodeDescriptor(project2, this.myParentDescriptor, context2, false, true);
            desc.addReference(context2.getReference());
            this.myMap.put(name, desc);
        }
        return desc;
    }

    public Object[] getChildren() {
        return this.myMap.values().toArray();
    }
}

