/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCOverrideImplementMethodsHandlerBase
extends OCObjCClassTextActionHandlerBase<OCMethodSymbol, OCOverrideImplementActionContext> {
    @Override
    @NotNull
    protected String getActionTitle() {
        return "Override/Implement Methods";
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCMethodSymbol> methods, @NotNull OCOverrideImplementActionContext context2) {
        assert (element instanceof OCImplementation);
        StringBuilder result2 = new StringBuilder();
        for (OCMethodSymbol baseMethod : methods) {
            result2.append(this.generateMethodText(baseMethod, element.getLastChild(), context2));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        return result2.toString();
    }

    @Override
    @NotNull
    protected Condition<OCMethodSymbol> getCandidatesFilter(@NotNull OCOverrideImplementActionContext context2) {
        HashSet ownMethods = new HashSet();
        context2.getImplementationSymbol().processMembers(OCMethodSymbol.class, symbol -> {
            ownMethods.add(symbol.getSignature(context2.getProject()));
            return true;
        });
        return method -> !ownMethods.contains(method.getSignature(context2.getProject()));
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCMethodSymbol> methods, OCOverrideImplementActionContext actionContext) {
        OCMethodSymbol firstMethod = methods.get(0);
        OCClassDeclaration declaration = (OCClassDeclaration)element;
        if ((at == null || caretOffset < declaration.getMethodsStartOffset(true)) && (at = declaration.getBestMemberPlace(firstMethod)) != null) {
            caretOffset = at.getTextRange().getStartOffset();
        }
        return declaration.getMethodsInsertPosition(methods.size() == 1 && firstMethod.getName().startsWith("init"), at, caretOffset);
    }

    protected abstract String generateMethodText(OCMethodSymbol var1, PsiElement var2, OCOverrideImplementActionContext var3);

    @Override
    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        return true;
    }
}

