/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCOverrideImplementCppFunctionsHandlerBase
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCFunctionSymbol, OCOverrideImplementCppActionContext> {
    private static final OCBooleanOption INSERT_OVERRIDE = new OCBooleanOption(OCBundle.message("override.implement.cpp.action.insertOverride", new Object[0]));

    @Override
    @NotNull
    protected String getActionTitle() {
        return OCBundle.message("override.implement.cpp.action.title", new Object[0]);
    }

    @Override
    protected void loadOptions(PsiFile file2, Editor editor, @NotNull OCOverrideImplementCppActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options2) {
        if (OCCompilerFeaturesHelper.supportsOverrideControl(file2)) {
            options2.add((Pair<OCOption, Object>)new Pair((Object)INSERT_OVERRIDE, (Object)(settings == null || settings.INSERT_OVERRIDE ? 1 : 0)));
        }
        super.loadOptions(file2, editor, actionContext, settings, options2);
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (optionValues.containsKey(INSERT_OVERRIDE)) {
            settings.INSERT_OVERRIDE = OCOverrideImplementCppFunctionsHandlerBase.getOption(optionValues, INSERT_OVERRIDE);
        }
        super.saveOptions(file2, settings, optionValues);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, m -> {
            boolean isIncomplete = m.isPureVirtual() || Comparing.equal(actionContext.getParent(), (Object)m.getParent());
            return new OCMemberChooserObject((OCSymbol)m, OCIcons.getFunctionIcon(m.isFriendOrStatic(), isIncomplete, !m.isVirtual(), m.getVisibility()), parentsMap, actionContext.getProject());
        });
    }

    @Override
    @NotNull
    protected String getFeatureId() {
        return "codeassists.overrideimplement";
    }

    @Override
    protected void doPerformAction(@NotNull Project project2, @NotNull OCCaretLocation location, @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        chosenCandidates.sort((fun1, fun2) -> {
            OCVisibility visibility2;
            OCResolveContext context2 = location.createContext();
            OCVisibility visibility1 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun1, (OCStructSymbol)actionContext.getParent(), context2);
            if (visibility1 == (visibility2 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun2, (OCStructSymbol)actionContext.getParent(), context2))) {
                int filesCmp = FileUtil.comparePaths((String)fun1.getContainingFile().getPath(), (String)fun2.getContainingFile().getPath());
                return filesCmp != 0 ? filesCmp : fun1.getOffset() - fun2.getOffset();
            }
            return visibility1.compareTo(visibility2);
        });
        super.doPerformAction(project2, location, actionContext, chosenCandidates);
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> functions) {
        PsiElement element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject());
        if (!(element instanceof OCStruct)) {
            return Collections.emptyList();
        }
        OCStruct structDefinition = (OCStruct)element;
        ArrayList<OCFunctionSymbol> overriding = new ArrayList<OCFunctionSymbol>(functions.size());
        ArrayList<String> bodies = new ArrayList<String>(functions.size());
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)location.getFile(), OCCodeStyleSettings.class);
        boolean insertOverride = this.getOption(actionContext, INSERT_OVERRIDE) == Boolean.TRUE;
        boolean insertVirtual = !insertOverride || settings.INSERT_VIRTUAL_WITH_OVERRIDE;
        for (OCFunctionSymbol function : functions) {
            OCFunctionSymbol newFunc = OCCallableUtil.createOverridingFunction(function, (OCNamespaceSymbol)actionContext.getParent(), structDefinition, OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(function, (OCStructSymbol)actionContext.getParent(), location.createContext()), insertOverride, insertVirtual);
            overriding.add(newFunc);
            bodies.add(OCCallableUtil.defaultFunctionBody(newFunc, !function.isPureVirtual() ? function : null, structDefinition));
        }
        return OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structDefinition, actionContext.getParent(), overriding, bodies, this.getInlinePolicy(actionContext));
    }

    private static OCVisibility getInheritorVisibility(OCFunctionSymbol symbol, OCStructSymbol inheritorClassSymbol, @NotNull OCResolveContext context2) {
        OCVisibility declaredVisibility = symbol.getVisibility();
        declaredVisibility = declaredVisibility != null ? declaredVisibility : OCVisibility.PRIVATE;
        return OCVisibility.leastVisible(declaredVisibility, OCVisibility.getMaxInheritanceVisibility((OCStructSymbol)symbol.getParent(), inheritorClassSymbol, context2));
    }
}

