/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIsEqualAndHashHandler
extends OCGenerateMethodHandler {
    @Override
    @NotNull
    protected String getActionTitle() {
        return "Generate -isEqual: and -hash";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"isEqual:", "hash"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context2) {
        return true;
    }

    @Override
    protected boolean isExistingMethod(String selector) {
        return super.isExistingMethod(selector) || selector.startsWith("isEqualTo");
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext context2) {
        StringBuilder builder2 = new StringBuilder();
        OCMethodSymbol isEqualMethod = context2.getBaseMethods().get(0);
        OCMethodSymbol hashMethod = context2.getBaseMethods().get(1);
        OCObjectType superType = context2.getType().getSuperType();
        HashSet<String> superMethodNames = new HashSet<String>();
        if (superType != null) {
            superType.processMembers(OCMethodSymbol.class, symbol -> {
                String name = symbol.getName();
                if (name.endsWith(":")) {
                    superMethodNames.add(name.substring(0, name.length() - 1));
                }
                return true;
            });
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(element);
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)context2.getType(), null, "", resolveContext);
        String customMethodName = "isEqualTo" + StringUtil.capitalize((String)(suggestions.isEmpty() ? "other" : suggestions.iterator().next()));
        customMethodName = OCNameSuggester.suggestUniqueName(null, customMethodName, null, superMethodNames, context2.getProject());
        suggestions = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, context2.getType(), element.getLastChild(), "", Collections.emptyList(), resolveContext);
        String paramName = suggestions.isEmpty() ? "other" : suggestions.iterator().next();
        String customSignature = "-(BOOL)" + customMethodName + ":(" + context2.getInterfaceSymbol().getName() + "*)" + paramName;
        if (element instanceof OCInterface) {
            builder2.append(OCCallableUtil.methodSignature(isEqualMethod, element, resolveContext)).append(";");
            builder2.append(customSignature).append(";");
            builder2.append(OCCallableUtil.methodSignature(hashMethod, element, resolveContext)).append(";");
        } else {
            String isEqualBody = OCGenerateIsEqualAndHashHandler.getIsEqualBody(ivars, paramName, context2, resolveContext);
            builder2.append(OCCallableUtil.methodText(isEqualMethod, customMethodName, element));
            builder2.append(OCCallableUtil.methodText(customSignature, isEqualBody, element));
            builder2.append(OCGenerateIsEqualAndHashHandler.getHashMethod(ivars, element, context2, resolveContext));
        }
        return builder2.toString();
    }

    private static String getIsEqualBody(List<OCInstanceVariableSymbol> ivars, String paramName, OCGenerateMethodActionContext actionContext, @NotNull OCResolveContext context2) {
        OCImplementationSymbol classSymbol;
        StringBuilder body = new StringBuilder();
        body.append("if (self == ").append(paramName).append(")\nreturn YES;\n");
        body.append("if (").append(paramName).append(" == nil)\nreturn NO;\n");
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("isEqual:", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true, actionContext.getProject())) {
            body.append("if (![super isEqual: ").append(paramName).append("])\nreturn NO;\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty(context2.getProject());
            OCType type = ivar.getType().resolve(context2, true);
            if (property != null) {
                OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body, "self." + property.getName(), paramName + "." + property.getName(), type, context2);
                continue;
            }
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body, ivar.getName(), paramName + "->" + ivar.getName(), type, context2);
        }
        body.append("return YES;");
        return body.toString();
    }

    private static void appendIsEqualMember(StringBuilder builder2, String selfName, String otherName, final OCType type, final @NotNull OCResolveContext context2) {
        if (OCGenerateIsEqualAndHashHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(builder2, selfName + "." + field.getName(), otherName + "." + field.getName(), field.getResolvedType(context2), context2);
            return true;
        }), context2)) {
            return;
        }
        builder2.append("if (").append(selfName).append("!=").append(otherName);
        if (type.isPointerToObject()) {
            OCObjectType objType = (OCObjectType)type.getTerminalType();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol symbol) {
                    String prefix = "isEqualTo";
                    if (symbol.getName().startsWith(prefix) && symbol.getName().length() > prefix.length() + 2 && symbol.getSelectors().size() == 1) {
                        OCDeclaratorSymbol param = symbol.getSelectors().get(0).getParameter();
                        return param != null && param.getType().resolve(context2).isCompatible(type, context2);
                    }
                    return false;
                }
            };
            objType.processMembers((String)null, OCMethodSymbol.class, finder);
            OCMethodSymbol customMethod = (OCMethodSymbol)finder.getFoundValue();
            OCDeclaratorSymbol parameter = customMethod != null ? customMethod.getSelectors().get(0).getParameter() : null;
            String methodName = parameter != null && parameter.getResolvedType(context2).isCompatible(type, context2) ? customMethod.getName() : "isEqual:";
            builder2.append("&&![").append(selfName).append(" ").append(methodName).append(otherName).append("]");
        }
        builder2.append(")\nreturn NO;\n");
    }

    @NotNull
    private static String getHashMethod(@NotNull List<OCInstanceVariableSymbol> ivars, @NotNull PsiElement context2, @NotNull OCGenerateMethodActionContext actionContext, @NotNull OCResolveContext resolveContext) {
        OCImplementationSymbol classSymbol;
        ArrayList<String> strings = new ArrayList<String>();
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("hash", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true, actionContext.getProject())) {
            strings.add("[super hash];\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty(actionContext.getProject());
            OCType type = ivar.getType().resolve(context2, true);
            OCGenerateIsEqualAndHashHandler.appendHashMember(strings, property != null ? "self." + property.getName() : ivar.getName(), type, context2, resolveContext);
        }
        StringBuilder function = new StringBuilder();
        function.append(OCCallableUtil.methodSignature(actionContext.getBaseMethods().get(1), context2, resolveContext)).append("{\n");
        if (strings.size() > 1) {
            boolean isFirst = true;
            for (String string : strings) {
                if (isFirst) {
                    function.append("NSUInteger hash = ");
                } else {
                    function.append("hash = hash * 31u + ");
                }
                function.append(string);
                isFirst = false;
            }
            function.append("return hash;\n}\n");
        } else if (strings.size() == 1) {
            function.append("return ").append((String)strings.get(0)).append("}\n");
        } else {
            function.append("return [super hash];}\n");
        }
        return function.toString();
    }

    private static void appendHashMember(List<String> strings, String memberName, OCType type, PsiElement context2, OCResolveContext resolveContext) {
        if (type.isPointerToObject()) {
            strings.add("[" + memberName + " hash];\n");
        } else if (type == OCRealType.FLOAT) {
            strings.add("[[NSNumber numberWithFloat:" + memberName + "] hash];\n");
        } else if (type instanceof OCRealType) {
            strings.add("[[NSNumber numberWithDouble:" + memberName + "] hash];\n");
        } else if (type instanceof OCIntType) {
            boolean convertToNSUInteger = strings.isEmpty() && (((OCIntType)type).isSigned() || ((OCIntType)type).getRank(resolveContext) > OCIntType.UINT.getRank(resolveContext));
            strings.add((convertToNSUInteger ? "(NSUInteger)" : "") + memberName + ";\n");
        } else if (type instanceof OCStructType && !type.isScalar()) {
            if (!OCGenerateIsEqualAndHashHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
                OCGenerateIsEqualAndHashHandler.appendHashMember(strings, memberName + "." + field.getName(), field.getResolvedType(resolveContext), context2, resolveContext);
                return true;
            }), resolveContext)) {
                strings.add("(NSUInteger)" + memberName + ";\n");
            }
        } else {
            strings.add("(NSUInteger)" + memberName + ";\n");
        }
    }
}

