/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionActionHandler;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionActionHandler$WhenMappings;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002!\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u000bH\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionActionHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "symbol", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "policy", "Lcom/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy;", "allowPossible", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;Lcom/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy;Z)V", "getAllowPossible", "()Z", "getFile", "()Lcom/intellij/psi/PsiFile;", "getPolicy", "()Lcom/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSymbol", "()Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "calculateReplacementsUnderProgress", "", "Lcom/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement;", "getReplacements", "getReplacementsWithMarkers", "Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionActionHandler$ReplAndMarkers;", "replacements", "invoke", "", "shouldGenerate", "ReplAndMarker", "ReplAndMarkers", "intellij.c"})
public final class OCGenerateDefinitionActionHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OCFunctionSymbol symbol;
    @NotNull
    private final OCCppDefinitionsUtil.InlinePolicy policy;
    private final boolean allowPossible;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<OCGenerateUtil.Replacement> replacements = this.calculateReplacementsUnderProgress();
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)OCGenerateUtil.getAffectedFiles(replacements))) {
            return;
        }
        Closeable closeable = this.getReplacementsWithMarkers(replacements, this.project);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ReplAndMarkers it = (ReplAndMarkers)closeable;
            boolean bl3 = false;
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(it){
                final /* synthetic */ ReplAndMarkers $it$inlined;
                {
                    this.$it$inlined = replAndMarkers;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$it$inlined.doReplace();
                    return (T)Unit.INSTANCE;
                }
            });
            if (PsiDocumentManager.getInstance((Project)this.project).commitAllDocumentsUnderProgress()) {
                $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction(new Computable<T>(it){
                    final /* synthetic */ ReplAndMarkers $it$inlined;
                    {
                        this.$it$inlined = replAndMarkers;
                    }

                    public final T compute() {
                        boolean bl = false;
                        this.$it$inlined.reformat();
                        return (T)Unit.INSTANCE;
                    }
                });
                it.showInEditor();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<OCGenerateUtil.Replacement> calculateReplacementsUnderProgress() {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        new Task.Modal(this, (Ref.ObjectRef)result2, this.project, OCBundle.message("generate.definitions.progress.text", new Object[0]), true){
            final /* synthetic */ OCGenerateDefinitionActionHandler this$0;
            final /* synthetic */ Ref.ObjectRef $result;

            public void run(@NotNull ProgressIndicator indicator) {
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)new Runnable(this){
                    final /* synthetic */ calculateReplacementsUnderProgress.1 this$0;

                    public final void run() {
                        this.this$0.$result.element = OCGenerateDefinitionActionHandler.access$getReplacements(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, (ProgressIndicator)indicator);
            }
            {
                this.this$0 = this$0;
                this.$result = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }.queue();
        List list = (List)result2.element;
        if (list == null) {
            throw (Throwable)new ProcessCanceledException();
        }
        return list;
    }

    private final List<OCGenerateUtil.Replacement> getReplacements() {
        if (this.shouldGenerate()) {
            OCCaretLocation location = OCCaretLocation.byFile(this.file);
            OCMembersContainer container = OCCppDefinitionsUtil.getFunctionParent(this.symbol, this.file.getProject());
            OCFunctionDeclaration oCFunctionDeclaration = this.symbol.locateFunctionDefinition(location.getProject());
            if (oCFunctionDeclaration == null) {
                return CollectionsKt.emptyList();
            }
            List predefPSIs = CollectionsKt.listOf((Object)oCFunctionDeclaration);
            return OCCppDefinitionsUtil.getGenerateDefinitionReplacements(location, container, CollectionsKt.listOf((Object)this.symbol), predefPSIs, this.policy, true);
        }
        return CollectionsKt.emptyList();
    }

    private final boolean shouldGenerate() {
        boolean bl;
        switch (OCGenerateDefinitionActionHandler$WhenMappings.$EnumSwitchMapping$0[OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(this.symbol, true, this.file.getProject()).ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.allowPossible;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final ReplAndMarkers getReplacementsWithMarkers(List<? extends OCGenerateUtil.Replacement> replacements, Project project2) {
        boolean bl = false;
        List replacementsWithMarkers = new ArrayList();
        for (OCGenerateUtil.Replacement replacement : replacements) {
            Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(replacement.position.file);
            if (document2 == null) continue;
            RangeMarker marker = document2.createRangeMarker(replacement.position.range);
            marker.setGreedyToRight(true);
            replacementsWithMarkers.add(new ReplAndMarker(replacement, marker));
        }
        return new ReplAndMarkers(replacementsWithMarkers);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OCFunctionSymbol getSymbol() {
        return this.symbol;
    }

    @NotNull
    public final OCCppDefinitionsUtil.InlinePolicy getPolicy() {
        return this.policy;
    }

    public final boolean getAllowPossible() {
        return this.allowPossible;
    }

    public OCGenerateDefinitionActionHandler(@NotNull Project project2, @NotNull PsiFile file2, @NotNull OCFunctionSymbol symbol, @NotNull OCCppDefinitionsUtil.InlinePolicy policy, boolean allowPossible) {
        this.project = project2;
        this.file = file2;
        this.symbol = symbol;
        this.policy = policy;
        this.allowPossible = allowPossible;
    }

    public static final /* synthetic */ List access$getReplacements(OCGenerateDefinitionActionHandler $this) {
        return $this.getReplacements();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionActionHandler$ReplAndMarker;", "", "replacement", "Lcom/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "(Lcom/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement;Lcom/intellij/openapi/editor/RangeMarker;)V", "getMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "getReplacement", "()Lcom/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.c"})
    public static final class ReplAndMarker {
        @NotNull
        private final OCGenerateUtil.Replacement replacement;
        @NotNull
        private final RangeMarker marker;

        @NotNull
        public final OCGenerateUtil.Replacement getReplacement() {
            return this.replacement;
        }

        @NotNull
        public final RangeMarker getMarker() {
            return this.marker;
        }

        public ReplAndMarker(@NotNull OCGenerateUtil.Replacement replacement, @NotNull RangeMarker marker) {
            this.replacement = replacement;
            this.marker = marker;
        }

        @NotNull
        public final OCGenerateUtil.Replacement component1() {
            return this.replacement;
        }

        @NotNull
        public final RangeMarker component2() {
            return this.marker;
        }

        @NotNull
        public final ReplAndMarker copy(@NotNull OCGenerateUtil.Replacement replacement, @NotNull RangeMarker marker) {
            return new ReplAndMarker(replacement, marker);
        }

        public static /* synthetic */ ReplAndMarker copy$default(ReplAndMarker replAndMarker, OCGenerateUtil.Replacement replacement, RangeMarker rangeMarker, int n, Object object) {
            if ((n & 1) != 0) {
                replacement = replAndMarker.replacement;
            }
            if ((n & 2) != 0) {
                rangeMarker = replAndMarker.marker;
            }
            return replAndMarker.copy(replacement, rangeMarker);
        }

        @NotNull
        public String toString() {
            return "ReplAndMarker(replacement=" + this.replacement + ", marker=" + this.marker + ")";
        }

        public int hashCode() {
            OCGenerateUtil.Replacement replacement = this.replacement;
            RangeMarker rangeMarker = this.marker;
            return (replacement != null ? replacement.hashCode() : 0) * 31 + (rangeMarker != null ? rangeMarker.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReplAndMarker)) break block3;
                    ReplAndMarker replAndMarker = (ReplAndMarker)object;
                    if (!Intrinsics.areEqual((Object)this.replacement, (Object)replAndMarker.replacement) || !Intrinsics.areEqual((Object)this.marker, (Object)replAndMarker.marker)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0006\u0010\f\u001a\u00020\tJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tJ\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionActionHandler$ReplAndMarkers;", "Ljava/io/Closeable;", "items", "", "Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionActionHandler$ReplAndMarker;", "(Ljava/util/Collection;)V", "getItems", "()Ljava/util/Collection;", "close", "", "component1", "copy", "doReplace", "equals", "", "other", "", "hashCode", "", "reformat", "showInEditor", "toString", "", "intellij.c"})
    public static final class ReplAndMarkers
    implements Closeable {
        @NotNull
        private final Collection<ReplAndMarker> items;

        @Override
        public void close() {
            Iterable $this$forEach$iv = this.items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReplAndMarker it = (ReplAndMarker)element$iv;
                boolean bl = false;
                it.getMarker().dispose();
            }
        }

        public final void doReplace() {
            Iterable $this$forEach$iv = this.items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReplAndMarker it = (ReplAndMarker)element$iv;
                boolean bl = false;
                it.getMarker().getDocument().replaceString(it.getMarker().getStartOffset(), it.getMarker().getEndOffset(), (CharSequence)it.getReplacement().text);
            }
        }

        public final void reformat() {
            Iterable $this$forEach$iv = this.items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReplAndMarker it = (ReplAndMarker)element$iv;
                boolean bl = false;
                int startOffset = it.getMarker().getStartOffset();
                int endOffset = CharArrayUtil.shiftForward((CharSequence)it.getMarker().getDocument().getCharsSequence(), (int)it.getMarker().getEndOffset(), (String)" \t\n");
                OCChangeUtil.reformatTextIfNotInjected(it.getReplacement().position.file, startOffset, endOffset);
            }
        }

        public final void showInEditor() {
            block0: {
                ReplAndMarker replAndMarker = (ReplAndMarker)CollectionsKt.firstOrNull((Iterable)this.items);
                if (replAndMarker == null) break block0;
                ReplAndMarker replAndMarker2 = replAndMarker;
                boolean bl = false;
                boolean bl2 = false;
                ReplAndMarker it = replAndMarker2;
                boolean bl3 = false;
                OCCodeInsightUtil.showCallableInEditorAndSelectBody(it.getReplacement().position.file, (Segment)it.getMarker(), (Condition<? super OCBlockStatement>)((Condition)showInEditor.1.1.INSTANCE));
            }
        }

        @NotNull
        public final Collection<ReplAndMarker> getItems() {
            return this.items;
        }

        public ReplAndMarkers(@NotNull Collection<ReplAndMarker> items) {
            this.items = items;
        }

        @NotNull
        public final Collection<ReplAndMarker> component1() {
            return this.items;
        }

        @NotNull
        public final ReplAndMarkers copy(@NotNull Collection<ReplAndMarker> items) {
            return new ReplAndMarkers(items);
        }

        public static /* synthetic */ ReplAndMarkers copy$default(ReplAndMarkers replAndMarkers, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                collection = replAndMarkers.items;
            }
            return replAndMarkers.copy(collection);
        }

        @NotNull
        public String toString() {
            return "ReplAndMarkers(items=" + this.items + ")";
        }

        public int hashCode() {
            Collection<ReplAndMarker> collection = this.items;
            return collection != null ? ((Object)collection).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReplAndMarkers)) break block3;
                    ReplAndMarkers replAndMarkers = (ReplAndMarkers)object;
                    if (!Intrinsics.areEqual(this.items, replAndMarkers.items)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

