/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCNewCppFunctionsLocator;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCExplicitSpecifier;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCNewImportLocation;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppDefinitionsUtil {
    private static final Comparator<OCGenerateUtil.Replacement> REPLACEMENT_COMPARATOR = (o1, o2) -> {
        if (!o1.position.file.equals(o2.position.file)) {
            return System.identityHashCode(o2.position.file) - System.identityHashCode(o1.position.file);
        }
        return o2.position.range.getStartOffset() - o1.position.range.getStartOffset();
    };

    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, boolean isOutOfClassDefinition, @NotNull PsiElement context2) {
        OCTypeElement trailingType;
        StringBuilder answer = new StringBuilder();
        FunctionQualifiedNameInfo qualInfo = isOutOfClassDefinition ? OCCppGeneratedQualifiedFunctionKt.getQualifiedNameAndTemplateHeader(function, context2) : new FunctionQualifiedNameInfo(function.getName(), "");
        answer.append(qualInfo.getTemplateHeader());
        answer.append(OCCppDefinitionsUtil.getCudaAttributes(function.getAttributes()));
        Project project2 = context2.getProject();
        OCFunctionDeclaration funDefinition = OCCppDefinitionsUtil.getFunctionDefinition(function, context2, project2);
        if (function.isConstexpr()) {
            answer.append("constexpr ");
        }
        if (!isOutOfClassDefinition) {
            if (function.isVirtual()) {
                answer.append("virtual ");
            }
            if (function.isFriend()) {
                answer.append("friend ");
            }
            if (function.isStatic()) {
                answer.append("static ");
            }
            if (function.isExplicit()) {
                Object explicitCond;
                OCExplicitSpecifier explicitSpecifier;
                answer.append("explicit");
                if (funDefinition != null && (explicitSpecifier = funDefinition.getExplicitSpecifier()) != null && (explicitCond = explicitSpecifier.getCondition()) != null) {
                    answer.append("(").append(explicitCond.getTextWithMacros()).append(")");
                }
                answer.append(" ");
            }
        }
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            if (funDefinition != null && funDefinition.getTrailingReturnTypeElement() != null) {
                answer.append("auto");
            } else {
                OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
                answer.append(function.getEffectiveResolvedType(resolveContext).getBestNameInContext(resolveContext, OCElementUtil.getReturnTypeTextWithModifiers(function, project2)));
            }
            answer.append(' ');
        }
        answer.append(qualInfo.getQualifiedName());
        answer.append('(');
        boolean isFirstParam = true;
        for (OCDeclaratorSymbol param : function.getParameterSymbols()) {
            if (!isFirstParam) {
                answer.append(", ");
            }
            isFirstParam = false;
            answer.append(OCElementFactory.declarationText(param.getName(), param.getType(), null, null, context2));
        }
        answer.append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (function.getType().isLValueRef()) {
            answer.append(" &");
        } else if (function.getType().isRValueRef()) {
            answer.append(" &&");
        }
        OCCppDefinitionsUtil.addNoexceptSpecifier(function, funDefinition, answer, context2);
        if (funDefinition != null && (trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
            answer.append(" -> ").append(trailingType.getType().resolve(context2).getBestNameInContext(context2, trailingType.getTextWithMacros()));
        }
        if (!isOutOfClassDefinition && function.isOverride()) {
            answer.append(" override");
        }
        if (!isOutOfClassDefinition && function.isFinal()) {
            answer.append(" final");
        }
        if (!isOutOfClassDefinition && function.isPureVirtual()) {
            answer.append(" = 0");
        }
        if (!isOutOfClassDefinition && function.isDefault()) {
            answer.append(" = default");
        }
        if (!isOutOfClassDefinition && function.isDelete()) {
            answer.append(" = delete");
        }
        return answer.toString();
    }

    @Nullable
    private static OCFunctionDeclaration getFunctionDefinition(@NotNull OCFunctionSymbol function, @NotNull PsiElement context2, @NotNull Project project2) {
        OCFunctionDeclaration funDefinition = function.locateFunctionDefinition(project2);
        if (funDefinition == null && context2 instanceof OCStruct) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
            ArrayList functionDecls = new ArrayList(1);
            OCStructSymbol scope = (OCStructSymbol)((OCStruct)context2).getSymbol();
            if (scope != null) {
                Condition condition = symbol -> symbol instanceof OCFunctionSymbol;
                Processor processor2 = symbol -> {
                    OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                    OCFunctionDeclaration decl = functionSymbol.locateFunctionDefinition(project2);
                    if (decl != null) {
                        functionDecls.add(decl);
                    }
                    return true;
                };
                String toFind = function.getName();
                OCStructType.processMembersInBaseTypes(scope, toFind, false, false, (Condition<? super OCSymbol>)condition, (Processor<? super OCSymbol>)processor2, resolveContext);
                if (!functionDecls.isEmpty()) {
                    funDefinition = (OCFunctionDeclaration)functionDecls.get(0);
                }
            }
        }
        return funDefinition;
    }

    private static String getCudaAttributes(@NotNull List<String> attributes) {
        return attributes.stream().map(it -> it.replace("_", "")).filter(it -> OCAttributes.CUDA_ATTRIBUTES.contains(it)).map(it -> String.format("__%s__ ", it)).collect(Collectors.joining());
    }

    private static boolean isOverrideSpecifier(@NotNull String text) {
        return text.equals("override") || text.equals("final");
    }

    private static boolean isNoexceptSpecifier(@NotNull String text) {
        return text.startsWith("noexcept") || text.startsWith("throw");
    }

    private static boolean addTrailingMacroCalls(@NotNull OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer) {
        boolean hasMacroNoexcept = false;
        OCMacroCall[] macroCalls = (OCMacroCall[])PsiTreeUtil.getChildrenOfType((PsiElement)funDefinition.getDeclarator(), OCMacroCall.class);
        if (macroCalls != null) {
            for (OCMacroCall macro : macroCalls) {
                String replacementText = macro.getReplacementText();
                if (OCCppDefinitionsUtil.isOverrideSpecifier(replacementText)) continue;
                String macroText = macro.getText();
                if (macroText != null && !macroText.isEmpty()) {
                    answer.append(" ");
                    answer.append(macroText);
                }
                hasMacroNoexcept = OCCppDefinitionsUtil.isNoexceptSpecifier(replacementText);
            }
        }
        return hasMacroNoexcept;
    }

    private static void addNoexceptSpecifier(@NotNull OCFunctionSymbol function, @Nullable OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer, @NotNull PsiElement context2) {
        boolean hasMacroNoexcept = false;
        if (funDefinition != null) {
            hasMacroNoexcept = OCCppDefinitionsUtil.addTrailingMacroCalls(funDefinition, answer);
        }
        if (!hasMacroNoexcept) {
            OCExceptionSpecificationInfo exceptionSpecificationInfo = function.getType().getExceptionSpecification();
            switch (exceptionSpecificationInfo.getSpecificationKind()) {
                case None: {
                    break;
                }
                case DynamicNone: {
                    answer.append(" throw()");
                    break;
                }
                case Dynamic: {
                    if (OCCppDefinitionsUtil.addThrowText(funDefinition, answer)) break;
                    answer.append(" throw(");
                    for (int i2 = 0; i2 < exceptionSpecificationInfo.getThrowTypes().size(); ++i2) {
                        OCType throwType = exceptionSpecificationInfo.getThrowTypes().get(i2);
                        if (i2 > 0) {
                            answer.append(", ");
                        }
                        answer.append(throwType.getName(context2));
                    }
                    answer.append(")");
                    break;
                }
                case MSAny: {
                    answer.append(" throw(...)");
                    break;
                }
                case BasicNoexcept: {
                    answer.append(" noexcept");
                    break;
                }
                case ComputedNoexcept: {
                    answer.append(" noexcept(");
                    if (!OCCppDefinitionsUtil.addNoexceptExpressionText(funDefinition, answer)) {
                        answer.append(exceptionSpecificationInfo.getNoexceptExpression().getPresentableText());
                    }
                    answer.append(")");
                }
            }
        }
    }

    private static boolean addNoexceptExpressionText(@Nullable OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer) {
        if (funDefinition == null) {
            return false;
        }
        OCNoexceptSpecifier noexceptSpecifier = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)funDefinition, OCNoexceptSpecifier.class);
        if (noexceptSpecifier == null) {
            return false;
        }
        OCExpression noexceptOperand = noexceptSpecifier.getOperand();
        if (noexceptOperand == null) {
            return false;
        }
        String inParens = noexceptOperand.getTextWithMacros();
        answer.append(inParens);
        return true;
    }

    private static boolean addThrowText(@Nullable OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer) {
        if (funDefinition == null || funDefinition.getDeclarator() == null) {
            return false;
        }
        String funDefText = funDefinition.getDeclarator().getText();
        int beginIdx = funDefText.lastIndexOf("throw(");
        int endIdx = funDefText.indexOf(")", beginIdx);
        if (beginIdx == -1 || endIdx == -1) {
            return false;
        }
        String throwsText = funDefText.substring(beginIdx, endIdx + 1);
        answer.append(" ").append(throwsText);
        return true;
    }

    @NotNull
    public static SHOULD_GENERATE_DEFINITION shouldGenerateDefinitionsFor(@NotNull OCFunctionSymbol function, boolean checkNoncopyable, @NotNull Project project2) {
        OCType type;
        List<OCType> parameterTypes;
        PsiFile file2 = function.getContainingPsiFile(project2);
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (function.isPureVirtual()) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!function.processSameSymbols((Processor<OCSymbol>)((Processor)s -> s.isPredeclaration() && (!(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isDefault() && !((OCFunctionSymbol)s).isDelete())), project2)) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!(function.getParent() instanceof OCStructSymbol)) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        if (checkNoncopyable && function.getVisibility() == OCVisibility.PRIVATE && (function.isCppConstructor() || function.isCppOperator() && function.getName().equals("operator=")) && (parameterTypes = function.getType().getParameterTypes()).size() == 1 && (type = parameterTypes.get(0)) instanceof OCCppReferenceType && function.getParent().getType().cloneWithConstModifier(project2).equalsAfterResolving(((OCCppReferenceType)type).getRefType(), OCResolveContext.forSymbol(function, project2))) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        return SHOULD_GENERATE_DEFINITION.REQUIRED;
    }

    @NotNull
    public static OCMembersContainer getFunctionParent(@NotNull OCFunctionSymbol function, @NotNull Project project2) {
        return function.getParent() instanceof OCNamespaceLikeSymbol ? (OCNamespaceLikeSymbol)((Object)function.getParent()) : function.getContainingOCFile(project2).getMembersContainer(false);
    }

    public static boolean shouldInlineNewDefinitions(@NotNull OCMembersContainer parent, @NotNull OCCaretLocation location) {
        Project project2 = location.getProject();
        if (location.getElement() != null) {
            if (!(parent instanceof OCSymbol) && parent.getContainingOCFile(project2).equals(location.getFile()) && OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2)) {
                return false;
            }
            if (OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project2))) {
                return false;
            }
        }
        return OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions((OCMembersContainer)parent, (Project)project2).shouldInline;
    }

    @Nullable
    public static OCGenerateUtil.ReplacePosition getOutsidePreferredPosition(@NotNull PsiFile file2, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions) {
        OCFile sourceFile;
        if (functions.isEmpty() || !(file2 instanceof OCFile)) {
            return null;
        }
        Project project2 = file2.getProject();
        BasedOnExistingResult basedOnExisting = OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions(parent, project2);
        if (basedOnExisting.outsideLocation != null) {
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby((Integer)basedOnExisting.outsideLocation.second, (PsiFile)basedOnExisting.outsideLocation.first);
        }
        if (OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2) && functions.stream().noneMatch(OCFunctionSymbol::isTemplateSymbol) && (sourceFile = ((OCFile)file2).getAssociatedFile()) != null && !sourceFile.isHeader()) {
            PsiElement insertionParent = OCCppDefinitionsUtil.findInsertionParentInFile(sourceFile, (OCNamespaceSymbol)ObjectUtils.tryCast((Object)parent, OCNamespaceSymbol.class));
            ASTNode child = insertionParent.getNode().findChildByType((IElementType)OCTokenTypes.RBRACE);
            PsiElement rBrace = child != null ? child.getPsi() : null;
            int desiredOffset = rBrace != null ? rBrace.getTextRange().getStartOffset() : insertionParent.getTextRange().getEndOffset();
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(desiredOffset, sourceFile);
        }
        PsiElement fallbackLocation = OCCppDefinitionsUtil.defaultFallbackLocation(file2, OCCppDefinitionsUtil.getParentDefinition(parent, project2), functions);
        return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(fallbackLocation.getTextRange().getEndOffset(), fallbackLocation.getContainingFile());
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getGenerateDefinitionReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @NotNull List<? extends OCCallable> predefinitions, @NotNull InlinePolicy inlinePolicy, boolean addImportReplacements) {
        if (inlinePolicy.shouldInline(location, parent)) {
            ArrayList<OCGenerateUtil.Replacement> replacements = new ArrayList<OCGenerateUtil.Replacement>(functions.size());
            assert (functions.size() == predefinitions.size());
            for (int i2 = 0; i2 < functions.size(); ++i2) {
                PsiElement semicolon;
                OCFunctionSymbol symbol = functions.get(i2);
                OCCallable predefinition = predefinitions.get(i2);
                if (predefinition == null) continue;
                PsiElement lastChild = predefinition.getLastChild();
                PsiElement psiElement = semicolon = !OCElementUtil.isElementSignificant(lastChild) ? OCElementUtil.getPrevSignificantSibling(lastChild) : lastChild;
                if (semicolon == null || OCElementUtil.getElementType(semicolon) != OCTokenTypes.SEMICOLON) continue;
                replacements.add(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(predefinition.getContainingOCFile(), semicolon.getTextRange(), predefinition, false), OCCallableUtil.defaultFunctionBody(symbol, OCCallableUtil.getDefaultBaseToCall(symbol, predefinition.getProject()), predefinition)));
            }
            return replacements;
        }
        return OCCppDefinitionsUtil.getOutsideReplacements(location, parent, functions, null, addImportReplacements);
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getNewFunctionsReplacements(@NotNull OCCaretLocation location, @NotNull OCStructLike structDefinition, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> symbols, @Nullable List<String> bodies, @NotNull InlinePolicy inlinePolicy) {
        if (symbols.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder insideClassText = new StringBuilder();
        boolean shouldInline = inlinePolicy.shouldInline(location, parent);
        OCStructLike contextToCalculateNames = structDefinition;
        int insertPositionInsideClass = OCCppDefinitionsUtil.getInsertPositionForFunctionsInsideClass(structDefinition, location, symbols.get(0));
        OCVisibility initialVisibility = OCVisibility.getVisibilityAtOffset(structDefinition, insertPositionInsideClass);
        assert (initialVisibility != null);
        OCVisibility curVisibility = initialVisibility;
        for (int i2 = 0; i2 < symbols.size(); ++i2) {
            OCFunctionSymbol functionSymbol = symbols.get(i2);
            OCVisibility visibility = functionSymbol.getVisibility();
            if (visibility != curVisibility) {
                insideClassText.append((Object)visibility).append(": ");
                curVisibility = visibility;
            }
            String afterSignature = shouldInline && !functionSymbol.isDefault() && !functionSymbol.isDelete() ? (bodies == null ? OCCallableUtil.defaultFunctionBody(functionSymbol, OCCallableUtil.getDefaultBaseToCall(functionSymbol, location.getProject()), contextToCalculateNames) : bodies.get(i2)) : ";";
            insideClassText.append(OCCppDefinitionsUtil.functionSignature(functionSymbol, false, structDefinition)).append(afterSignature);
        }
        if (OCCppDefinitionsUtil.shouldRestoreVisibility(structDefinition, insertPositionInsideClass, initialVisibility, curVisibility)) {
            insideClassText.append((Object)initialVisibility).append(": ");
        }
        PsiFile structDefinitionFile = structDefinition.getContainingFile();
        Document structDefinitionDocument = PsiDocumentManager.getInstance((Project)location.getProject()).getDocument(structDefinitionFile);
        if (structDefinitionDocument == null) {
            OCLog.LOG.warn("No document for " + structDefinitionFile);
            return Collections.emptyList();
        }
        List<OCGenerateUtil.Replacement> insideClassReplacements = Collections.singletonList(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(structDefinitionFile, TextRange.from((int)insertPositionInsideClass, (int)0), contextToCalculateNames), insideClassText.toString()));
        List outsideClassReplacements = shouldInline ? Collections.emptyList() : OCCppDefinitionsUtil.getOutsideReplacements(location, parent, symbols, bodies, false);
        return ContainerUtil.concat(insideClassReplacements, outsideClassReplacements);
    }

    @Nullable
    public static PsiElement getParentDefinition(@NotNull OCMembersContainer parent, @NotNull Project project2) {
        return parent instanceof OCSymbol ? ((OCSymbol)((Object)parent)).locateDefinition(project2) : parent.getContainingOCFile(project2);
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> getOutsideReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @Nullable List<String> bodies, boolean addImportReplacements) {
        OCGenerateUtil.ReplacePosition position;
        OCGenerateUtil.ReplacePosition replacePosition = position = OCCppDefinitionsUtil.shouldGenerateOutsideDefinitionAtCaret(location, parent) ? OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location) : OCCppDefinitionsUtil.getOutsidePreferredPosition(location.getFile(), parent, functions);
        if (position == null) {
            OCLog.LOG.warn("Can't find outside position for file '" + location.getFile() + "'");
            return Collections.emptyList();
        }
        THashSet filesToInclude = new THashSet();
        StringBuilder text = new StringBuilder();
        OCFile targetFile = (OCFile)position.file;
        for (int i2 = 0; i2 < functions.size(); ++i2) {
            OCFunctionSymbol function = functions.get(i2);
            if (function.isDefault() || function.isDelete()) continue;
            text.append(OCCppDefinitionsUtil.functionSignature(function, true, position.context)).append(bodies != null ? bodies.get(i2) : OCCallableUtil.defaultFunctionBody(function, OCCallableUtil.getDefaultBaseToCall(function, location.getProject()), position.context));
            VirtualFile fileToInclude = OCCppDefinitionsUtil.getFileToIncludeIfNeeded(function, targetFile);
            if (fileToInclude == null) continue;
            filesToInclude.add(fileToInclude);
        }
        OCGenerateUtil.Replacement incl = addImportReplacements ? OCCppDefinitionsUtil.calcIncludeReplacement(position, targetFile, (Set<VirtualFile>)filesToInclude) : null;
        OCGenerateUtil.Replacement definitions = new OCGenerateUtil.Replacement(position, text.toString());
        return incl == null ? Collections.singletonList(definitions) : OCCppDefinitionsUtil.mergeReplacements(Arrays.asList(incl, definitions));
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> mergeReplacements(@NotNull List<OCGenerateUtil.Replacement> replacements) {
        replacements = ContainerUtil.sorted(replacements, REPLACEMENT_COMPARATOR);
        ArrayList<OCGenerateUtil.Replacement> res = new ArrayList<OCGenerateUtil.Replacement>(replacements.size());
        for (OCGenerateUtil.Replacement r : replacements) {
            int lastIdx = res.size() - 1;
            if (res.isEmpty() || !OCCppDefinitionsUtil.intersects(res.get(lastIdx), r)) {
                res.add(r);
                continue;
            }
            res.set(lastIdx, OCCppDefinitionsUtil.union(res.get(lastIdx), r));
        }
        return res;
    }

    private static boolean intersects(@NotNull OCGenerateUtil.Replacement a, @NotNull OCGenerateUtil.Replacement b) {
        if (!a.position.file.equals(b.position.file)) {
            return false;
        }
        return a.position.range.intersects(b.position.range);
    }

    @NotNull
    private static OCGenerateUtil.Replacement union(@NotNull OCGenerateUtil.Replacement a, @NotNull OCGenerateUtil.Replacement b) {
        assert (a.position.file.equals(b.position.file));
        return new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(a.position.file, a.position.range.union(b.position.range), a.position.context, a.position.addNewLineBefore, b.position.addNewLineAfter), a.text + b.text);
    }

    @Nullable
    private static OCGenerateUtil.Replacement calcIncludeReplacement(OCGenerateUtil.ReplacePosition position, OCFile targetFile, Set<VirtualFile> filesToInclude) {
        List specs = filesToInclude.stream().map(vf -> OCImportSymbolFix.getFileNameToImport(vf, position.file)).filter(Objects::nonNull).sorted(Comparator.comparing(OCAutoImportHelper.ImportSpecification::getImportText)).collect(Collectors.toList());
        if (!specs.isEmpty()) {
            OCAutoImportHelper.ImportSpecification first = (OCAutoImportHelper.ImportSpecification)ContainerUtil.getFirstItem(specs);
            assert (first != null);
            OCNewImportLocation importLoc = OCImportSymbolFix.calcNewImportLocation(targetFile, position.range.getStartOffset(), "#include " + first.getImportText(), OCImportSymbolFix.ImportStyle.INCLUDE, first.getPreferredDelimiters());
            if (importLoc.getInsertAnchor() != null) {
                int offset = importLoc.getInsertBefore() ? importLoc.getInsertAnchor().getTextRange().getStartOffset() : importLoc.getInsertAnchor().getTextRange().getEndOffset();
                String includeText = specs.stream().map(spec -> "#include " + spec.getImportText() + "\n").collect(Collectors.joining());
                return new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(targetFile, TextRange.from((int)offset, (int)0), position.context), includeText);
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFileToIncludeIfNeeded(@NotNull OCFunctionSymbol function, @NotNull OCFile file2) {
        VirtualFile targetVF = file2.getVirtualFile();
        VirtualFile symbolVF = function.getContainingFile();
        if (targetVF == null || symbolVF == null || targetVF.equals(symbolVF)) {
            return null;
        }
        OCImportGraph importGraph = OCImportGraph.getInstance(file2.getProject());
        for (VirtualFile included : importGraph.findImmediateIncludingFiles(symbolVF, false)) {
            if (!targetVF.equals(included)) continue;
            return null;
        }
        return symbolVF;
    }

    @NotNull
    private static BasedOnExistingResult getBestLocationBasedOnExistingDefinitions(@NotNull OCMembersContainer parent, final @NotNull Project project2) {
        final OCFile topLevelFile = parent instanceof OCSymbol ? null : parent.getContainingOCFile(project2);
        class OffsetProcessor
        implements Processor {
            public boolean hasInlineDefinition = false;
            public boolean hasOutsideDefinition = false;
            public int maxOffset = 0;
            public PsiFile file = null;

            OffsetProcessor() {
            }

            @Nullable
            Pair<PsiFile, Integer> location() {
                return this.file == null ? null : Pair.create((Object)this.file, (Object)this.maxOffset);
            }

            boolean shouldBeInlined(@NotNull OCMembersContainer parent) {
                return !this.hasOutsideDefinition && (this.hasInlineDefinition || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2));
            }

            public boolean process(Object o) {
                ProgressManager.checkCanceled();
                if (!(o instanceof OCSymbol)) {
                    return true;
                }
                OCSymbol symbol = (OCSymbol)o;
                if (symbol.isPredeclaration()) {
                    PsiFile definitionFile;
                    PsiElement definition;
                    if (topLevelFile != null && symbol.getContainingOCFile(project2) != topLevelFile) {
                        return true;
                    }
                    OCSymbol definitionSymbol = symbol.getDefinitionSymbol(project2);
                    if (definitionSymbol != null && (definition = definitionSymbol.locateDefinition(project2)) != null && (definitionFile = definition.getContainingFile()) != null) {
                        if (this.file == null && OCCodeInsightUtil.isValid((PsiElement)definitionFile)) {
                            this.file = definitionFile;
                            this.hasOutsideDefinition = true;
                        }
                        if (this.file != null && this.file.equals(definitionFile)) {
                            this.maxOffset = Math.max(this.maxOffset, definition.getTextRange().getEndOffset());
                        }
                    }
                } else if (symbol instanceof OCFunctionSymbol) {
                    this.hasInlineDefinition = true;
                }
                return true;
            }
        }
        OffsetProcessor processor2 = new OffsetProcessor();
        parent.processMembers(null, processor2);
        return new BasedOnExistingResult(processor2.shouldBeInlined(parent), processor2.location());
    }

    private static boolean canDefinitionsBePlacedToAssocFile(@NotNull OCMembersContainer parent, @NotNull Project project2) {
        OCFile file2 = parent.getContainingOCFile(project2);
        if (file2 == null || !file2.isHeader()) {
            return false;
        }
        OCFile assoc = file2.getAssociatedFile();
        if (assoc == null || assoc.isHeader()) {
            return false;
        }
        return !(parent instanceof OCTemplateSymbol) || !((OCTemplateSymbol)((Object)parent)).isTemplateSymbol();
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(@NotNull OCCaretLocation location) {
        return location.getOffsetInFile() == null ? null : OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location.getOffsetInFile(), location.getFile());
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(int originalOffset, @NotNull PsiFile file2) {
        PsiElement atCaret;
        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document2 == null) {
            OCLog.LOG.warn("No document for " + file2);
            return null;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret = (PsiElement)ObjectUtils.notNull((Object)file2.findElementAt(originalOffset), (Object)file2); curr != null; curr = curr.getParent()) {
            if (curr instanceof OCCppNamespace || curr instanceof PsiFile) {
                int preferredOffset = -1;
                PsiElement context2 = null;
                if (curr instanceof OCCppNamespace && prev != null) {
                    boolean insideNamespaceHeader = false;
                    for (PsiElement nsChild = curr.getFirstChild(); nsChild != curr.getLastChild(); nsChild = nsChild.getNextSibling()) {
                        if (nsChild.equals(prev)) {
                            insideNamespaceHeader = true;
                        }
                        if (OCElementUtil.getElementType(nsChild) != OCTokenTypes.LBRACE) continue;
                        if (!insideNamespaceHeader) break;
                        preferredOffset = nsChild.getTextRange().getEndOffset();
                        context2 = curr;
                        break;
                    }
                }
                if (context2 == null) {
                    boolean isInsideComment = prev instanceof PsiComment && originalOffset > prev.getTextRange().getStartOffset();
                    preferredOffset = (prev == atCaret || prev == null) && !isInsideComment ? originalOffset : prev.getTextRange().getEndOffset();
                    context2 = curr;
                }
                return new OCGenerateUtil.ReplacePosition(file2, TextRange.from((int)preferredOffset, (int)0), context2);
            }
            prev = curr;
        }
        return null;
    }

    @NotNull
    private static PsiElement defaultFallbackLocation(@NotNull PsiFile file2, @Nullable PsiElement parentDefinition, @NotNull List<OCFunctionSymbol> functions) {
        int maxOffset = -1;
        OCFunctionDeclaration result2 = null;
        for (OCFunctionSymbol symbol : functions) {
            OCFunctionDeclaration definition = symbol.locateFunctionDefinition(file2.getProject());
            if (definition == null) continue;
            int offset = definition.getTextRange().getEndOffset();
            if (!file2.equals(definition.getContainingFile()) || offset <= maxOffset) continue;
            maxOffset = offset;
            result2 = definition;
        }
        if (result2 != null) {
            return result2;
        }
        if (parentDefinition != null && file2.equals(parentDefinition.getContainingFile())) {
            return parentDefinition;
        }
        return file2;
    }

    private static int getInsertPositionForFunctionsInsideClass(@NotNull OCStructLike structDefinition, @NotNull OCCaretLocation location, @NotNull OCFunctionSymbol newFunction) {
        int defaultOffset = OCNewCppFunctionsLocator.locateNewFunction(structDefinition, newFunction);
        if (location.getOffsetInFile() == null || !location.getFile().equals(structDefinition.getContainingFile())) {
            return defaultOffset;
        }
        int offset = location.getOffsetInFile();
        if (!OCNewCppFunctionsLocator.getValidLocationRange(structDefinition).contains(offset)) {
            return defaultOffset;
        }
        if (OCCppDefinitionsUtil.isLocationOutsideParent(location, structDefinition)) {
            return defaultOffset;
        }
        PsiElement elementToInsertAfter = null;
        boolean betweenVisibilityAndColon = false;
        for (PsiElement child = structDefinition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (OCElementUtil.isVisibilityKeyword(child.getNode())) {
                betweenVisibilityAndColon = true;
            } else if (OCElementUtil.getElementType(child) == OCTokenTypes.COLON) {
                betweenVisibilityAndColon = false;
            }
            if (betweenVisibilityAndColon || child.getTextRange().getEndOffset() < offset) continue;
            elementToInsertAfter = child;
            break;
        }
        if (elementToInsertAfter instanceof PsiWhiteSpace && elementToInsertAfter.getTextRange().contains(offset)) {
            return offset;
        }
        if (elementToInsertAfter != null) {
            return elementToInsertAfter.getTextRange().getEndOffset();
        }
        return defaultOffset;
    }

    private static boolean shouldRestoreVisibility(@NotNull OCStructLike definition, int pos, @NotNull OCVisibility initial, @Nullable OCVisibility lastNew) {
        if (initial == lastNew) {
            return false;
        }
        for (PsiElement child = definition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getTextRange().getStartOffset() < pos) continue;
            if (child instanceof OCDeclaration) {
                return true;
            }
            if (OCVisibility.getVisibilityFromElement(child) == null) continue;
            return false;
        }
        return false;
    }

    private static boolean isLocationOutsideParent(@NotNull OCCaretLocation location, @Nullable PsiElement parentDefinition) {
        assert (location.getElement() != null);
        return !PsiTreeUtil.isAncestor((PsiElement)parentDefinition, (PsiElement)location.getElement(), (boolean)false);
    }

    private static boolean shouldGenerateOutsideDefinitionAtCaret(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
        if (location.getElement() == null) {
            return false;
        }
        Project project2 = location.getProject();
        if (!(parent instanceof OCSymbol)) {
            return !parent.getContainingOCFile(project2).equals(location.getFile()) || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2);
        }
        return OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project2));
    }

    @NotNull
    private static PsiElement findInsertionParentInFile(OCFile file2, OCNamespaceSymbol parent) {
        PsiElement namespacePsi;
        ArrayList<OCNamespaceSymbol> parentsPath = new ArrayList<OCNamespaceSymbol>();
        while (parent != null) {
            if (!(parent instanceof OCStructSymbol)) {
                parentsPath.add(0, parent);
            }
            parent = (OCNamespaceSymbol)parent.getParent();
        }
        OCNamespaceLikeSymbol current = file2.getMembersContainer(false);
        for (OCNamespaceSymbol symbol : parentsPath) {
            final VirtualFile virtualFile = file2.getContainingFile().getVirtualFile();
            CommonProcessors.FindFirstProcessor<OCNamespaceSymbol> finder = new CommonProcessors.FindFirstProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    ProgressManager.checkCanceled();
                    return virtualFile != null && virtualFile.equals(symbol.getContainingFile());
                }
            };
            current.processMembers(symbol.getName(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)finder, OCNamespaceSymbol.class));
            if (!finder.isFound()) break;
            current = (OCNamespaceLikeSymbol)finder.getFoundValue();
        }
        if (current instanceof OCNamespaceSymbol && (namespacePsi = ((OCNamespaceSymbol)current).locateDefinition(file2.getProject())) != null) {
            return namespacePsi;
        }
        return file2;
    }

    private static class BasedOnExistingResult {
        public final boolean shouldInline;
        @Nullable
        public final Pair<PsiFile, Integer> outsideLocation;

        private BasedOnExistingResult(boolean inline, @Nullable Pair<PsiFile, Integer> location) {
            this.shouldInline = inline;
            this.outsideLocation = location;
            assert (this.outsideLocation == null || !this.shouldInline);
        }
    }

    public static enum InlinePolicy {
        INLINE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return true;
            }
        }
        ,
        OUTSIDE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return false;
            }
        }
        ,
        PREFERRED{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return OCCppDefinitionsUtil.shouldInlineNewDefinitions(parent, location);
            }
        };


        public abstract boolean shouldInline(@NotNull OCCaretLocation var1, @NotNull OCMembersContainer var2);

        public static InlinePolicy get(boolean inline) {
            return inline ? INLINE : OUTSIDE;
        }
    }

    public static enum SHOULD_GENERATE_DEFINITION {
        NO,
        POSSIBLE,
        REQUIRED;

    }
}

