/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCPreprocessorFormatterData;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMultilineNodeFormatter {
    public static final Key<Pair<Boolean, OCPreprocessorFormatterData.OCIndentInfo>> PREPROCESSOR_INFO = Key.create((String)"PREPROCESSOR_INFO");
    public static final Key<Integer> CODE_INDENT = Key.create((String)"CODE_INDENT");
    public static final Key<Boolean> AT_FIRST_COL_HINT = Key.create((String)"AT_FIRST_COL_HINT");
    public static final int DIRTY_SPACE_COUNT = 120;
    @NotNull
    private final CodeStyleSettings mySettings;

    public OCMultilineNodeFormatter(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    @NotNull
    public static OCMultilineNodeFormatter create(@NotNull PsiFile file2) {
        return new OCMultilineNodeFormatter(CodeStyle.getSettings((PsiFile)file2));
    }

    @NotNull
    public OCCodeStyleSettings getOCSettings() {
        return (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
    }

    public TextRange shiftIndentInsideRangeInDocument(final @NotNull Document document2, @NotNull ASTNode node2, final @NotNull TextRange textRange, int shift) {
        return this.shiftIndentInsideRangeEx(node2, textRange, shift, new DocumentModifier(){

            @Override
            public TextRange change(boolean isNonCompiled, String newText, String oldText) {
                document2.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
                return new TextRange(textRange.getStartOffset(), textRange.getEndOffset() + newText.length() - oldText.length());
            }
        });
    }

    public TextRange shiftIndentInsideRangeInPsiTree(final @NotNull ASTNode node2, final @NotNull TextRange textRange, int shift) {
        return this.shiftIndentInsideRangeEx(node2, textRange, shift, new DocumentModifier(){

            @Override
            public TextRange change(boolean isNonCompiled, String newText, String oldText) {
                PsiElement element = node2.getPsi();
                ASTNode actualASTParent = node2.getTreeParent();
                if (actualASTParent != null) {
                    PsiElement newElement = isNonCompiled ? PsiTreeUtil.findChildOfType((PsiElement)OCElementFactory.codeFragment("#if 1\n#else\n" + newText + "\n#endif", element.getProject(), element, false, false), PsiComment.class) : OCElementFactory.codeFragment(newText, element.getProject(), element, false, false).getFirstChild();
                    assert (newElement != null);
                    ASTNode newASTNode = newElement.getNode();
                    if (newASTNode != null) {
                        if (isNonCompiled) {
                            int shift;
                            Pair info = (Pair)PREPROCESSOR_INFO.get((UserDataHolder)node2);
                            if (info != null && info.first != null) {
                                AT_FIRST_COL_HINT.set((UserDataHolder)newASTNode, info.first);
                            }
                            if ((shift = newText.length() - newASTNode.getTextLength()) != 0) {
                                CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newASTNode), (int)(-shift));
                            } else {
                                OCElementFactory.initIndentFromContext(element, newElement);
                            }
                        } else {
                            OCElementFactory.initIndentFromContext(element, newElement);
                        }
                        CodeEditUtil.replaceChild((ASTNode)actualASTParent, (ASTNode)node2, (ASTNode)newASTNode);
                        return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + newASTNode.getTextLength());
                    }
                }
                return textRange;
            }
        });
    }

    private TextRange shiftIndentInsideRangeEx(@NotNull ASTNode node2, @NotNull TextRange textRange, int shift, @NotNull DocumentModifier modifier) {
        boolean isNonCompiled;
        IElementType type = OCElementUtil.getElementType(node2);
        boolean bl = isNonCompiled = type == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT;
        if (type == OCTokenTypes.BLOCK_COMMENT || isNonCompiled) {
            if (isNonCompiled) {
                Pair info = (Pair)PREPROCESSOR_INFO.get((UserDataHolder)node2);
                Integer codeIndent = (Integer)CODE_INDENT.get((UserDataHolder)node2);
                if (info != null && codeIndent != null) {
                    String oldText = node2.getText();
                    String newText = this.directiveIndentCorrection((Pair<Boolean, OCPreprocessorFormatterData.OCIndentInfo>)info, codeIndent, shift, false, oldText);
                    if (!newText.equals(oldText)) {
                        return modifier.change(true, newText, oldText);
                    }
                }
            } else {
                String oldText = node2.getText();
                String newText = this.getShiftedLeafText(shift, oldText);
                if (!newText.equals(oldText)) {
                    return modifier.change(false, newText, oldText);
                }
            }
        }
        return textRange;
    }

    @NotNull
    private String getShiftedLeafText(int shift, @NotNull String leafText) {
        int leafTextLength = leafText.length();
        int startOffset = 0;
        boolean firstLine = true;
        StringBuilder newCommentText = new StringBuilder();
        while (startOffset < leafTextLength) {
            int indent;
            char ch = ' ';
            StringBuilder originalIndent = new StringBuilder();
            while (startOffset < leafTextLength) {
                char c = leafText.charAt(startOffset);
                ch = c;
                if (!OCMultilineNodeFormatter.isSpaceChar(c)) break;
                ++startOffset;
                originalIndent.append(ch);
            }
            if (!(firstLine && originalIndent.length() <= 0 || (indent = this.normalizedTabLength(originalIndent.toString())) + shift <= 0)) {
                newCommentText.append(this.getStringIndent(indent + shift));
            }
            while (startOffset < leafTextLength && (ch = leafText.charAt(startOffset)) != '\n') {
                ++startOffset;
                newCommentText.append(ch);
            }
            if (ch != 10) continue;
            ++startOffset;
            newCommentText.append(ch);
            firstLine = false;
        }
        return newCommentText.toString();
    }

    public String directiveIndentCorrection(@NotNull Pair<Boolean, OCPreprocessorFormatterData.OCIndentInfo> info, int codeIndent, int shift, boolean replaceEmptyLinesByCodeIndent, @NotNull String leafText) {
        OCCodeStyleSettings ocCodeStyleSettings = this.getOCSettings();
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)leafText);
        shift -= 120;
        OCPreprocessorFormatterData preprocessorFormatterData = new OCPreprocessorFormatterData();
        preprocessorFormatterData.setIndentAtLevel((OCPreprocessorFormatterData.OCIndentInfo)info.second);
        ++preprocessorFormatterData.directiveNestLevel;
        StringBuilder code = new StringBuilder(leafText.length());
        OCPreprocessorFormatterData.OCIndentInfo[] lineTypes = new OCPreprocessorFormatterData.OCIndentInfo[lines.length];
        boolean inDirective = false;
        int endOfMultiline = -1;
        int endOfCodeSkip = -1;
        boolean needContinuation = false;
        boolean firstCodeLine = true;
        boolean firstLineIsDirective = false;
        boolean firstLineNeedIndentCorrection = false;
        int offset = 0;
        int prevIndent = codeIndent;
        boolean resetIndentInDirectiveSequence = false;
        boolean afterDirective = false;
        for (int lineNo = 0; lineNo < lines.length; ++lineNo) {
            String origLine = lines[lineNo];
            int length = origLine.length();
            if (offset >= endOfMultiline && OCMultilineNodeFormatter.dropStringIndent(origLine).startsWith("#")) {
                IElementType tokenType;
                OCLexerWithDirectives contentLexer = OCLexerWithDirectives.createDefault();
                contentLexer.start(origLine);
                while ((tokenType = contentLexer.getTokenType()) != null) {
                    if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(tokenType)) {
                        inDirective = true;
                        lineTypes[lineNo] = OCPreprocessorFormatterData.OCIndentInfo.createPostponedDirectiveInfo(tokenType, resetIndentInDirectiveSequence);
                        resetIndentInDirectiveSequence = false;
                        afterDirective = true;
                        break;
                    }
                    contentLexer.advance();
                }
            } else if (!needContinuation) {
                if (offset >= endOfCodeSkip) {
                    if (lineNo > 0) {
                        int curIndent = this.indent(origLine);
                        if (prevIndent != curIndent && !afterDirective) {
                            resetIndentInDirectiveSequence = true;
                        }
                        prevIndent = curIndent;
                    }
                    afterDirective = false;
                    if (firstCodeLine && !OCMultilineNodeFormatter.isWhitespaceString(origLine)) {
                        if (firstLineIsDirective) {
                            int firstLineCodeIndent = this.indent(origLine);
                            firstLineNeedIndentCorrection = firstLineCodeIndent == 0;
                            shift = codeIndent - firstLineCodeIndent;
                            code.append(origLine);
                        } else {
                            code.append(OCMultilineNodeFormatter.dropStringIndent(origLine));
                        }
                        firstCodeLine = false;
                    } else {
                        code.append(origLine);
                    }
                    lineTypes[lineNo] = OCPreprocessorFormatterData.OCIndentInfo.createCodeInfo(OCPreprocessorFormatterData.OffsetType.CODE_RELATIVE_PREV, 0);
                } else {
                    lineTypes[lineNo] = OCPreprocessorFormatterData.OCIndentInfo.createCodeInfo(OCPreprocessorFormatterData.OffsetType.CODE_AS_IS, 0);
                }
                int endLineOffset = offset + length;
                if (endLineOffset > endOfMultiline) {
                    int lexerStartOffset = Math.max(offset, endOfMultiline);
                    OCLexerWithDirectives contentLexer = OCLexerWithDirectives.createDefault();
                    contentLexer.start(leafText.substring(lexerStartOffset));
                    while (true) {
                        IElementType tokenType = contentLexer.getTokenType();
                        int startTokenOffset = lexerStartOffset + contentLexer.getTokenStart();
                        if (tokenType != null && startTokenOffset < endLineOffset) {
                            if (OCFormatterUtil.FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED.contains(tokenType)) {
                                endOfMultiline = lexerStartOffset + contentLexer.getTokenEnd();
                                endOfCodeSkip = tokenType == OCTokenTypes.BLOCK_COMMENT && OCMultilineNodeFormatter.dropStringIndent(leafText.substring(offset, startTokenOffset)).isEmpty() ? -1 : endOfMultiline;
                            }
                            contentLexer.advance();
                            continue;
                        }
                        break;
                    }
                }
            } else {
                lineTypes[lineNo] = OCPreprocessorFormatterData.OCIndentInfo.createCodeInfo(OCPreprocessorFormatterData.OffsetType.DIRECTIVE_ABSOLUTE, this.indent(origLine));
            }
            if (lineNo == 0) {
                firstLineIsDirective = inDirective;
            }
            needContinuation = inDirective && origLine.endsWith("\\\n");
            offset += length;
        }
        String newCode = this.getShiftedLeafText(shift, code.toString());
        if (firstLineNeedIndentCorrection) {
            newCode = this.getStringIndent(shift) + newCode;
        }
        String[] newLines = StringUtil.splitByLinesKeepSeparators((String)newCode);
        int newLineNo = 0;
        int prevCodeIndent = codeIndent;
        StringBuilder newText = new StringBuilder(leafText.length());
        boolean isAnchor = false;
        block8: for (int lineNo = 0; lineNo < lines.length; ++lineNo) {
            String origLine = lines[lineNo];
            OCPreprocessorFormatterData.OCIndentInfo lineType = lineTypes[lineNo];
            if (lineType.baseIndentType == OCPreprocessorFormatterData.OffsetType.DIRECTIVE_POSTPONE) {
                boolean resetIndentInDirectiveSequence1 = lineType.resetIndentInDirectiveSequence();
                if (!isAnchor && lineType.isIndentStarter() && newLineNo > 0 && newLineNo < newLines.length) {
                    for (int nonEmptyLineNo = newLineNo; nonEmptyLineNo < newLines.length; ++nonEmptyLineNo) {
                        String line = newLines[nonEmptyLineNo];
                        if (OCMultilineNodeFormatter.isBadAnchorLine(line)) {
                            continue;
                        }
                        int anchorDirectiveIndent = this.indent(line);
                        resetIndentInDirectiveSequence1 |= anchorDirectiveIndent != prevCodeIndent;
                        prevCodeIndent = anchorDirectiveIndent;
                        break;
                    }
                    isAnchor = true;
                }
                lineType = preprocessorFormatterData.getIndents(resetIndentInDirectiveSequence1, lineType.tokenType, ocCodeStyleSettings, lineNo == 0 ? (Boolean)info.first : origLine.charAt(0) == '#');
            }
            switch (lineType.baseIndentType) {
                case DIRECTIVE_RELATIVE_CODE: {
                    newText.append(this.getStringIndent(prevCodeIndent + lineType.ifIndentSizeInSpaces)).append(OCMultilineNodeFormatter.dropStringIndent(origLine));
                    continue block8;
                }
                case DIRECTIVE_ABSOLUTE: {
                    newText.append(this.getStringIndent(lineType.ifIndentSizeInSpaces)).append(OCMultilineNodeFormatter.dropStringIndent(origLine));
                    continue block8;
                }
                case CODE_RELATIVE_PREV: {
                    if (newLineNo >= newLines.length) continue block8;
                    boolean changeCodeIndent = newLineNo != 0 || newLineNo == 0 && firstLineIsDirective;
                    String formattedLine = newLines[newLineNo++];
                    boolean whitespaceString = OCMultilineNodeFormatter.isWhitespaceString(formattedLine);
                    if (changeCodeIndent && !OCMultilineNodeFormatter.isBadAnchorLine(formattedLine)) {
                        prevCodeIndent = this.indent(formattedLine);
                        isAnchor = OCMultilineNodeFormatter.isGoodAnchorLine(formattedLine);
                    }
                    if (changeCodeIndent && whitespaceString && replaceEmptyLinesByCodeIndent) {
                        newText.append(this.getStringIndent(prevCodeIndent)).append("\n");
                        continue block8;
                    }
                    newText.append(formattedLine);
                    continue block8;
                }
                default: {
                    newText.append(origLine);
                }
            }
        }
        return newText.toString();
    }

    private static boolean isBadAnchorLine(@NonNls @NotNull String line) {
        return (line = line.trim()).isEmpty() || line.startsWith("case");
    }

    private static boolean isGoodAnchorLine(@NonNls @NotNull String line) {
        return (line = line.trim()).endsWith(";") || line.endsWith(",") || line.endsWith("}");
    }

    private static boolean isWhitespaceString(@NotNull String line) {
        return StringUtil.trim((String)line).isEmpty();
    }

    @Nullable
    public static String getIndentAtPosition(@NotNull HighlighterIterator it) {
        it.retreat();
        if (it.atEnd()) {
            return "";
        }
        if (it.getTokenType() == TokenType.WHITE_SPACE) {
            String whiteSpace = it.getDocument().getText().substring(it.getStart(), it.getEnd());
            if (it.getStart() == 0 || whiteSpace.indexOf(10) >= 0) {
                return (String)OCMultilineNodeFormatter.splitIndent((String)whiteSpace).second;
            }
        }
        return null;
    }

    @Nullable
    public static String getDirectiveIndentFromAnchor(@NotNull HighlighterIterator it, @NotNull PsiFile file2, boolean withIndentation) {
        int nestLevel = 0;
        while (!it.atEnd()) {
            if (OCFormatterUtil.FORMAT_DIRECTIVES_INCREASE_INDENT.contains(it.getTokenType())) {
                if (nestLevel == 0) break;
                if (OCTokenTypes.IF_DIRECTIVES.contains(it.getTokenType())) {
                    ++nestLevel;
                }
            } else if (OCTokenTypes.ENDIF_DIRECTIVE == it.getTokenType()) {
                --nestLevel;
            }
            it.retreat();
        }
        if (!it.atEnd()) {
            String directiveIndent;
            if (withIndentation) {
                OCDirective headerGuardIfndefDirective;
                OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findHeaderGuard(file2, true);
                OCDirective oCDirective = headerGuardIfndefDirective = headerGuardInfo != null ? headerGuardInfo.getBeginIfndefDirective() : null;
                if (headerGuardIfndefDirective != null && headerGuardIfndefDirective.getTextOffset() == it.getStart()) {
                    return null;
                }
            }
            if ((directiveIndent = OCMultilineNodeFormatter.getIndentAtPosition(it)) != null) {
                OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file2);
                return multilineNodeFormatter.getStringIndent(multilineNodeFormatter.indent(directiveIndent) + (withIndentation ? multilineNodeFormatter.getOCSettings().INDENT_PREPROCESSOR_DIRECTIVE : 0));
            }
        }
        return null;
    }

    public int indent(@NotNull String line) {
        return this.normalizedTabLength(OCMultilineNodeFormatter.getStringIndent(line));
    }

    private int normalizedTabLength(@NotNull String text) {
        return text.replaceAll("\t", StringUtil.repeatSymbol((char)' ', (int)this.getTabSize())).length();
    }

    private int getTabSize() {
        CommonCodeStyleSettings.IndentOptions options2 = this.mySettings.getCommonSettings(OCLanguageUtils.getConfigLanguage()).getIndentOptions();
        return options2 == null ? 4 : options2.TAB_SIZE;
    }

    @NotNull
    public String getStringIndent(int indent) {
        String indentStr = StringUtil.repeatSymbol((char)' ', (int)indent);
        CommonCodeStyleSettings.IndentOptions options2 = this.mySettings.getCommonSettings(OCLanguageUtils.getConfigLanguage()).getIndentOptions();
        return options2 == null || !options2.USE_TAB_CHARACTER ? indentStr : indentStr.replaceAll(StringUtil.repeatSymbol((char)' ', (int)this.getTabSize()), "\t");
    }

    @NotNull
    public static String getStringIndent(@NotNull String line) {
        char ch;
        int length = line.length();
        StringBuilder originalIndent = new StringBuilder();
        for (int startOffset = 0; startOffset < length && OCMultilineNodeFormatter.isSpaceChar(ch = line.charAt(startOffset)); ++startOffset) {
            originalIndent.append(ch);
        }
        return originalIndent.toString();
    }

    @NotNull
    private static String dropStringIndent(@NotNull String string) {
        int index;
        for (index = 0; index < string.length() && OCMultilineNodeFormatter.isSpaceChar(string.charAt(index)); ++index) {
        }
        return string.substring(index);
    }

    private static boolean isSpaceChar(char ch) {
        return "\t ".indexOf(ch) >= 0;
    }

    @NotNull
    public static Pair<String, String> splitIndent(@NotNull String whiteSpace) {
        int lineStart = whiteSpace.lastIndexOf(10);
        if (lineStart >= 0) {
            return Pair.create((Object)whiteSpace.substring(0, lineStart + 1), (Object)whiteSpace.substring(lineStart + 1));
        }
        return Pair.create((Object)"", (Object)whiteSpace);
    }

    public static boolean isMultiline(@NotNull ASTNode node2) {
        return node2.getText().trim().indexOf(10) >= 0;
    }

    private static interface DocumentModifier {
        public TextRange change(boolean var1, String var2, String var3);
    }
}

