/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.formatting.OCPsiBasedFormattingModel;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormattingModelBuilder
implements FormattingModelBuilderEx {
    private static final ThreadLocal<AtomicInteger> myAlwaysCreateFullModel = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        return this.createModel(element, settings, FormattingMode.REFORMAT);
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        boolean alwaysCreateFullModel;
        PsiFile psiFile = element.getContainingFile();
        boolean bl = alwaysCreateFullModel = OCFormattingModelBuilder.isAlwaysCreateFullModel() || OCParser.isSimplifiedParsingMode(psiFile) != false;
        if (!alwaysCreateFullModel && DumbService.getInstance((Project)element.getProject()).isDumb() || mode == FormattingMode.REFORMAT && ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile)) {
            return OCFormattingModelBuilder.createDumbModel(element);
        }
        PsiFile file2 = OCLanguageUtils.tryGetOCFile(psiFile);
        return new OCPsiBasedFormattingModel(file2, settings, mode);
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        return null;
    }

    public TextRange getRangeAffectingIndent(PsiFile file2, int offset, ASTNode elementAtOffset) {
        PsiFile ocFile = OCLanguageUtils.tryGetOCFile(file2);
        OCElement parent = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)ocFile.findElementAt(offset), (Class[])new Class[]{OCMethod.class, OCExpression.class});
        return parent != null ? parent.getTextRange() : null;
    }

    public static void requestAlwaysCreateFullModel() {
        myAlwaysCreateFullModel.get().incrementAndGet();
    }

    public static void releaseAlwaysCreateFullModel() {
        myAlwaysCreateFullModel.get().decrementAndGet();
    }

    private static boolean isAlwaysCreateFullModel() {
        return myAlwaysCreateFullModel.get().get() > 0;
    }

    @NotNull
    private static FormattingModel createDumbModel(@NotNull PsiElement element) {
        final AbstractBlock block = new AbstractBlock(element.getNode(), null, null){

            @Contract(pure=true)
            protected List<Block> buildChildren() {
                return EMPTY;
            }

            @Contract(pure=true)
            @Nullable
            public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
                return null;
            }

            @Contract(pure=true)
            public boolean isLeaf() {
                return false;
            }
        };
        final Document document2 = FormattingDocumentModelImpl.createOn((PsiFile)element.getContainingFile()).getDocument();
        final FormattingDocumentModel model = new FormattingDocumentModel(){

            @Contract(pure=true)
            public int getLineNumber(int offset) {
                return document2.getLineNumber(offset);
            }

            @Contract(pure=true)
            public int getLineStartOffset(int line) {
                return document2.getLineStartOffset(line);
            }

            @NotNull
            @Contract(pure=true)
            public CharSequence getText(TextRange textRange) {
                return document2.getText(textRange);
            }

            @Contract(pure=true)
            public int getTextLength() {
                return document2.getTextLength();
            }

            @Contract(pure=true)
            @NotNull
            public Document getDocument() {
                return document2;
            }

            @Contract(pure=true)
            public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
                return false;
            }

            @Contract(pure=true)
            @NotNull
            public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
                return whiteSpaceText;
            }
        };
        return new FormattingModel(){

            @NotNull
            public Block getRootBlock() {
                return block;
            }

            @NotNull
            public FormattingDocumentModel getDocumentModel() {
                return model;
            }

            public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
                return textRange;
            }

            public TextRange shiftIndentInsideRange(ASTNode node2, TextRange range, int indent) {
                return range;
            }

            public void commitChanges() {
            }
        };
    }
}

