/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoFormatTypedHandler
extends TypedActionHandlerBase {
    private final Handler[] HANDLERS = new Handler[]{new MethodColonHandler(), new AdjustLabelCaseDefaultPublicHandler(), new AdjustLineWithAtHandler()};

    public OCAutoFormatTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        Project project2;
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        OCPsiFile file2 = OCLanguageUtils.asOCPsiFile(PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2));
        if (file2 == null) {
            return;
        }
        if (charTyped == '\"') {
            if (OCLineIndentProvider.getLineStarterBeforeFirstStringOnLine(OCAutoFormatTypedHandler.getSemanticEditorPosition(editor)) != null) {
                OCAutoFormatTypedHandler.adjustLineIndentUnderCaretNoCommit(OCLanguageUtils.getConfigLanguage(), editor);
            }
            return;
        }
        if (charTyped != ':' && charTyped != '@') {
            return;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Editor)editor);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project2.isDisposed() || editor.isDisposed()) {
                return;
            }
            for (Handler each : this.HANDLERS) {
                if (each.handle(charTyped, file2, editor, settings)) break;
            }
        });
    }

    @NotNull
    public static SemanticEditorPosition getSemanticEditorPosition(@NotNull Editor editor) {
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)OCLanguageUtils.getConfigLanguage());
        if (lineIndentProvider instanceof OCLineIndentProvider) {
            return ((OCLineIndentProvider)lineIndentProvider).getPosition(editor, editor.getCaretModel().getCurrentCaret().getOffset() - 1);
        }
        assert (false);
        return null;
    }

    private static boolean adjustLineIndentUnderCaretNoCommit(@NotNull Language language, @NotNull Editor editor) {
        Caret caret = editor.getCaretModel().getCurrentCaret();
        int offsetAfterIndentCorrection = EnterHandler.adjustLineIndentNoCommit((Language)language, (Document)editor.getDocument(), (Editor)editor, (int)caret.getOffset());
        if (offsetAfterIndentCorrection >= 0) {
            caret.moveToOffset(offsetAfterIndentCorrection);
            return true;
        }
        return false;
    }

    public static class AdjustLineWithAtHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, @NotNull OCPsiFile file2, @NotNull Editor editor, @NotNull CodeStyleSettings settings) {
            if (charTyped != '@') {
                return false;
            }
            if (((Boolean)OCLineIndentProvider.getNeedSpecialIndentAndInsideIVAR((SemanticEditorPosition)OCAutoFormatTypedHandler.getSemanticEditorPosition((Editor)editor)).first).booleanValue()) {
                return OCAutoFormatTypedHandler.adjustLineIndentUnderCaretNoCommit(OCLanguageUtils.getConfigLanguage(), editor);
            }
            return false;
        }
    }

    public static class AdjustLabelCaseDefaultPublicHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, @NotNull OCPsiFile file2, @NotNull Editor editor, @NotNull CodeStyleSettings settings) {
            if (charTyped != ':') {
                return false;
            }
            SemanticEditorPosition position = OCAutoFormatTypedHandler.getSemanticEditorPosition(editor);
            Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context2 = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(position);
            SemanticEditorPosition.SyntaxElement element = context2.first == null ? null : ((SemanticEditorPosition)context2.first).getCurrElement();
            return (element == OCLineIndentProvider.OCSElement.Identifier && !file2.getKind().isCpp() || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault || element == OCLineIndentProvider.OCSElement.PublicLike) && OCAutoFormatTypedHandler.adjustLineIndentUnderCaretNoCommit(OCLanguageUtils.getConfigLanguage(), editor);
        }
    }

    public static class MethodColonHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, @NotNull OCPsiFile file2, @NotNull Editor editor, @NotNull CodeStyleSettings settings) {
            if (charTyped != ':' || !file2.getKind().isObjC()) {
                return false;
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            documentManager.commitDocument(editor.getDocument());
            PsiElement offsetElement = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (offsetElement == null || OCElementUtil.getElementType(offsetElement) != OCTokenTypes.COLON) {
                return false;
            }
            OCCodeStyleSettings customSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
            Pair<PsiElement, PsiElement> firstAndCurrent = MethodColonHandler.findFirstAndCurrentSelectors(offsetElement, customSettings);
            if (firstAndCurrent != null) {
                PsiElement firstSelector = (PsiElement)firstAndCurrent.first;
                PsiElement currSelector = (PsiElement)firstAndCurrent.second;
                ASTNode prevNode = FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)currSelector.getNode());
                if (prevNode == null) {
                    return false;
                }
                Document document2 = editor.getDocument();
                int firstSelectorLine = document2.getLineNumber(firstSelector.getTextOffset());
                int currSelectorLine = document2.getLineNumber(currSelector.getTextOffset());
                int prevNodeLine = document2.getLineNumber(prevNode.getTextRange().getEndOffset());
                if (prevNodeLine == currSelectorLine) {
                    return false;
                }
                int firstSelectorLineOffset = document2.getLineStartOffset(firstSelectorLine);
                int currSelectorLineOffset = document2.getLineStartOffset(currSelectorLine);
                int alignByOffset = firstSelector.getTextRange().getEndOffset() - firstSelectorLineOffset;
                int newLineOffset = Math.max(0, alignByOffset - currSelector.getTextLength());
                String spaces = new IndentInfo(0, newLineOffset, 0).generateNewWhiteSpace(settings.getIndentOptions(file2.getFileType()));
                document2.replaceString(currSelectorLineOffset, currSelector.getTextOffset(), (CharSequence)spaces);
                return true;
            }
            PsiElement currentArgument = offsetElement.getParent();
            if (currentArgument instanceof OCArgumentSelector && customSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE || currentArgument instanceof OCMethodSelectorPart && customSettings.METHOD_PARAMETERS_ALIGN_MULTILINE) {
                CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent((PsiFile)file2, offsetElement.getTextOffset());
                return true;
            }
            return currentArgument instanceof OCArgumentSelector || currentArgument instanceof OCMethodSelectorPart;
        }

        @Nullable
        private static Pair<PsiElement, PsiElement> findFirstAndCurrentSelectors(@NotNull PsiElement offsetElement, @NotNull OCCodeStyleSettings settings) {
            PsiElement currentArgument = offsetElement.getParent();
            PsiElement firstArgument = null;
            if (currentArgument instanceof OCArgumentSelector && settings.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS) {
                PsiElement prev = currentArgument.getParent();
                do {
                    if (!((prev = prev.getPrevSibling()) instanceof OCMessageArgument)) continue;
                    firstArgument = PsiTreeUtil.findChildOfType((PsiElement)prev, OCArgumentSelector.class);
                } while (prev != null);
            } else if (currentArgument instanceof OCMethodSelectorPart && settings.METHOD_PARAMETERS_ALIGN_BY_COLONS) {
                PsiElement prev = currentArgument;
                do {
                    if (!((prev = prev.getPrevSibling()) instanceof OCMethodSelectorPart)) continue;
                    firstArgument = prev;
                } while (prev != null);
                firstArgument = MethodColonHandler.getIdentifierFromParameter(firstArgument);
                currentArgument = MethodColonHandler.getIdentifierFromParameter(currentArgument);
            }
            return firstArgument == null || currentArgument == null ? null : Pair.create(firstArgument, (Object)currentArgument);
        }

        @Contract(value="null -> null")
        @Nullable
        private static PsiElement getIdentifierFromParameter(@Nullable PsiElement param) {
            if (param == null) {
                return null;
            }
            ASTNode identifier = param.getNode().findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
            if (identifier == null || OCElementUtil.getElementType(identifier.getTreeNext()) != OCTokenTypes.COLON) {
                return null;
            }
            return identifier.getPsi();
        }
    }

    private static interface Handler {
        public boolean handle(char var1, @NotNull OCPsiFile var2, @NotNull Editor var3, @NotNull CodeStyleSettings var4);
    }
}

