/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.typing;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardBlockDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardOrDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardRepeatDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardSequenceDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardTokenDetector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class OCBackwardStructureDetector {
    public boolean tryNext(@NotNull TokenIterator tokenIterator) {
        if (tokenIterator.atEnd()) {
            return false;
        }
        TokenIterator.Marker mark = tokenIterator.mark();
        if (!this.next(tokenIterator)) {
            mark.rollback();
            return false;
        }
        return true;
    }

    public abstract boolean next(@NotNull TokenIterator var1);

    public static OCBackwardStructureDetector token(IElementType ... types) {
        return new OCBackwardTokenDetector(true, TokenSet.create((IElementType[])types));
    }

    public static OCBackwardStructureDetector tokenExcept(IElementType ... types) {
        return new OCBackwardTokenDetector(false, TokenSet.create((IElementType[])types));
    }

    public static OCBackwardStructureDetector block(@NotNull IElementType leftBorder, @NotNull IElementType rightBorder) {
        return new OCBackwardBlockDetector(leftBorder, rightBorder);
    }

    public static OCBackwardStructureDetector sequence(OCBackwardStructureDetector ... sequence) {
        return new OCBackwardSequenceDetector(Arrays.asList(sequence));
    }

    public static OCBackwardStructureDetector or(OCBackwardStructureDetector ... variants) {
        return new OCBackwardOrDetector(Arrays.asList(variants));
    }

    public static OCBackwardStructureDetector repeat(@NotNull Cardinality cardinality, @NotNull OCBackwardStructureDetector detector) {
        return new OCBackwardRepeatDetector(cardinality, detector);
    }

    public static interface TokenIterator {
        public Marker mark();

        public IElementType getTokenType();

        public boolean atEnd();

        public void retreat();

        public void skipWhitespaces();

        public static interface Marker {
            public void rollback();
        }
    }

    public static enum Cardinality {
        ONE_OR_MORE,
        ZERO_OR_MORE,
        MAYBE_ONE;

    }
}

