/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;

public class OCTryCatchSurrounder
extends OCStatementSurrounder<OCTryStatement> {
    @Override
    protected String getStatementTemplate(Project project2, PsiElement context2) {
        String paramName = OCNameSuggester.suggestUniqueName(OCSymbolKind.CATCH_EXCEPTION_VARIABLE, "exception", context2, project2);
        return "@try {\n}\n@catch (NSException *" + paramName + ") {\nNSLog(@\"Exception occurred: %@, %@\", " + paramName + ", [" + paramName + " userInfo]);}";
    }

    @Override
    protected PsiElement getInsertionPlace(OCTryStatement statement2) {
        return statement2.getBody();
    }

    @Override
    protected TextRange getSelectionRange(OCTryStatement statement2) {
        OCCatchSection catchSection = statement2.getCatchSections().get(0);
        OCStatement stmt = catchSection.getBody().getStatements().get(0);
        return stmt.getTextRange();
    }

    public String getTemplateDescription() {
        return "@try / @catch";
    }

    @Override
    protected OCLanguageKind getLanguageKind() {
        return CLanguageKind.OBJ_C;
    }
}

