/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ForStatementFixer
extends OCFixer {
    public static final OCElementType IN_PSEUDOTYPE = new OCElementType("in");

    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCForStatement || psiElement instanceof OCForeachStatement) {
            if (ForStatementFixer.hasMacroBasedStatement(psiElement, OCTokenTypes.FOR_KEYWORD)) {
                return;
            }
            Document doc = editor.getDocument();
            OCLoopStatement forStatement = (OCLoopStatement)psiElement;
            ASTNode rParenth = forStatement.getRParenth();
            ASTNode lParenth = forStatement.getLParenth();
            if (lParenth == null) {
                int stopOffset = doc.getLineEndOffset(doc.getLineNumber(OCChangeUtil.getRangeWithMacros(forStatement).getStartOffset()));
                OCStatement block = forStatement.getBody();
                if (block != null) {
                    stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(block).getStartOffset());
                }
                stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(forStatement).getEndOffset());
                doc.replaceString(OCChangeUtil.getRangeWithMacros(forStatement).getStartOffset(), stopOffset, (CharSequence)"for ()");
                processor2.registerUnresolvedError(OCChangeUtil.getRangeWithMacros(forStatement).getStartOffset() + "for (".length());
                return;
            }
            int lastErrorOffset = -1;
            int insertOffset = ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset();
            if (psiElement instanceof OCForStatement) {
                OCStatement init = ((OCForStatement)forStatement).getInitializer();
                if (ForStatementFixer.fixSemicolonAtTheEnd(editor, init)) {
                    return;
                }
                OCCondition condition = ((OCForStatement)forStatement).getCondition();
                if (ForStatementFixer.fixSemicolonAtTheEnd(editor, condition)) {
                    return;
                }
                OCStatement update = ((OCForStatement)forStatement).getIncrement();
                ASTNode forNode = psiElement.getNode();
                ASTNode lastSemi = TreeUtil.findChildBackward((ASTNode)forNode, (IElementType)OCTokenTypes.SEMICOLON);
                if (lastSemi == null) {
                    lastErrorOffset = ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset();
                } else {
                    insertOffset = ForStatementFixer.hasEmptyStatement(update) ? ForStatementFixer.getRangeWithMacros(lastSemi).getEndOffset() : OCChangeUtil.getRangeWithMacros(update).getEndOffset();
                    ASTNode firstSemi = forNode.findChildByType((IElementType)OCTokenTypes.SEMICOLON);
                    assert (firstSemi != null);
                    if (processor2.isFirstFixAttempt() && firstSemi != lastSemi) {
                        int offset = editor.getCaretModel().getOffset();
                        if (offset > insertOffset) {
                            offset = ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset();
                        }
                        lastErrorOffset = offset < ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset() && ForStatementFixer.hasEmptyStatement(init) ? ForStatementFixer.getRangeWithMacros(firstSemi).getStartOffset() : (offset <= ForStatementFixer.getRangeWithMacros(firstSemi).getStartOffset() && ForStatementFixer.hasEmptyStatement(condition) ? ForStatementFixer.getRangeWithMacros(lastSemi).getStartOffset() : (offset <= ForStatementFixer.getRangeWithMacros(lastSemi).getStartOffset() && ForStatementFixer.hasEmptyStatement(update) ? insertOffset : -1));
                    } else if (rParenth != null) {
                        if (ForStatementFixer.hasEmptyStatement(init) && lastSemi != firstSemi) {
                            lastErrorOffset = ForStatementFixer.getRangeWithMacros(firstSemi).getStartOffset();
                        } else if (ForStatementFixer.hasEmptyStatement(condition)) {
                            lastErrorOffset = lastSemi == firstSemi ? ForStatementFixer.getRangeWithMacros(firstSemi).getEndOffset() : ForStatementFixer.getRangeWithMacros(lastSemi).getStartOffset();
                        } else if (ForStatementFixer.hasEmptyStatement(update)) {
                            lastErrorOffset = ForStatementFixer.getRangeWithMacros(rParenth).getStartOffset();
                        }
                    }
                }
            } else {
                OCElement declaration = ((OCForeachStatement)forStatement).getVariableDeclaration();
                if (declaration == null) {
                    declaration = ((OCForeachStatement)forStatement).getVariableExpression();
                }
                if (!ForStatementFixer.hasEmptyStatement(declaration)) {
                    insertOffset = lastErrorOffset = ForStatementFixer.moveAfter(declaration, ((OCForeachStatement)forStatement).isCpp11Foreach() ? OCTokenTypes.COLON : IN_PSEUDOTYPE);
                    OCExpression expression = ((OCForeachStatement)forStatement).getCollectionExpression();
                    if (!ForStatementFixer.hasEmptyStatement(expression)) {
                        insertOffset = OCChangeUtil.getRangeWithMacros(expression).getEndOffset();
                        lastErrorOffset = -1;
                    }
                }
            }
            if (rParenth == null) {
                doc.insertString(Math.min(insertOffset, doc.getTextLength()), (CharSequence)")");
            }
            if (lastErrorOffset != -1) {
                processor2.registerUnresolvedError(lastErrorOffset);
            }
        }
    }

    @Contract(pure=true)
    private static int moveAfter(@NotNull OCElement declaration, @NotNull IElementType type) {
        ASTNode sibling = ForStatementFixer.getNextEssentialLeaf(declaration.getNode());
        if (sibling != null && (type == sibling.getElementType() || type == IN_PSEUDOTYPE && "in".equals(sibling.getText()))) {
            return ForStatementFixer.getRangeWithMacros(sibling).getEndOffset();
        }
        return OCChangeUtil.getRangeWithMacros(declaration).getEndOffset();
    }
}

