/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuggestIndexNameMacro
extends Macro {
    public String getName() {
        return "suggestIndexName";
    }

    public String getPresentableName() {
        return "suggestIndexName()";
    }

    @NotNull
    public String getDefaultValue() {
        return "i";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context2) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context2);
        PsiFile file2 = place.getContainingFile();
        assert (file2 != null);
        Collection<String> candidates = OCNamingConventionUtil.applyNamingConvention(ContainerUtil.newArrayList((Object[])new String[]{"i", "j", "k", "l", "m", "n"}), OCSymbolKind.LOCAL_VARIABLE, context2.getProject());
        int attempt = 0;
        while (true) {
            for (String candidate : candidates) {
                if (attempt > 0) {
                    candidate = candidate + attempt;
                }
                if (!OCSuggestIndexNameMacro.isNameAvailable(candidate, file2, place)) continue;
                return new TextResult(candidate);
            }
            ++attempt;
        }
    }

    private static boolean isNameAvailable(@NotNull String candidate, @NotNull PsiFile file2, @Nullable PsiElement context2) {
        Project project2 = file2.getProject();
        OCSymbol symbol = OCCodeInsightUtil.resolveNameInScope(OCSymbolKind.LOCAL_VARIABLE, candidate, null, context2, project2);
        if (symbol == null) {
            return true;
        }
        if (context2 == null) {
            return false;
        }
        PsiElement parent = context2.getParent();
        return parent instanceof OCDeclarator && parent.equals(symbol.locateDefinition(project2));
    }

    public boolean isAcceptableInContext(TemplateContextType context2) {
        return context2 instanceof OCCodeContextType;
    }
}

