/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.Topics;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.BracePair;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCBraceMatcher;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardRepeatDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardStructureDetector;
import com.jetbrains.cidr.lang.editor.typing.OCHighlightingTokenIterator;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypedHandlerDelegate
extends TypedHandlerDelegate {
    private static int DO_STAR_OVERTYPE = 0;
    private static int DO_COLON_OVERTYPE = 0;
    private static int DO_RIGHT_ANGLE_BRACKET_OVERTYPE = 0;
    private static int DO_QUOTE_OVERTYPE = 0;
    private boolean myMemoSetting;
    private boolean myBalanceOnRightBracket;
    public static final TokenSet STOPSET = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACE, OCTokenTypes.RBRACE, OCTokenTypes.SEMICOLON});
    private static final TokenSet OUT_OF_PAREN_STOPSET = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.EQ, OCTokenTypes.EQEQ, OCTokenTypes.ANDAND, OCTokenTypes.OROR, OCTokenTypes.LT, OCTokenTypes.LTEQ, OCTokenTypes.GT, OCTokenTypes.GTEQ, OCTokenTypes.PLUS, OCTokenTypes.MINUS, OCTokenTypes.DIV, OCTokenTypes.MUL});
    private static final IElementType[] BLOCK_TYPE_STOP_SET;
    protected static final OCBackwardStructureDetector NUMBER_LITERAL_DETECTOR;
    protected static final OCBackwardStructureDetector STRING_LITERAL_DETECTOR;
    public static final OCBackwardStructureDetector ARRAY_LITERAL_DETECTOR;
    public static final OCBackwardStructureDetector BRACED_LITERAL_DETECTOR;
    public static final OCBackwardStructureDetector OBJC_LITERAL_DETECTOR;
    private static final TokenSet NON_SEMICOLON_BLOCK_OWNERS;

    public OCTypedHandlerDelegate() {
        Topics.subscribe((Topic)AnActionListener.TOPIC, null, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                DO_STAR_OVERTYPE = 0;
                DO_COLON_OVERTYPE = 0;
                DO_RIGHT_ANGLE_BRACKET_OVERTYPE = 0;
                DO_QUOTE_OVERTYPE = 0;
            }
        });
    }

    public static void overTypeNextStar(int starCount) {
        DO_STAR_OVERTYPE = starCount;
    }

    public static void overTypeNextColon(int colonCount) {
        DO_COLON_OVERTYPE = colonCount;
    }

    public static void overTypeNextRightAngleBracket() {
        DO_RIGHT_ANGLE_BRACKET_OVERTYPE = 1;
    }

    public static void overTypeNextQuote() {
        DO_QUOTE_OVERTYPE = 1;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (!OCLanguageUtils.isSupported(fileType)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '\"') {
            int offset = editor.getCaretModel().getOffset();
            ApplicationManager.getApplication().invokeLater(() -> {
                PsiDocumentManagerImpl pdm = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
                pdm.performWhenAllCommitted(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    OCType expected;
                    Document document2 = editor.getDocument();
                    PsiFile psi = pdm.getPsiFile(document2);
                    OCFile ocFile = OCLanguageUtils.asOCFile(psi);
                    if (ocFile == null || !ocFile.getKind().isObjC()) {
                        return;
                    }
                    OCLiteralExpression literal = (OCLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)ocFile, (int)offset, OCLiteralExpression.class, (boolean)false);
                    if (literal != null && literal.isStringLiteral() && !literal.isNSStringLiteral() && (expected = OCExpectedTypeUtil.getExpectedType((OCExpression)literal, OCResolveContext.forPsi(literal))) != null && (expected.isObjCRootType() || expected.isPointerToStringCompatible(true))) {
                        WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{ocFile}).run(() -> document2.insertString(literal.getTextRange().getStartOffset(), (CharSequence)"@"));
                    }
                }, project2.getDisposed()));
            }, project2.getDisposed());
        } else if (c == ']') {
            boolean autoInsertPairBracket;
            this.myMemoSetting = autoInsertPairBracket = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET;
            int offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (!OCTypedHandlerDelegate.isBracketBalancingSupported(file2) || autoInsertPairBracket && OCTypedHandlerDelegate.isNext(editor, offset, OCTokenTypes.RBRACKET)) {
                this.myBalanceOnRightBracket = false;
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            this.myBalanceOnRightBracket = true;
            HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            int tokenPassed = 0;
            boolean prevWasWhitespace = false;
            while (!it.atEnd()) {
                IElementType tt = it.getTokenType();
                if (tt == OCTokenTypes.LBRACKET) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                boolean isWs = OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt);
                if (!isWs && prevWasWhitespace && tokenPassed >= 2) break;
                it.retreat();
                ++tokenPassed;
                prevWasWhitespace = isWs;
            }
            CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET = false;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean isBracketBalancingSupported(@NotNull PsiFile file2) {
        if (!OCLanguageUtils.isSupported(file2)) {
            return false;
        }
        OCLanguageKind languageKind = DumbService.getInstance((Project)file2.getProject()).isDumb() ? OCLanguageKindCalculator.calculateLanguageKindFast(file2) : ((OCPsiFile)file2).getKind();
        return languageKind.isObjC();
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        String originalIndent;
        HighlighterIterator it;
        if (!OCLanguageUtils.isSupported(file2)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document2 = editor.getDocument();
        CaretModel caret = editor.getCaretModel();
        if (c == '*' && DO_STAR_OVERTYPE > 0) {
            --DO_STAR_OVERTYPE;
            int offset = caret.getOffset() - 1;
            CharSequence text = document2.getCharsSequence();
            if (text.charAt(offset - 1) == '*') {
                document2.deleteString(offset, offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c == ':' && DO_COLON_OVERTYPE > 0) {
            int offset = caret.getOffset() - 1;
            CharSequence text = document2.getCharsSequence();
            if (text.charAt(offset - 1) == ':' && text.charAt(offset - 2) == ':') {
                document2.deleteString(offset, offset + 1);
                --DO_COLON_OVERTYPE;
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c == '\"' && DO_QUOTE_OVERTYPE > 0) {
            --DO_QUOTE_OVERTYPE;
            int offset = caret.getOffset();
            CharSequence text = document2.getCharsSequence();
            if (text.charAt(offset) == '\"') {
                document2.deleteString(offset, offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c == '>' && DO_RIGHT_ANGLE_BRACKET_OVERTYPE > 0) {
            --DO_RIGHT_ANGLE_BRACKET_OVERTYPE;
            int offset = caret.getOffset();
            CharSequence text = document2.getCharsSequence();
            if (text.charAt(offset) == '>') {
                document2.deleteString(offset, offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c == ';') {
            int offset = caret.getOffset();
            if (OCTypedHandlerDelegate.isNext(editor, offset, OCTokenTypes.SEMICOLON)) {
                document2.deleteString(offset, offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c == ']' && this.myBalanceOnRightBracket) {
            CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET = this.myMemoSetting;
            int offset = caret.getOffset() - 1;
            HighlighterIterator fromStart = ((EditorEx)editor).getHighlighter().createIterator(0);
            int depth = 0;
            int depthBeforeOffset = 0;
            while (!fromStart.atEnd()) {
                IElementType tt;
                int curOffset = fromStart.getStart();
                if (curOffset == offset) {
                    depthBeforeOffset = depth;
                }
                if ((tt = fromStart.getTokenType()) == OCTokenTypes.LBRACKET) {
                    ++depth;
                }
                if (tt == OCTokenTypes.RBRACKET) {
                    --depth;
                }
                fromStart.advance();
            }
            if (depth >= 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator it2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
            int parBalance = 0;
            int bracketBalance = 0;
            int termsCount = 0;
            if (it2.getTokenType() == OCTokenTypes.RBRACKET) {
                while (true) {
                    if (it2.atEnd()) {
                        return TypedHandlerDelegate.Result.CONTINUE;
                    }
                    IElementType tt = it2.getTokenType();
                    if (OCTypedHandlerDelegate.skipObjcLiteral(it2)) {
                        if (parBalance != 0 || bracketBalance != true) continue;
                        ++termsCount;
                        continue;
                    }
                    if (tt == OCTokenTypes.LPAR) {
                        if (parBalance == 0) break;
                        --parBalance;
                    } else if (tt == OCTokenTypes.RPAR) {
                        ++parBalance;
                    } else if (tt == OCTokenTypes.LBRACKET) {
                        if (parBalance == 0 && --bracketBalance == 1 && OCTypedHandlerDelegate.checkPosition(editor, it2.getStart(), offset)) {
                            break;
                        }
                    } else if (tt == OCTokenTypes.RBRACKET) {
                        if (parBalance == 0 && bracketBalance == 1) {
                            ++termsCount;
                        }
                        ++bracketBalance;
                    } else if (tt == OCTokenTypes.DOT || tt == OCTokenTypes.DEREF) {
                        if (parBalance == 0 && bracketBalance == 1) {
                            --termsCount;
                        }
                    } else {
                        if (tt == OCTokenTypes.IF_KEYWORD || tt == OCTokenTypes.WHILE_KEYWORD || tt == OCTokenTypes.FOR_KEYWORD) {
                            it2.advance();
                            OCTypedHandlerDelegate.skipWhitespaceForward(it2);
                            parBalance = OCTypedHandlerDelegate.skipBlock(it2, OCTokenTypes.LPAR, OCTokenTypes.RPAR);
                            break;
                        }
                        if (tt == OCTokenTypes.IDENTIFIER && !"in".equals(OCTypedHandlerDelegate.tokenText(editor, it2)) || OCTokenTypes.LITERALS.contains(tt) || tt == OCTokenTypes.AT || tt == OCTokenTypes.SELECTOR_KEYWORD || tt == OCTokenTypes.ENCODE_KEYWORD || tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_CPP_KEYWORD || tt == OCTokenTypes.AND || tt == OCTokenTypes.TEMPLATE_START_MARK || tt == OCTokenTypes.TEMPLATE_STOP_MARK || tt == OCTokenTypes.SIZEOF_KEYWORD) {
                            if (parBalance == 0 && bracketBalance == 1) {
                                ++termsCount;
                            }
                        } else if ((tt != OCTokenTypes.COLON || bracketBalance != 1 || parBalance != 0 || depthBeforeOffset != 0) && tt != TokenType.WHITE_SPACE && (STOPSET.contains(tt) || parBalance == 0 && bracketBalance == 1 || parBalance == 0 && bracketBalance == 0 && OUT_OF_PAREN_STOPSET.contains(tt))) break;
                    }
                    it2.retreat();
                }
                if (parBalance == 0 && bracketBalance <= 1) {
                    it2.advance();
                    while (!OCTypedHandlerDelegate.checkPosition(editor, it2.getStart(), offset)) {
                        it2.advance();
                    }
                    OCTypedHandlerDelegate.skipWhitespaceForward(it2);
                    char prevChar = document2.getCharsSequence().charAt(offset - 1);
                    if (termsCount == 1 || prevChar == ':') {
                        if (prevChar != ' ') {
                            document2.insertString(offset, (CharSequence)" ");
                        }
                        caret.moveCaretRelatively(-1, 0, false, false, false);
                    } else if (offset < document2.getCharsSequence().length() - 1) {
                        char nextChar = document2.getCharsSequence().charAt(offset + 1);
                        if (termsCount > 0 && nextChar == ']') {
                            document2.insertString(offset + 1, (CharSequence)" ");
                            caret.moveCaretRelatively(1, 0, false, false, false);
                        }
                    }
                    document2.insertString(it2.getStart(), (CharSequence)"[");
                    PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document2);
                    OCChangeUtil.reformatTextIfNotInjected(file2, it2.getStart(), it2.getStart() + 2);
                }
            }
        } else if (c == '{' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            HighlighterIterator it3 = ((EditorEx)editor).getHighlighter().createIterator(caret.getOffset() - 1);
            it3.retreat();
            if (OCTypedHandlerDelegate.needSemicolonAtContextEnd(it3)) {
                it3 = ((EditorEx)editor).getHighlighter().createIterator(caret.getOffset());
                OCTypedHandlerDelegate.eatWhitespaces(it3);
                if (!it3.atEnd() && it3.getTokenType() == OCTokenTypes.RBRACE) {
                    int offset = it3.getEnd();
                    it3.advance();
                    OCTypedHandlerDelegate.eatWhitespaces(it3);
                    if (it3.atEnd() || it3.getTokenType() != OCTokenTypes.SEMICOLON) {
                        document2.insertString(offset, (CharSequence)";");
                    }
                }
            }
        } else if (c == '#' && !OCFormatterUtil.FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED.contains((it = ((EditorEx)editor).getHighlighter().createIterator(caret.getOffset() - 1)).getTokenType()) && (originalIndent = OCMultilineNodeFormatter.getIndentAtPosition(it)) != null) {
            int spaceEnd = it.atEnd() ? 0 : it.getEnd();
            String newIndent = OCMultilineNodeFormatter.getDirectiveIndentFromAnchor(it, file2, true);
            if (newIndent == null) {
                PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document2);
                OCChangeUtil.reformatTextIfNotInjected(file2, spaceEnd - originalIndent.length() + 1, caret.getOffset());
            } else if (!newIndent.equals(originalIndent)) {
                document2.replaceString(spaceEnd - originalIndent.length(), spaceEnd, (CharSequence)newIndent);
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void eatWhitespaces(@NotNull HighlighterIterator it) {
        while (!it.atEnd() && it.getTokenType() == TokenType.WHITE_SPACE) {
            it.advance();
        }
    }

    private static boolean skipObjcLiteral(@NotNull HighlighterIterator it) {
        OCHighlightingTokenIterator iterator2 = new OCHighlightingTokenIterator(it);
        return OBJC_LITERAL_DETECTOR.tryNext(iterator2);
    }

    public static boolean needSemicolonAtContextEnd(@NotNull HighlighterIterator it) {
        return OCTypedHandlerDelegate.needSemicolonAtContextEnd(OCTypedHandlerDelegate.getContextTypeFromPosition(it));
    }

    @Contract(pure=true)
    private static boolean needSemicolonAtContextEnd(@NotNull ContextType block) {
        return block == ContextType.ClassCPP || block == ContextType.StructLike || block == ContextType.ConceptCPP || block == ContextType.EqualExpression;
    }

    public static ContextType getContextTypeFromPosition(@NotNull HighlighterIterator it) {
        int inTemplateBrackets = 0;
        int inParens = 0;
        int inSquareBracket = 0;
        boolean functionImpl = false;
        boolean varDecl = false;
        IElementType prevType = null;
        while (!it.atEnd()) {
            IElementType currType = it.getTokenType();
            if (STOPSET.contains(currType)) {
                if (currType != OCTokenTypes.LBRACE || !varDecl) break;
                return ContextType.InitExpression;
            }
            if (inParens == 0 && inSquareBracket == 0) {
                if (currType == OCTokenTypes.GT) {
                    ++inTemplateBrackets;
                } else if (currType == OCTokenTypes.GTGT) {
                    inTemplateBrackets += 2;
                } else if (currType == OCTokenTypes.LT) {
                    --inTemplateBrackets;
                } else if (currType == OCTokenTypes.LTLT) {
                    inTemplateBrackets -= 2;
                } else if (inTemplateBrackets == 0) {
                    if (currType == OCTokenTypes.IDENTIFIER && !functionImpl) {
                        varDecl = true;
                    } else if (currType == OCTokenTypes.COLON || currType == OCTokenTypes.COMMA) {
                        functionImpl = false;
                        varDecl = false;
                    } else if (NON_SEMICOLON_BLOCK_OWNERS.contains(currType)) {
                        if (OCTokenTypes.NAMESPACE_CPP_KEYWORD == currType) {
                            return ContextType.Namespace;
                        }
                        if (OCTokenTypes.SWITCH_KEYWORD == currType) {
                            return ContextType.SwitchStatement;
                        }
                        return ContextType.Statement;
                    }
                }
                if (!(currType != OCTokenTypes.COLON && currType != OCTokenTypes.EQ || prevType != OCTokenTypes.AT && prevType != OCTokenTypes.XOR && prevType != OCTokenTypes.LBRACKET)) {
                    return currType == OCTokenTypes.EQ ? ContextType.EqualExpression : ContextType.Expression;
                }
            }
            if (currType == OCTokenTypes.RBRACKET) {
                ++inSquareBracket;
            } else if (currType == OCTokenTypes.LBRACKET) {
                --inSquareBracket;
            }
            if (currType == OCTokenTypes.RPAR) {
                ++inParens;
            } else if (currType == OCTokenTypes.LPAR) {
                if (inTemplateBrackets == 0) {
                    functionImpl = true;
                    varDecl = false;
                }
                --inParens;
            } else if (inParens == 0 && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(currType)) {
                prevType = currType;
            }
            if (inTemplateBrackets < 0) {
                inTemplateBrackets = 0;
            }
            if (inParens < 0) {
                inParens = 0;
            }
            if (currType == OCTokenTypes.COLON && inTemplateBrackets > 0) {
                inTemplateBrackets = 0;
            }
            if (inTemplateBrackets == 0 && inParens == 0 && OCTokenTypes.COMPOSITE_TYPE_SPECIFIERS.contains(currType)) {
                return functionImpl ? ContextType.Expression : (currType == OCTokenTypes.CLASS_KEYWORD ? ContextType.ClassCPP : ContextType.StructLike);
            }
            if (inTemplateBrackets == 0 && inParens == 0 && currType == OCTokenTypes.CONCEPT_CPP_KEYWORD) {
                return ContextType.ConceptCPP;
            }
            it.retreat();
        }
        return varDecl ? ContextType.EqualExpression : ContextType.Expression;
    }

    private static int skipBlock(@NotNull HighlighterIterator it, @NotNull OCPunctuatorElementType leftBracketType, @NotNull OCPunctuatorElementType rightBracketType) {
        IElementType ttt;
        int parBalance = 0;
        while (!it.atEnd() && (ttt = it.getTokenType()) != null) {
            if (ttt == leftBracketType) {
                ++parBalance;
            } else if (ttt == rightBracketType) {
                --parBalance;
            }
            if (parBalance == 0) break;
            it.advance();
        }
        return parBalance;
    }

    private static void skipWhitespaceForward(@NotNull HighlighterIterator it) {
        while (it.getTokenType() == TokenType.WHITE_SPACE) {
            it.advance();
        }
    }

    private static boolean isNext(@NotNull Editor editor, int offset, @NotNull OCElementType type) {
        Document document2 = editor.getDocument();
        if (offset >= document2.getTextLength()) {
            return false;
        }
        HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(offset);
        return it.getTokenType() == type;
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (c == '#') {
            int offset = editor.getCaretModel().getOffset();
            Document document2 = editor.getDocument();
            if (OCTypedHandlerDelegate.containsWhitespacesOnly(document2.getCharsSequence().subSequence(document2.getLineStartOffset(document2.getLineNumber(offset)), offset))) {
                AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        String text;
        if ((CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && (c == '[' || c == '\'' || c == '\"') || c == '(') && (text = editor.getSelectionModel().getSelectedText()) != null && text.startsWith("<#") && text.endsWith("#>")) {
            EditorModificationUtil.deleteSelectedText((Editor)editor);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Contract(pure=true)
    private static boolean containsWhitespacesOnly(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (Character.isWhitespace(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPosition(@NotNull Editor editor, int offset, int upToOffset) {
        Project project2 = editor.getProject();
        if (project2 == null) {
            return false;
        }
        Document document2 = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (file2 == null) {
            return false;
        }
        OCFile ocFile = OCLanguageUtils.asOCFile(file2);
        if (ocFile == null || !ocFile.getKind().isObjC()) {
            return true;
        }
        StringBuilder builder2 = new StringBuilder(upToOffset - offset + 2);
        if (offset >= upToOffset) {
            return true;
        }
        if (offset >= document2.getTextLength() || upToOffset >= document2.getTextLength()) {
            return true;
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            return false;
        }
        builder2.append('[').append(document2.getCharsSequence().subSequence(offset, upToOffset)).append(']');
        if (!OCTypedHandlerDelegate.hasErrors(builder2, file2)) {
            return true;
        }
        builder2.setLength(builder2.length() - 1);
        builder2.append(" a]");
        return !OCTypedHandlerDelegate.hasErrors(builder2, file2);
    }

    private static boolean hasErrors(@NotNull StringBuilder builder2, @NotNull PsiFile file2) {
        OCExpression expression = OCElementFactory.expressionFromText(builder2.toString(), OCLanguageUtils.asOCFile(file2));
        if (expression == null) {
            return false;
        }
        final boolean[] hasErrors = new boolean[]{false};
        expression.accept(new OCRecursiveVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                hasErrors[0] = true;
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                if (expression.getArguments().size() == 0) {
                    hasErrors[0] = true;
                }
                super.visitSendMessageExpression(expression);
            }
        });
        return hasErrors[0];
    }

    @NotNull
    private static String tokenText(@NotNull Editor editor, @NotNull HighlighterIterator it) {
        return editor.getDocument().getCharsSequence().subSequence(it.getStart(), it.getEnd()).toString();
    }

    static {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        types.add(OCTokenTypes.XOR);
        types.add(OCTokenTypes.SEMICOLON);
        for (BracePair bracePair : OCBraceMatcher.PAIRS) {
            types.add(bracePair.getLeftBraceType());
            types.add(bracePair.getRightBraceType());
        }
        BLOCK_TYPE_STOP_SET = types.toArray(IElementType.EMPTY_ARRAY);
        NUMBER_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.token(OCTokenTypes.INTEGER_LITERAL, OCTokenTypes.FLOAT_LITERAL), OCBackwardRepeatDetector.token(OCTokenTypes.AT));
        STRING_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.repeat(OCBackwardStructureDetector.Cardinality.ONE_OR_MORE, OCBackwardRepeatDetector.token(OCTokenTypes.STRING_LITERAL)), OCBackwardRepeatDetector.token(OCTokenTypes.AT));
        ARRAY_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.block(OCTokenTypes.LBRACKET, OCTokenTypes.RBRACKET), OCBackwardRepeatDetector.token(OCTokenTypes.AT));
        BRACED_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.block(OCTokenTypes.LBRACE, OCTokenTypes.RBRACE), OCBackwardRepeatDetector.or(OCBackwardRepeatDetector.token(OCTokenTypes.AT), OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.repeat(OCBackwardStructureDetector.Cardinality.MAYBE_ONE, OCBackwardRepeatDetector.block(OCTokenTypes.LPAR, OCTokenTypes.RPAR)), OCBackwardRepeatDetector.repeat(OCBackwardStructureDetector.Cardinality.ZERO_OR_MORE, OCBackwardRepeatDetector.tokenExcept(BLOCK_TYPE_STOP_SET)), OCBackwardRepeatDetector.token(OCTokenTypes.XOR))));
        OBJC_LITERAL_DETECTOR = OCBackwardRepeatDetector.or(NUMBER_LITERAL_DETECTOR, STRING_LITERAL_DETECTOR, ARRAY_LITERAL_DETECTOR, BRACED_LITERAL_DETECTOR);
        NON_SEMICOLON_BLOCK_OWNERS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.DO_KEYWORD, OCTokenTypes.ELSE_KEYWORD, OCTokenTypes.FOR_KEYWORD, OCTokenTypes.IF_KEYWORD, OCTokenTypes.SWITCH_KEYWORD, OCTokenTypes.CASE_KEYWORD, OCTokenTypes.DEFAULT_KEYWORD, OCTokenTypes.WHILE_KEYWORD, OCTokenTypes.TRY_KEYWORD, OCTokenTypes.CATCH_KEYWORD, OCTokenTypes.FINALLY_KEYWORD, OCTokenTypes.SYNCHRONIZED_KEYWORD, OCTokenTypes.INTERFACE_KEYWORD, OCTokenTypes.AUTO_RELEASE_POOL_KEYWORD, OCTokenTypes.NAMESPACE_CPP_KEYWORD, OCTokenTypes.IMPLEMENTATION_KEYWORD, OCTokenTypes.PROTOCOL_KEYWORD, OCTokenTypes.LBRACKET});
    }

    public static enum ContextType {
        Namespace,
        ClassCPP,
        StructLike,
        ConceptCPP,
        Expression,
        InitExpression,
        EqualExpression,
        SwitchStatement,
        Statement;

    }
}

