/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesNoCommitDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCCommenter;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class OCEnterInBlockCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final OCCommenter COMMENTER = new OCCommenter();

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!OCLanguageUtils.isSupported(language)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return this.doProcessEnter(file2, editor, caretOffsetRef);
    }

    @NotNull
    protected EnterHandlerDelegate.Result doProcessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef) {
        int caretOffset = (Integer)caretOffsetRef.get();
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
        if (this.shouldBeProcessed(it)) {
            Document document2 = editor.getDocument();
            int commentStart = it.getStart();
            String commentText = document2.getCharsSequence().subSequence(commentStart, it.getEnd()).toString();
            if (commentText.endsWith("*/") && (it.getEnd() <= caretOffset || it.getStart() >= caretOffset)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            int caretInStringOffset = caretOffset - commentStart;
            String commentBeforeCaret = commentText.substring(0, caretInStringOffset);
            StringBuilder indent = new StringBuilder("\n");
            indent.append(OCEnterInBlockCommentHandler.getIndentLine(editor, caretOffset));
            int newCaretPosition = -1;
            int insertCommentSuffixPosition = -1;
            if (commentBeforeCaret.indexOf(10) == -1) {
                Pair<Integer, Integer> info = this.generateComment(file2, editor, caretOffset, commentText, caretInStringOffset, indent);
                insertCommentSuffixPosition = (Integer)info.first;
                newCaretPosition = (Integer)info.second;
            } else {
                caretOffset = OCEnterInBlockCommentHandler.processEnterInsideComment(commentBeforeCaret, caretInStringOffset, commentText, caretOffset, indent);
            }
            this.flushChanges(file2, editor, caretOffset, commentText, commentStart, caretInStringOffset, insertCommentSuffixPosition, indent);
            if (newCaretPosition == -1) {
                newCaretPosition = caretOffset + indent.length();
            }
            editor.getCaretModel().moveToOffset(newCaretPosition);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean shouldBeProcessed(HighlighterIterator it) {
        return !it.atEnd() && it.getTokenType() == OCCommenter.COMMENT_TOKEN_TYPE;
    }

    protected Pair<Integer, Integer> generateComment(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int caretInStringOffset, @NotNull StringBuilder indent) {
        indent.append("* ");
        int defaultCaretPosition = -1;
        int insertCommentSuffixPosition = -1;
        if (OCEnterInBlockCommentHandler.needCommentSuffixGeneration(file2, editor, caretOffset, commentText, ch -> Character.isJavaIdentifierPart(ch.charValue()) || "{}".indexOf(ch.charValue()) >= 0)) {
            int lineEnd = commentText.indexOf(10) != -1 ? commentText.indexOf(10) : commentText.length();
            insertCommentSuffixPosition = caretOffset + indent.length() + (lineEnd - caretInStringOffset);
        }
        return Pair.create((Object)insertCommentSuffixPosition, (Object)defaultCaretPosition);
    }

    protected void flushChanges(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int commentStart, int caretInStringOffset, int insertCommentSuffixPosition, @NotNull StringBuilder indent) {
        Document document2 = editor.getDocument();
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            int deleteTo = caretInStringOffset;
            while (deleteTo < commentText.length() && "\t ".indexOf(commentText.charAt(deleteTo)) >= 0) {
                ++deleteTo;
                --insertCommentSuffixPosition;
            }
            document2.deleteString(caretOffset, commentStart + deleteTo);
        }
        document2.insertString(caretOffset, (CharSequence)indent);
        if (insertCommentSuffixPosition >= 0) {
            StringBuilder insert = new StringBuilder("\n").append(OCEnterInBlockCommentHandler.getIndentLine(editor, caretOffset)).append("*/");
            document2.insertString(insertCommentSuffixPosition, (CharSequence)insert);
        }
    }

    public static boolean needCommentSuffixGeneration(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, @NotNull Predicate<Character> isNotAcceptedSymbol) {
        char ch;
        if (OCEnterInBlockCommentHandler.isCommentComplete(file2, editor, caretOffset, commentText, COMMENTER)) {
            return false;
        }
        for (int offset = 0; offset < commentText.length() && (ch = commentText.charAt(offset)) != '\n'; ++offset) {
            if (!isNotAcceptedSymbol.test(Character.valueOf(ch))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCommentComplete(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, @NotNull CodeDocumentationAwareCommenter commenter) {
        JavaLikeQuoteHandler javaLikeQuoteHandler;
        String expectedCommentEnd;
        boolean docComment = commentText.startsWith(commenter.getDocumentationCommentPrefix());
        String string = expectedCommentEnd = docComment ? commenter.getDocumentationCommentSuffix() : commenter.getBlockCommentSuffix();
        if (!commentText.endsWith(expectedCommentEnd)) {
            return false;
        }
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault();
        String commentPrefix = docComment ? commenter.getDocumentationCommentPrefix() : commenter.getBlockCommentPrefix();
        lexer.start(commentText, commentPrefix == null ? 0 : commentPrefix.length(), commentText.length());
        QuoteHandler fileTypeHandler = TypedHandler.getQuoteHandler((PsiFile)file2, (Editor)editor);
        JavaLikeQuoteHandler javaLikeQuoteHandler2 = javaLikeQuoteHandler = fileTypeHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeHandler : null;
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (javaLikeQuoteHandler != null && javaLikeQuoteHandler.getStringTokenTypes() != null && javaLikeQuoteHandler.getStringTokenTypes().contains(tokenType)) {
                String text = commentText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
                int endOffset = it.getEnd();
                if (text.endsWith(expectedCommentEnd) && endOffset < file2.getTextLength() && file2.getText().charAt(endOffset) == '\n') {
                    return true;
                }
            }
            if (tokenType == commenter.getDocumentationCommentTokenType() || tokenType == commenter.getBlockCommentTokenType()) {
                return false;
            }
            if (tokenType == commenter.getLineCommentTokenType() && commentPrefix != null && lexer.getTokenText().contains(commentPrefix)) {
                return false;
            }
            if (lexer.getTokenEnd() == commentText.length()) {
                if (tokenType == commenter.getLineCommentTokenType()) {
                    String prefix = commenter.getLineCommentPrefix();
                    lexer.start(commentText, lexer.getTokenStart() + (prefix == null ? 0 : prefix.length()), commentText.length());
                    lexer.advance();
                    continue;
                }
                return true;
            }
            lexer.advance();
        }
        return false;
    }

    private static int processEnterInsideComment(@NotNull String commentBeforeCaret, int caretInStringOffset, @NotNull String commentText, int caretOffset, @NotNull StringBuilder indent) {
        int offsetInCommentString;
        char ch = ' ';
        StringBuilder prevIndent = new StringBuilder("\n");
        for (offsetInCommentString = commentBeforeCaret.lastIndexOf(10) + 1; offsetInCommentString < caretInStringOffset; ++offsetInCommentString) {
            char c = commentText.charAt(offsetInCommentString);
            ch = c;
            if ("\t ".indexOf(c) < 0) break;
            prevIndent.append(ch);
        }
        if (indent.length() < prevIndent.length()) {
            indent.setLength(0);
            indent.append((CharSequence)prevIndent);
        }
        if (ch == '*') {
            int size;
            indent.append('*');
            if (++offsetInCommentString == caretInStringOffset && offsetInCommentString < commentText.length()) {
                ch = commentText.charAt(offsetInCommentString);
                if ("\t ".indexOf(ch) >= 0) {
                    ++caretOffset;
                    indent.append(ch);
                }
            } else {
                while (offsetInCommentString < caretInStringOffset && "\t ".indexOf(ch = commentText.charAt(offsetInCommentString)) >= 0) {
                    ++offsetInCommentString;
                    indent.append(ch);
                }
            }
            if ((size = indent.length()) != 0 && indent.charAt(size - 1) == '*') {
                indent.append(' ');
            }
        }
        return caretOffset;
    }

    @NotNull
    public static String getFirstCommentLineIndentFromContext(@NotNull Editor editor, int caretOffset) {
        String indentSpace = "";
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
        it.retreat();
        if (!it.atEnd() && OCTokenTypes.WHITESPACES.contains(it.getTokenType())) {
            String whiteSpaces = editor.getDocument().getCharsSequence().subSequence(it.getStart(), it.getEnd()).toString();
            int lineStart = whiteSpaces.lastIndexOf(10);
            if (lineStart >= 0) {
                indentSpace = whiteSpaces.substring(lineStart + 1);
            } else if (it.getStart() == 0) {
                indentSpace = whiteSpaces;
            }
        }
        return indentSpace;
    }

    @NotNull
    public static String customSettingsIndent(@NotNull Editor editor) {
        if (((OCCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(OCCodeStyleSettings.class)).INDENT_BLOCK_COMMENT) {
            return " ";
        }
        return "";
    }

    @NotNull
    public static String getIndentLine(@NotNull Editor editor, int caretOffset) {
        return OCEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(editor, caretOffset) + OCEnterInBlockCommentHandler.customSettingsIndent(editor);
    }
}

