/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor) {
    }

    public boolean charDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor) {
        HighlighterIterator it;
        if (!OCLanguageUtils.isSupported(file2)) {
            return false;
        }
        Document document2 = editor.getDocument();
        CharSequence text = document2.getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        if (c == '{' && offset + 1 < text.length() && text.charAt(offset) == '}' && text.charAt(offset + 1) == ';' && OCTypedHandlerDelegate.needSemicolonAtContextEnd(it = ((EditorEx)editor).getHighlighter().createIterator(offset - 1))) {
            document2.deleteString(offset, offset + 2);
            return true;
        }
        if (OCBackspaceHandlerDelegate.atEmptyIncludeDirectiveContents(c, editor, text, offset)) {
            document2.deleteString(offset, offset + 1);
            return true;
        }
        return false;
    }

    private static boolean atEmptyIncludeDirectiveContents(char c, @NotNull Editor editor, @NotNull CharSequence text, int offset) {
        if (c != '\"' && c != '<') {
            return false;
        }
        if (offset < 1 || offset >= text.length()) {
            return false;
        }
        char nextC = text.charAt(offset);
        if (c == '\"' && nextC != '\"' || c == '<' && nextC != '>') {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
        while (!it.atEnd() && editor.getDocument().getLineNumber(it.getStart()) == lineNumber) {
            IElementType tt = it.getTokenType();
            if (OCTokenTypes.FILE_REF_DIRECTIVES.contains(tt)) {
                return true;
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) {
                return false;
            }
            it.retreat();
        }
        return false;
    }
}

