/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDFATuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCContextSensitiveBuilder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAUtils;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.SimplifyInspectionKt;
import com.jetbrains.cidr.lang.legacy.inspections.OCSimplifyInspectionLegacy;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.BDDMemoryOverflowException;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.visitors.VisitorImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAInspectionRunner
implements OCDFAInspection.Runner {
    private static final Logger LOG = Logger.getInstance((String)OCDFAInspectionRunner.class.getName());
    private static final Boolean ENABLE_RML_PROFILING = false;
    private static final Boolean ENABLE_BDD_PROFILING = false;
    private static final Boolean ENABLE_RELATIONS_PROFILING = false;
    public static final Key<Boolean> CONTEXT_SENSITIVITY = Key.create((String)"CONTEXT_SENSITIVITY");
    public static final Key<ProblemsHolder> TEST_PROBLEMS_HOLDER = Key.create((String)"TEST_PROBLEMS_HOLDER");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder) {
        return new PsiElementVisitor(){};
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run(@NotNull OCFile file, @NotNull ProblemsHolder problemsHolder, @NotNull OCDFAInspection inspection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void runAnalysisInParallel(PsiFile file2, Map<Object, Object> options2, boolean contextSensitive, OCDFAUtils.WorkingTimeMeasurer measurer, Ref<Result> result2, @NotNull List<ClangDFATuple> input) {
        OCSourceGliderService sourceGliderComponent = OCSourceGliderService.getInstance();
        ManagerInstancesProvider provider2 = sourceGliderComponent.getProvider(false, contextSensitive);
        OCDFAUtils.TuplesConsumer tuplesConsumer = (signature, attributes) -> sourceGliderComponent.getVisitor(false, contextSensitive).addTuple(signature, attributes);
        sourceGliderComponent.addVisitorRunner(false, contextSensitive, (options1, threadCallback) -> new OCContextSensitiveBuilder(provider2.getSymbolTable(), tuplesConsumer, contextSensitive, threadCallback).processTuples(input));
        provider2.init();
        List<Task> plan = provider2.getHypoteticRepository().getRelationBuildPlan("AlwaysTrueStatement", options2);
        if (plan != null) {
            for (Task task2 : plan) {
                if (task2.getName().startsWith("Running")) {
                    ProgressIndicator indicator = OCDFAInspectionRunner.createIndicator();
                    Runnable runnable = () -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                        boolean success = false;
                        try {
                            success = OCDFAInspectionRunner.runTask(file2, measurer, contextSensitive, task2);
                            if (contextSensitive) {
                                OCDFAInspection.printRelationsToLog(provider2);
                            }
                        }
                        finally {
                            Class<Result> clazz = Result.class;
                            synchronized (Result.class) {
                                result2.set((Object)new Result(provider2, success));
                                Result.class.notifyAll();
                                // ** MonitorExit[var7_7] (shouldn't be in output)
                            }
                        }
                    }, indicator);
                    if (contextSensitive) {
                        ApplicationManager.getApplication().executeOnPooledThread(runnable);
                    } else {
                        runnable.run();
                    }
                    return;
                }
                if (OCDFAInspectionRunner.runTask(file2, measurer, contextSensitive, task2)) continue;
                result2.set((Object)new Result(provider2, false));
                return;
            }
        }
        result2.set((Object)new Result(provider2, false));
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    private static boolean runTask(PsiFile file2, final OCDFAUtils.WorkingTimeMeasurer measurer, final boolean contextSensitive, Task task2) {
        long timeStart = System.currentTimeMillis();
        try {
            task2.run(new DummyThreadCallback(){

                @Override
                public boolean checkCancelled() {
                    ProgressManager.checkCanceled();
                    if (measurer.isTimeOver()) {
                        throw new OCDFAUtils.DFAException("DFA time is over" + (contextSensitive ? " (context-sensitive)" : ""));
                    }
                    return false;
                }
            });
        }
        catch (BDDMemoryOverflowException e) {
            OCLog.LOG.warn(file2.getName() + ": " + e.getMessage());
            return false;
        }
        catch (OCDFAUtils.DFAException e) {
            String message = file2.getName() + ": " + e.getMessage();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isInternal()) {
                OCLog.LOG.warn(message);
            } else {
                OCLog.LOG.info(message);
            }
            return false;
        }
        long timeEnd = System.currentTimeMillis();
        ClangUtils.warnClangd(LOG, "DFA task \"" + task2.getName() + "\" finished: " + file2.getName() + " - " + (double)(timeEnd - timeStart) / 1000.0 + " sec");
        return true;
    }

    private void reportTimeOverWarning(ProblemsHolder problemsHolder, OCFile file2, String message) {
        final Ref elementRef = new Ref();
        file2.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)dcl.getNameIdentifier());
                }
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)struct.getNameIdentifier());
                }
            }

            @Override
            public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)functionDefinition.getNameIdentifier());
                }
            }
        });
        if (!elementRef.isNull()) {
            OCInspection.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), (PsiElement)elementRef.get(), message, "CIDR", ProblemHighlightType.WEAK_WARNING, OCDFAInspection.class, new IntentionAction[0]);
        }
    }

    private static boolean processElements(int prefixLen, Consumer<PsiElement[]> consumer, ManagerInstancesProvider provider2, PsiFile file2, String relationName) {
        if (!provider2.getRelationsRepository().containsRelation(relationName)) {
            return false;
        }
        IRelation relation = provider2.getRelationsRepository().getRelation(relationName);
        for (Attribute[] attributes : relation.getAttributes(provider2.getSymbolTable())) {
            PsiElement[] tuple = new PsiElement[prefixLen];
            for (int i2 = 0; i2 < prefixLen; ++i2) {
                tuple[i2] = ClangQuickFixFactoryKt.locatePsiElement(attributes[i2].getKey(), file2.getProject());
            }
            if (!Arrays.stream(tuple).allMatch(e -> e != null)) continue;
            consumer.consume((Object)tuple);
        }
        return true;
    }

    private static boolean getElements(Set<PsiElement> elements, ManagerInstancesProvider provider2, PsiFile file2, String relationName) {
        return OCDFAInspectionRunner.processElements(1, (Consumer<PsiElement[]>)((Consumer)tuple -> elements.add(tuple[0])), provider2, file2, relationName);
    }

    private static List<OCElementsRange> getElementRanges(ManagerInstancesProvider provider2, PsiFile file2, String relationName) {
        ArrayList<OCElementsRange> ranges = new ArrayList<OCElementsRange>();
        OCDFAInspectionRunner.processElements(1, (Consumer<PsiElement[]>)((Consumer)tuple -> {
            PsiElement element = tuple[0];
            OCElementsRange range = new OCElementsRange(element, element);
            range.setContainsCompositeElement(true);
            ranges.add(range.expand());
        }), provider2, file2, relationName);
        return ranges;
    }

    private static Set<PsiElement> getParents(Set<PsiElement> elements) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        for (PsiElement element : elements) {
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                parents.add(parent);
            }
        }
        return parents;
    }

    private void registerWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider2, PsiFile file2, @Nullable Set<PsiElement> excludeElements, String relationName, String message, Class<? extends OCInspection> inspection, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        this.registerWarnings(problemsHolder, provider2, file2, element -> excludeElements != null && excludeElements.contains(element), relationName, 1, (Function<PsiElement[], String>)((Function)element -> message), inspection, highlightType, fixes);
    }

    private void registerWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider2, PsiFile file2, Predicate<PsiElement> excludeElement, String relationName, int elementsInTuple, Function<PsiElement[], String> message, Class<? extends OCInspection> inspection, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        HashSet<PsiElement[]> tuples = new HashSet<PsiElement[]>();
        if (!OCDFAInspectionRunner.processElements(elementsInTuple, (Consumer<PsiElement[]>)((Consumer)tuples::add), provider2, file2, relationName)) {
            return;
        }
        tuples.removeIf(tuple -> Arrays.stream(tuple).anyMatch(excludeElement));
        ArrayList sorted = new ArrayList(tuples);
        ContainerUtil.sort(sorted, Comparator.comparing(tuple -> tuple[elementsInTuple - 1].getTextOffset()));
        for (PsiElement[] tuple2 : sorted) {
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(tuple2[0]) : Collections.emptyList();
            OCInspection.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), tuple2[0], (String)message.fun((Object)tuple2), "CIDR", highlightType, inspection, fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private void registerWarnings(ProblemsHolder problemsHolder, String message, Class<? extends OCInspection> inspection, List<OCElementsRange> ranges, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        for (OCElementsRange range : OCElementsRange.mergeRanges(ranges, false)) {
            PsiElement startElement = range.getFirstElement();
            PsiElement endElement = range.getLastElement();
            while (startElement instanceof OCMacroForeignLeafElement) {
                startElement = startElement.getParent();
            }
            while (endElement instanceof OCMacroForeignLeafElement) {
                endElement = endElement.getParent();
            }
            range = new OCElementsRange(startElement, endElement);
            OCElementsRange trimmedRange = range.trim(TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementsRange.NON_IMPORTANT_TOKENS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON})}));
            if (trimmedRange == null || trimmedRange.isEmpty()) continue;
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)startElement, OCCallable.class);
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(callable) : Collections.emptyList();
            OCInspection.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), range, message, "CIDR", highlightType, inspection, fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static ElementFix getSimplifyFixes(final OCFile file2, final boolean constantCondition) {
        return new ElementFix(){

            public List<IntentionAction> getFixes(@NotNull PsiElement element) {
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                String constant = OCIntType.getAppropriateBool(file2).getValue(constantCondition, OCResolveContext.forPsi(element));
                OCExpression newElement = OCElementFactory.expressionFromText(constant, element, false);
                fixes.add(new OCChangeElementIntentionAction(element, (PsiElement)newElement, "Simplify condition to '" + constant + "'"));
                OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCLoopStatement.class, OCBinaryExpression.class});
                OCElement simplified = null;
                if (parent instanceof OCStatement) {
                    simplified = SimplifyInspectionKt.simplifyStatementWithConstCondition(constantCondition, (OCStatement)parent);
                } else if (parent instanceof OCBinaryExpression) {
                    simplified = OCSimplifyInspectionLegacy.simplifyLogicExpression(constantCondition, (OCBinaryExpression)parent, element);
                }
                if (simplified != null && SimplifyInspectionKt.isSafeToSimplify(parent, simplified)) {
                    fixes.add(SimplifyInspectionKt.getSimplifyFix(parent, simplified));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getInitializeFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement element) {
                OCSymbol symbol = element instanceof OCReferenceElement ? ((OCReferenceElement)element).resolveToSymbol() : null;
                OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
                if (symbol != null && callable != null) {
                    OCInstruction instruction;
                    OCControlFlowGraph graph = new OCControlFlowGraph(callable, null);
                    OCControlFlowBuilder builder2 = new OCControlFlowBuilder(null, graph, null);
                    builder2.processFirstCodeFragment(callable);
                    OCLocalDefinitionsSearcher defSearcher = new OCLocalDefinitionsSearcher(graph, symbol, element.getParent(), false, true, true);
                    defSearcher.process();
                    Collection<OCInstruction> declarators = defSearcher.getInstructionsOfKind(OCInstruction.InstructionKind.DECLARATOR);
                    if (!declarators.isEmpty() && (instruction = declarators.iterator().next()).getRValue() instanceof OCDeclarator) {
                        return Collections.singletonList(new OCAddInitializerIntentionAction((OCDeclarator)instruction.getRValue(), symbol));
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    private static ElementFix getMarkNoreturnFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement callable) {
                OCSymbolWithQualifiedName symbol;
                if (!(!(callable instanceof OCFunctionDeclaration) || (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)callable).getSymbol()) == null || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMainFunction())) {
                    return Collections.singletonList(OCChangeGCCAttributeIntentionAction.noreturn(symbol, callable.getContainingFile()));
                }
                return Collections.emptyList();
            }
        };
    }

    private static ElementFix getRemoveValueFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement element) {
                PsiElement expr = PsiTreeUtil.getParentOfType((PsiElement)element, OCExpression.class, (boolean)false);
                if (expr == null) {
                    return Collections.emptyList();
                }
                PsiElement parent = expr.getParent();
                ArrayList<OCQuickFix> fixes = new ArrayList<OCQuickFix>();
                if (parent instanceof OCCompoundInitializer) {
                    parent = parent.getParent();
                }
                if (parent instanceof OCDeclarator) {
                    fixes.add(new OCRemoveInitializerIntentionAction((OCDeclarator)parent));
                } else {
                    fixes.add(new OCRemoveDeclarationIntentionAction("statement", parent, element.getProject()));
                    fixes.add(new OCRemoveDeclarationButInitializerIntentionAction("statement", parent, element.getProject()));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getRemoveVariableFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement element) {
                OCSymbol symbol = element.getParent() instanceof OCDeclarator ? ((OCDeclarator)element.getParent()).getSymbol() : null;
                ArrayList<OCQuickFix> fixes = new ArrayList<OCQuickFix>();
                if (element.getParent().getParent() instanceof OCStructuredBindingDeclaration) {
                    fixes.add(new OCRemoveDeclarationIntentionAction("structured binding", element.getParent().getParent(), element.getProject()));
                    fixes.add(new OCRemoveDeclarationButInitializerIntentionAction("structured binding", element.getParent().getParent(), element.getProject()));
                    if (symbol != null) {
                        fixes.add(OCChangeGCCAttributeIntentionAction.unused(symbol, "structured binding", element.getContainingFile()));
                    }
                } else if (symbol != null) {
                    if (!(symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() instanceof OCFunctionSymbol && ((OCFunctionSymbol)((OCSymbolWithParent)symbol).getParent()).isMainFunction())) {
                        fixes.add(new OCRemoveDeclarationIntentionAction(symbol, element.getProject()));
                        fixes.add(new OCRemoveDeclarationButInitializerIntentionAction(symbol, element.getProject()));
                    }
                    fixes.add(OCChangeGCCAttributeIntentionAction.unused(symbol, element.getContainingFile()));
                }
                return fixes;
            }
        };
    }

    private static Function<PsiElement[], String> unusedElementMessage() {
        return elements -> {
            PsiElement parent = elements[0].getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            return (symbol != null ? symbol.getKind().getNameUppercase() : "Variable") + " is never used";
        };
    }

    private static Function<PsiElement[], String> onlyAssignedElementMessage() {
        return elements -> {
            PsiElement parent = elements[0].getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            return (symbol != null ? symbol.getKind().getNameUppercase() : "Variable") + " is only assigned but never accessed";
        };
    }

    private static Function<PsiElement[], String> loopConditionNotUpdatedMessage() {
        return elements -> {
            PsiElement parent = elements[1].getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            return (symbol != null ? symbol.getNameWithKindUppercase(OCResolveContext.forPsi(parent)) : "Variable") + " used in loop condition is not updated in the loop";
        };
    }

    private static Function<PsiElement[], String> danglingPointerMessage() {
        return elements -> {
            PsiElement parent = elements[1].getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            return (symbol != null ? symbol.getNameWithKindUppercase(OCResolveContext.forPsi(parent)) : "Variable") + " may point to deallocated memory";
        };
    }

    private static Predicate<PsiElement> excludeUnusedElement(Set<PsiElement> implicitReads) {
        return element -> {
            OCSymbol symbol;
            OCSymbol callableSymbol;
            PsiElement callable;
            if (OCElementUtil.getElementType(element) == OCTokenTypes.COLON) {
                return true;
            }
            OCParameterList parameterList = (OCParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, OCParameterList.class);
            PsiElement psiElement = callable = parameterList != null ? parameterList.getParent() : null;
            if (callable instanceof OCDeclarator) {
                callable = callable.getParent();
            }
            OCSymbol oCSymbol = callableSymbol = callable instanceof OCCallable ? ((OCCallable)callable).getSymbol() : null;
            if (callableSymbol != null) {
                if (callableSymbol.getKind() == OCSymbolKind.BLOCK || callableSymbol.getKind() == OCSymbolKind.LAMBDA) {
                    return true;
                }
                if (callableSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)callableSymbol).isWinMainFunction()) {
                    return true;
                }
            }
            if (element instanceof OCDeclarator) {
                symbol = ((OCDeclarator)element).getSymbol();
            } else if (element.getParent() instanceof OCDeclarator) {
                symbol = ((OCDeclarator)element.getParent()).getSymbol();
            } else {
                return false;
            }
            if (symbol != null && symbol.isUnused()) {
                return true;
            }
            if (implicitReads.contains(element)) {
                return false;
            }
            if (element.getParent().getParent() instanceof OCStructuredBindingDeclaration) {
                return false;
            }
            if (symbol instanceof OCDeclaratorSymbol) {
                boolean isLocalVariable = symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE;
                OCResolveContext context2 = OCResolveContext.forPsi(element);
                OCType declaratorType = symbol.getType().resolve(context2);
                if (declaratorType instanceof OCStructType) {
                    OCStructSymbol structSymbol = ((OCStructType)declaratorType).getSymbol();
                    return structSymbol.isUnused() || isLocalVariable && !structSymbol.hasTrivialDestructor(context2);
                }
                return isLocalVariable && declaratorType instanceof OCTypeParameterType;
            }
            return false;
        };
    }

    @NotNull
    private static List<ClangDFATuple> readTuplesFromJson(String inputPath) throws IOException {
        String json = FileUtil.loadFile((File)new File(inputPath));
        JsonObject rootObject = JsonParser.parseString((String)json).getAsJsonObject();
        JsonObject params = rootObject.get("params").getAsJsonObject();
        JsonArray tuplesObj = params.get("tuples").getAsJsonArray();
        return ContainerUtil.map((Iterable)tuplesObj, element -> {
            JsonObject object = element.getAsJsonObject();
            String relation = object.get("relation").getAsString();
            List attributes = ContainerUtil.map((Iterable)object.get("attributes").getAsJsonArray(), JsonElement::getAsString);
            return new ClangDFATuple(relation, attributes);
        });
    }

    public static String runStandalone(String inputPath, HashMap<Object, Object> options2, boolean logEnabled, boolean printBddNodes) throws IOException {
        List<ClangDFATuple> tuples = OCDFAInspectionRunner.readTuplesFromJson(inputPath);
        DummyThreadCallback threadCallback = new DummyThreadCallback();
        ManagerInstancesProvider provider2 = OCSourceGliderService.createProvider(false, logEnabled, (symbolTable, visitor, options1, threadCallback1) -> new OCContextSensitiveBuilder(symbolTable, (signature, attributes) -> visitor.addTuple(signature, attributes), true, threadCallback1).processTuples(tuples), new ArrayList<VisitorImpl>(), options2);
        List<Task> plan = provider2.getHypoteticRepository().getRelationBuildPlan("AlwaysTrueStatement", options2);
        provider2.init();
        for (Task task2 : plan) {
            task2.run(threadCallback);
        }
        options2.put("BDDStatistics", provider2.getBDDManager().getInfo());
        StringBuilder result2 = new StringBuilder();
        OCDFAInspection.printRelations(provider2, (s1, s2) -> result2.append((String)s1).append("\n").append((String)s2).append("\n"), printBddNodes);
        return result2.toString();
    }

    public static void main(String[] args) throws IOException {
        HashMap<Object, Object> options2 = new HashMap<Object, Object>();
        options2.put(ProfileManager.class, new ProfileManager());
        String path = OCDFAInspectionRunner.class.getResource("profile-sample.txt").getPath();
        OCDFAInspectionRunner.runStandalone(path, options2, true, true);
    }

    private static /* synthetic */ String lambda$run$4(PsiElement[] e) {
        return "The value is never used";
    }

    private static /* synthetic */ boolean lambda$run$3(OCElementsRange r) {
        return r.getFirstElement() != r.getLastElement() || OCElementUtil.getElementType(r.getFirstElement()) != OCTokenTypes.COLON;
    }

    private static /* synthetic */ boolean lambda$run$2(PsiElement e) {
        return false;
    }

    private static /* synthetic */ boolean lambda$run$1(PsiElement e) {
        return false;
    }

    private static /* synthetic */ List lambda$run$0(OCFile file2, ClangParseResponse response) throws Exception {
        if (response == null) {
            return null;
        }
        CompletableFuture<Supplier<List<ClangDFATuple>>> dfaInputFuture = response.getDFAInput();
        ClangUtils.warnClangd(LOG, "Starting clangd DFA: " + file2.getName());
        Supplier<List<ClangDFATuple>> result2 = ClangUtils.waitCancelAware(dfaInputFuture, Long.MAX_VALUE, "dfaInput");
        return result2 != null ? result2.get() : null;
    }

    private static interface ElementFix {
        public List<? extends IntentionAction> getFixes(PsiElement var1);
    }

    private static class Result {
        private final ManagerInstancesProvider myProvider;
        private final boolean myFinishedSuccessfully;

        Result(ManagerInstancesProvider myProvider, boolean finishedSuccessfully) {
            this.myProvider = myProvider;
            this.myFinishedSuccessfully = finishedSuccessfully;
        }

        public ManagerInstancesProvider getProvider() {
            return this.myProvider;
        }

        public boolean isFinishedSuccessfully() {
            return this.myFinishedSuccessfully;
        }
    }
}

