/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCUnreachableCodeFinder
extends OCDataFlowAlgorithm {
    private boolean myReturnReached;
    private boolean myDeadEndReached;
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructionsByType;

    public OCUnreachableCodeFinder(@NotNull OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myDeadEndReached = false;
        this.myInstructionsByType = new MultiMap();
        this.clearProcessedNodes();
        this.traverse(this.myCfg.getStartNode(), null, null, true);
    }

    @Override
    protected void processDeadEnd(@NotNull OCNode node2) {
        this.myDeadEndReached = true;
    }

    public boolean isDeadEndReached() {
        return this.myDeadEndReached;
    }

    public boolean isReturnReached() {
        return this.myReturnReached;
    }

    @NotNull
    public List<OCElementsRange> getUnreachableRanges(boolean mergeRanges) {
        ArrayList<OCNode> unprocessedNodes = new ArrayList<OCNode>();
        for (OCNode node2 : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node2, null) || node2.isFake()) continue;
            unprocessedNodes.add(node2);
        }
        return OCUnreachableCodeFinder.getRanges(unprocessedNodes, mergeRanges);
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node2) {
        if (this.myCfg.getReturnNodes().contains(node2)) {
            this.myReturnReached = true;
        }
        if (node2.getInstructions() != null) {
            for (OCInstruction instruction : node2.getInstructions()) {
                this.myInstructionsByType.putValue((Object)instruction.getKind(), (Object)instruction);
            }
        }
    }

    @NotNull
    public Collection<OCInstruction> getReachableInstructions(@NotNull OCInstruction.InstructionKind kind) {
        return this.myInstructionsByType.get((Object)kind);
    }

    public void clearInstructions() {
        this.myInstructionsByType.clear();
    }
}

