/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInputOutputVariablesFinder
extends OCSingleSymbolAlgorithm {
    private TextRange mySelection;
    private boolean myInput;

    public OCInputOutputVariablesFinder(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol, @Nullable TextRange selection) {
        super(cfg, false, symbol);
        this.mySelection = selection;
    }

    private boolean isSelected(@NotNull OCInstruction instruction) {
        PsiElement element = instruction.getRValue();
        if (element == null) {
            element = instruction.getLValue();
        }
        if (element == null) {
            return false;
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.WRITE && element instanceof OCExpression) {
            element = element.getParent();
        }
        return this.mySelection.contains(OCElementUtil.getRangeWithMacros(element));
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        switch (instruction.getKind()) {
            case READ: 
            case READ_IN_BLOCK: 
            case REFERENCE: {
                if (this.isSelected(instruction)) {
                    OCInstruction declInstruction = this.myCfg.getDeclaratorInstruction(instruction.getSymbol());
                    if (declInstruction != null && !this.isSelected(declInstruction)) {
                        this.myInput = true;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (this.isSelected(instruction)) {
            switch (instruction.getKind()) {
                case REFERENCE: 
                case WRITE: 
                case WRITE_IN_BLOCK: {
                    return true;
                }
                case DECLARATOR: {
                    PsiElement declarator = instruction.getRValue();
                    return declarator instanceof OCDeclarator && ((OCDeclarator)declarator).getResolvedType() instanceof OCStructType;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isInputVariable() {
        return this.myInput;
    }

    public boolean isOutputVariable() {
        return !this.getReachableElements().isEmpty();
    }

    public boolean isWrittenVariable() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction instruction : instructions.values()) {
            if (!this.isEndInstruction(instruction)) continue;
            return true;
        }
        return false;
    }

    public boolean isEscapedDeclarator() {
        if (!this.mySelection.contains(this.mySymbol.getOffset())) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction instruction : instructions.values()) {
            if (this.isSelected(instruction)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public List<PsiReference> getVariableUsages() {
        PsiElement element = this.mySymbol.locateDefinition(this.myCfg.getCodeFragment().getProject());
        if (element == null) {
            return null;
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope())) {
            if (!this.mySelection.contains(reference.getElement().getTextRange())) continue;
            result2.add(reference);
        }
        return result2;
    }
}

