/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlDataKt;
import com.jetbrains.cidr.lang.daemon.clang.tidy.Note;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticMessage;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlReplacement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001b0\u001bH\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticV2;", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnostic;", "()V", "DiagnosticMessage", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticMessage;", "DiagnosticName", "", "Notes", "", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/Note;", "addOffsets", "", "fileToByteOffset", "", "Ljava/util/SortedSet;", "", "appliedToSourceFile", "", "sourceFilePath", "isSuppressed", "isValid", "mapOverlaysToSourceFiles", "overlayMapping", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/OverlayMapping;", "toClangTidyDiagnostic", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyDiagnostic;", "byteToCharOffsetMap", "", "intellij.c"})
public class YamlDiagnosticV2
extends YamlDiagnostic {
    @JvmField
    @Nullable
    public String DiagnosticName;
    @JvmField
    @Nullable
    public YamlDiagnosticMessage DiagnosticMessage;
    @JvmField
    @Nullable
    public List<Note> Notes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        YamlReplacement it;
        CharSequence charSequence = this.DiagnosticName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        if (this.DiagnosticMessage == null) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        if (yamlDiagnosticMessage == null) {
            Intrinsics.throwNpe();
        }
        charSequence = yamlDiagnosticMessage.FilePath;
        bl = false;
        bl2 = false;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl4 = false;
        if (bl4) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage2 == null) {
            Intrinsics.throwNpe();
        }
        charSequence = yamlDiagnosticMessage2.Message;
        bl = false;
        bl2 = false;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl5 = false;
        if (bl5) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage3 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage3 == null) {
            Intrinsics.throwNpe();
        }
        if (yamlDiagnosticMessage3.FileOffset < 0) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage4 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage4 == null) {
            Intrinsics.throwNpe();
        }
        if (yamlDiagnosticMessage4.Replacements == null) return true;
        YamlDiagnosticMessage yamlDiagnosticMessage5 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage5 == null) {
            Intrinsics.throwNpe();
        }
        List<YamlReplacement> list = yamlDiagnosticMessage5.Replacements;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Iterable $this$all$iv = list;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (YamlReplacement)element$iv;
            boolean bl6 = false;
        } while (it.isValid());
        return false;
    }

    @Override
    public boolean isSuppressed() {
        String string = this.DiagnosticName;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.startsWith$default((String)string, (String)"clang-diagnostic", (boolean)false, (int)2, null);
    }

    @Override
    public boolean appliedToSourceFile(@NotNull String sourceFilePath) {
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        if (yamlDiagnosticMessage == null) {
            Intrinsics.throwNpe();
        }
        return FileUtil.pathsEqual((String)yamlDiagnosticMessage.FilePath, (String)sourceFilePath);
    }

    @Override
    public void mapOverlaysToSourceFiles(@NotNull OverlayMapping overlayMapping) {
        File diagnosticFile;
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        if (yamlDiagnosticMessage == null) {
            Intrinsics.throwNpe();
        }
        String string = yamlDiagnosticMessage.FilePath;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (overlayMapping.hasSourceFile(diagnosticFile = new File(string))) {
            if (this.DiagnosticMessage == null) {
                Intrinsics.throwNpe();
            }
            File file2 = overlayMapping.getSourceFile(diagnosticFile);
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            this.DiagnosticMessage.FilePath = file2.getPath();
        }
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage2 == null) {
            Intrinsics.throwNpe();
        }
        List<YamlReplacement> list = yamlDiagnosticMessage2.Replacements;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File replacementFile;
                YamlReplacement it = (YamlReplacement)element$iv;
                boolean bl = false;
                String string2 = it.FilePath;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!overlayMapping.hasSourceFile(replacementFile = new File(string2))) continue;
                File file3 = overlayMapping.getSourceFile(replacementFile);
                if (file3 == null) {
                    Intrinsics.throwNpe();
                }
                it.FilePath = file3.getPath();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ClangTidyDiagnostic toClangTidyDiagnostic(@NotNull Map<String, ? extends Map<Integer, Integer>> byteToCharOffsetMap) {
        List list;
        Object object = this.DiagnosticMessage;
        if (object != null && (object = ((YamlDiagnosticMessage)object).Replacements) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ClangTidyReplacement clangTidyReplacement;
                void it;
                YamlReplacement yamlReplacement = (YamlReplacement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it.toClangTidyReplacement(byteToCharOffsetMap) == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(clangTidyReplacement);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List replacements = list;
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        if (yamlDiagnosticMessage == null) {
            Intrinsics.throwNpe();
        }
        String string = yamlDiagnosticMessage.FilePath;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage2 == null) {
            Intrinsics.throwNpe();
        }
        int offset = ClangTidyYamlDataKt.access$getCharOffset(string, yamlDiagnosticMessage2.FileOffset, byteToCharOffsetMap);
        YamlDiagnosticMessage yamlDiagnosticMessage3 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage3 == null) {
            Intrinsics.throwNpe();
        }
        String string2 = yamlDiagnosticMessage3.Message;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = this.DiagnosticName;
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        YamlDiagnosticMessage yamlDiagnosticMessage4 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage4 == null) {
            Intrinsics.throwNpe();
        }
        String string4 = yamlDiagnosticMessage4.FilePath;
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        return new ClangTidyDiagnostic(string2, string3, string4, offset, replacements, null);
    }

    @Override
    public void addOffsets(@NotNull Map<String, SortedSet<Integer>> fileToByteOffset) {
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        if (yamlDiagnosticMessage == null) {
            Intrinsics.throwNpe();
        }
        String string = yamlDiagnosticMessage.FilePath;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage2 == null) {
            Intrinsics.throwNpe();
        }
        ByteToCharOffsetMapBuilder.Companion.addOffset(string, yamlDiagnosticMessage2.FileOffset, fileToByteOffset);
        YamlDiagnosticMessage yamlDiagnosticMessage3 = this.DiagnosticMessage;
        if (yamlDiagnosticMessage3 == null) {
            Intrinsics.throwNpe();
        }
        List<YamlReplacement> list = yamlDiagnosticMessage3.Replacements;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YamlReplacement it = (YamlReplacement)element$iv;
                boolean bl = false;
                String string2 = it.FilePath;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                ByteToCharOffsetMapBuilder.Companion.addOffset(string2, it.Offset, fileToByteOffset);
                String string3 = it.FilePath;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                ByteToCharOffsetMapBuilder.Companion.addOffset(string3, it.Offset + it.Length, fileToByteOffset);
            }
        }
    }
}

