/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class ClangTidyUtil {
    private ClangTidyUtil() {
    }

    @Nullable
    public static ClangTidyInspection getInspection(@NotNull PsiFile file2, @NotNull Project project2) {
        InspectionProfileEntry tool = ClangTidyUtil.findTool(ClangTidyInspection.getInspectionShortName(), false, file2, project2);
        return tool instanceof ClangTidyInspection ? (ClangTidyInspection)tool : null;
    }

    @NotNull
    public static List<OurClangTidyInspection> getOurInspections(boolean onlyEnabled, @NotNull PsiFile file2, @NotNull Project project2) {
        List<InspectionToolWrapper<?, ?>> tools = ClangTidyUtil.findTools(onlyEnabled, file2, project2);
        ArrayList<OurClangTidyInspection> list = new ArrayList<OurClangTidyInspection>();
        for (InspectionToolWrapper<?, ?> tool : tools) {
            if (tool == null || !(tool.getTool() instanceof OurClangTidyInspection)) continue;
            OurClangTidyInspection toolTool = (OurClangTidyInspection)tool.getTool();
            list.add(toolTool);
        }
        return list;
    }

    @Nullable
    public static ClangTidyInspectionBase findInspectionFromClangTidyDiagnostic(@NotNull ClangTidyDiagnostic diagnostic, @NotNull PsiFile file2, @NotNull Project project2) {
        for (OurClangTidyInspection inspection : ClangTidyUtil.getOurInspections(false, file2, project2)) {
            if (!inspection.getCheckName().equals(diagnostic.getDiagnosticName())) continue;
            return inspection;
        }
        return ClangTidyUtil.getInspection(file2, project2);
    }

    @NotNull
    public static String disableCheck(@NotNull String configuration, @NotNull String checkName) {
        List<String> options2 = ClangTidyUtil.getTrimmedOptions(configuration);
        options2.removeIf(option -> option.equals(checkName));
        if (!ClangTidyUtil.isDisabled(options2, checkName)) {
            options2.add("-" + checkName);
        }
        return StringUtil.join(options2, (String)",");
    }

    @NotNull
    public static String disableGroup(@NotNull String configuration, @NotNull String groupName) {
        List<String> options2 = ClangTidyUtil.getTrimmedOptions(configuration);
        options2.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (!ClangTidyUtil.isDisabled(options2, groupName)) {
            options2.add("-" + groupName + "-*");
        }
        return StringUtil.join(options2, (String)",");
    }

    @Nullable
    public static String getGroupNameForCheck(@NotNull String checkName) {
        int index = checkName.indexOf(45);
        return index != -1 ? checkName.substring(0, index) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompilationDatabase(@NotNull Writer outputWriter, @NotNull String compilerExecutable, @NotNull String compilerWorkingDirectory, @NotNull List<String> compilerOptions, @NotNull String inputFile) throws IOException {
        try (JsonWriter jsonWriter = new JsonWriter(outputWriter);){
            jsonWriter.beginArray();
            jsonWriter.beginObject();
            jsonWriter.name("directory");
            jsonWriter.value(compilerWorkingDirectory);
            jsonWriter.name("arguments");
            jsonWriter.beginArray();
            jsonWriter.value(compilerExecutable);
            for (String compilerOption : compilerOptions) {
                jsonWriter.value(compilerOption);
            }
            jsonWriter.value(inputFile);
            jsonWriter.endArray();
            jsonWriter.name("file");
            jsonWriter.value(inputFile);
            jsonWriter.endObject();
            jsonWriter.endArray();
        }
    }

    private static List<String> getTrimmedOptions(@NotNull String configuration) {
        List options2 = StringUtil.split((String)configuration, (String)",");
        options2.replaceAll(String::trim);
        return options2;
    }

    private static boolean isDisabled(@NotNull List<String> options2, @NotNull String checkName) {
        boolean disabled = false;
        for (String option : options2) {
            if (option.equals("*")) {
                disabled = false;
                continue;
            }
            if (option.equals("-*")) {
                disabled = true;
                continue;
            }
            if (ClangTidyUtil.groupOrCheckEnabled(option, checkName)) {
                disabled = false;
                continue;
            }
            if (!ClangTidyUtil.groupOrCheckDisabled(option, checkName)) continue;
            disabled = true;
        }
        return disabled;
    }

    private static boolean groupOrCheckEnabled(@NotNull String option, @NotNull String checkName) {
        return option.equals(checkName) || option.length() > 1 && option.endsWith("*") && checkName.startsWith(option.substring(0, option.length() - 1));
    }

    private static boolean groupOrCheckDisabled(@NotNull String option, @NotNull String checkName) {
        if (!option.startsWith("-")) {
            return false;
        }
        if (option.endsWith("*")) {
            return option.length() > 2 && checkName.startsWith(option.substring(1, option.length() - 1));
        }
        return option.length() > 1 && checkName.equals(option.substring(1));
    }

    @NotNull
    public static String getClangTidyConfig(@NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty("Checks", checks);
        JsonArray checkOptionsObject = new JsonArray();
        for (ClangTidyCheckOption checkOption : checkOptions) {
            checkOptionsObject.add(ClangTidyUtil.toJsonObject(checkOption));
        }
        rootObject.add("CheckOptions", (JsonElement)checkOptionsObject);
        return rootObject.toString();
    }

    @NotNull
    public static String concatClangTidyChecks(@NotNull String checksA, @NotNull String checksB) {
        List checks = ContainerUtil.concat((List)StringUtil.split((String)checksA, (String)","), (List)StringUtil.split((String)checksB, (String)","));
        return StringUtil.join((Collection)checks, (String)",");
    }

    @Nullable
    public static File getCustomClangTidyPath() {
        return (File)ApplicationManager.getApplication().runReadAction(() -> {
            ClangTidySettings settings = ClangTidySettings.getInstance();
            return settings != null && settings.getUseExternalClangTidy() && settings.getExternalClangTidyPath() != null ? new File(settings.getExternalClangTidyPath()) : null;
        });
    }

    @NotNull
    public static String generateVfsOverlay(@NotNull OverlayMapping mapping) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Map> roots2 = new ArrayList<Map>();
        for (File overlayFile : mapping.getOverlayFiles()) {
            File sourceFile = mapping.getSourceFile(overlayFile);
            if (sourceFile == null) continue;
            File parentDirectory = FileUtil.getParentFile((File)sourceFile);
            Map contents = ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)sourceFile.getName()), (Pair[])new Pair[]{Pair.create((Object)"type", (Object)"file"), Pair.create((Object)"external-contents", (Object)overlayFile.getAbsolutePath())});
            roots2.add(ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)(parentDirectory != null ? parentDirectory.getAbsolutePath() : "")), (Pair[])new Pair[]{Pair.create((Object)"type", (Object)"directory"), Pair.create((Object)"contents", (Object)new Object[]{contents})}));
        }
        data.put("version", "0");
        data.put("roots", roots2.toArray());
        Yaml yaml = new Yaml();
        return yaml.dump(data);
    }

    @NotNull
    private static JsonElement toJsonObject(@NotNull ClangTidyCheckOption check) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("key", check.getOptionName());
        jsonObject.addProperty("value", check.getOptionValue());
        return jsonObject;
    }

    @Nullable
    private static InspectionProfileEntry findTool(@NotNull String inspectionId, boolean onlyEnabled, @NotNull PsiFile file2, @NotNull Project project2) {
        for (InspectionToolWrapper<?, ?> toolWrapper : ClangTidyUtil.findTools(onlyEnabled, file2, project2)) {
            if (toolWrapper == null || !toolWrapper.getID().equals(inspectionId)) continue;
            return toolWrapper.getTool();
        }
        return null;
    }

    @NotNull
    private static List<InspectionToolWrapper<?, ?>> findTools(boolean onlyEnabled, @NotNull PsiFile file2, @NotNull Project project2) {
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project2)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project2);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        if (profile == null) {
            return Collections.emptyList();
        }
        List wrappers = profile.getInspectionTools((PsiElement)file2);
        if (!onlyEnabled) {
            return wrappers;
        }
        ArrayList list = new ArrayList();
        for (InspectionToolWrapper wrapper : wrappers) {
            if (wrapper == null || !profile.isToolEnabled(HighlightDisplayKey.find((String)wrapper.getID()), (PsiElement)file2)) continue;
            list.add(wrapper);
        }
        return list;
    }
}

