/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangTidySuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String myCheckName;
    @NotNull
    private static final Pattern NOLINT_ARGS_PATTERN = Pattern.compile(".*NOLINT\\s*\\((.*)\\).*");

    public ClangTidySuppressIntentionAction(@NotNull String checkName) {
        this.myCheckName = checkName;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor == null) {
            return;
        }
        Document document2 = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        PsiFile file2 = element.getContainingFile();
        int offset = element.getTextOffset();
        int lineEndOffset = DocumentUtil.getLineEndOffset((int)offset, (Document)document2);
        PsiElement elementAtEnd = file2.findElementAt(lineEndOffset - 1);
        if (elementAtEnd instanceof PsiComment) {
            PsiComment commentElement = (PsiComment)elementAtEnd;
            String commentText = elementAtEnd.getText();
            Matcher matcher = NOLINT_ARGS_PATTERN.matcher(commentText);
            if (matcher.find()) {
                String checkNameList = matcher.group(1);
                ClangTidySuppressIntentionAction.insertNoLintComment(checkNameList.trim().isEmpty() ? this.myCheckName : "," + this.myCheckName, commentElement.getTextOffset() + matcher.start(1) + checkNameList.length(), file2, project2);
                return;
            }
            if (commentElement.getTokenType() == OCTokenTypes.EOL_COMMENT) {
                ClangTidySuppressIntentionAction.insertNoLintComment(" NOLINT(" + this.myCheckName + ")", lineEndOffset, file2, project2);
                return;
            }
        }
        ClangTidySuppressIntentionAction.insertNoLintComment(" // NOLINT(" + this.myCheckName + ")", lineEndOffset, file2, project2);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        int offset;
        int lineNumber;
        TextRange lineTextRange;
        if (editor == null || !element.isValid()) {
            return false;
        }
        Document document2 = editor.getDocument();
        String lineText = document2.getText(lineTextRange = DocumentUtil.getLineTextRange((Document)document2, (int)(lineNumber = document2.getLineNumber(offset = element.getTextOffset()))));
        return !lineText.endsWith("\\");
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("inspection.clangTidy.suppress.for.line", new Object[0]);
    }

    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("inspection.clangTidy.suppress.check.for.line", StringUtil.wrapWithDoubleQuote((String)this.myCheckName));
    }

    private static void insertNoLintComment(@NotNull String comment, int offset, @NotNull PsiFile file2, @NotNull Project project2) {
        boolean commitDocument = ApplicationManager.getApplication().isUnitTestMode();
        OCChangeUtil.changeText(project2, file2, offset, 0, comment, commitDocument);
    }
}

