/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.settings.CPPLanguageConfigurable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyConfigurable
extends CPPLanguageConfigurable {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^.*?([\\d]+\\.[\\d]+\\.?[\\d]*).*", 32);
    private static final String TOOL_NAME = "Clang-Tidy";
    private final ClangTidySettings mySettings = ClangTidySettings.getInstance();
    private JBCheckBox myCheckBox;
    private JBTextField myTextField;
    private ProgressIndicator myProgressIndicator;

    @Override
    @NotNull
    public String getId() {
        return "language.cpp.clang-tidy";
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.clangtidy";
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        this.myCheckBox = new JBCheckBox(OCInspectionsBundle.message("configurable.clangTidy.use.external.binary.checkbox", new Object[0]), this.mySettings.getUseExternalClangTidy());
        this.myTextField = new JBTextField(this.mySettings.getExternalClangTidyPath(), 30);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)this.myTextField, OCInspectionsBundle.message("configurable.clangTidy.use.external.binary.path", new Object[0]), "", descriptor);
        final TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton((JTextField)this.myTextField, (ActionListener)browseFilesListener);
        textFieldWithBrowseButton.setEnabled(this.myCheckBox.isSelected());
        this.myCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = ClangTidyConfigurable.this.myCheckBox.isSelected();
                textFieldWithBrowseButton.setEnabled(isSelected);
            }
        });
        JBLabel minClangTidySupportedVersionHint = new JBLabel(OCInspectionsBundle.message("configurable.clangTidy.min.supported.clangTidy.version", new Object[0]));
        minClangTidySupportedVersionHint.setForeground((Color)JBColor.GRAY);
        minClangTidySupportedVersionHint.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        JBLabel builtinClangTidyVersion = new JBLabel();
        builtinClangTidyVersion.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        builtinClangTidyVersion.setCopyable(true);
        builtinClangTidyVersion.setText(OCInspectionsBundle.message("configurable.clangTool.version.checking", TOOL_NAME));
        this.myProgressIndicator = new AbstractProgressIndicatorBase();
        ClangUtils.getClangToolVersionAsync(TOOL_NAME, ClangTidyAnnotator.getBuiltinClangTidyPath().getPath(), this.myProgressIndicator).thenAccept(output -> SwingUtilities.invokeLater(() -> {
            this.myProgressIndicator.checkCanceled();
            Matcher matcher = StringUtil.isNotEmpty((String)output) ? VERSION_PATTERN.matcher((CharSequence)output) : null;
            String versionText = matcher != null && matcher.matches() ? OCInspectionsBundle.message("configurable.clangTool.version", TOOL_NAME, matcher.group(1)) : OCInspectionsBundle.message("configurable.clangTool.version.unable.check", TOOL_NAME);
            builtinClangTidyVersion.setText(versionText);
        }));
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.myCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)textFieldWithBrowseButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)minClangTidySupportedVersionHint, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)builtinClangTidyVersion, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)20, (int)10), 0, 0));
        return panel2;
    }

    public void disposeUIResources() {
        if (this.myProgressIndicator != null && this.myProgressIndicator.isRunning()) {
            this.myProgressIndicator.cancel();
        }
        this.myProgressIndicator = null;
    }

    @Override
    public boolean isModified() {
        return this.myCheckBox.isSelected() != this.mySettings.getUseExternalClangTidy() || !this.myTextField.getText().equals(this.mySettings.getExternalClangTidyPath());
    }

    @Override
    public void apply() throws ConfigurationException {
        this.saveSettings();
        OCInspectionUtil.restartCodeAnalyzer();
    }

    public void reset() {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myCheckBox.setSelected(this.mySettings.getUseExternalClangTidy());
            this.myTextField.setText(this.mySettings.getExternalClangTidyPath());
        });
    }

    @Override
    @Nls
    public String getDisplayName() {
        return OCInspectionsBundle.message("configurable.ClangTidyConfigurable.display.name", new Object[0]);
    }

    private void saveSettings() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.mySettings.setUseExternalClangTidy(this.myCheckBox.isSelected());
            this.mySettings.setExternalClangTidyPath(this.myTextField.getText());
        });
    }
}

