/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClangTidyAnnotationHolder {
    private final State myState;
    private final String myFailReason;
    private final List<ClangTidyDiagnostic> myDiagnostics;

    private ClangTidyAnnotationHolder(@NotNull State state, @NotNull String failReason) {
        this.myState = state;
        this.myFailReason = failReason;
        this.myDiagnostics = null;
    }

    private ClangTidyAnnotationHolder(@NotNull List<ClangTidyDiagnostic> diagnostics2) {
        this.myState = State.SUCCESS;
        this.myFailReason = null;
        this.myDiagnostics = diagnostics2;
    }

    public String getFailReason() {
        return this.myFailReason;
    }

    public List<ClangTidyDiagnostic> getDiagnostics() {
        return this.myDiagnostics;
    }

    public static ClangTidyAnnotationHolder error(@NotNull String reason) {
        return new ClangTidyAnnotationHolder(State.ERROR, reason);
    }

    public static ClangTidyAnnotationHolder warning(@NotNull String reason) {
        return new ClangTidyAnnotationHolder(State.WARNING, reason);
    }

    public static ClangTidyAnnotationHolder success(@NotNull List<ClangTidyDiagnostic> diagnostics2) {
        return new ClangTidyAnnotationHolder(diagnostics2);
    }

    public boolean isError() {
        return this.myState == State.ERROR;
    }

    public boolean isWarning() {
        return this.myState == State.WARNING;
    }

    public boolean isSuccess() {
        return this.myState == State.SUCCESS;
    }

    public boolean isFail() {
        return this.myState != State.SUCCESS;
    }

    private static enum State {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

